/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.concurrent.UnsafeBuffer;

public class TermUnblocker {
    public static Status unblock(UnsafeBuffer unsafeBuffer, UnsafeBuffer unsafeBuffer2, int n2, int n3, int n4) {
        Status status = Status.NO_ACTION;
        int n5 = FrameDescriptor.frameLengthVolatile(unsafeBuffer2, n2);
        if (n5 < 0) {
            TermUnblocker.resetHeader(unsafeBuffer, unsafeBuffer2, n2, n4, -n5);
            status = Status.UNBLOCKED;
        } else if (0 == n5) {
            int n6;
            int n7;
            for (n7 = n2 + 32; n7 < n3; n7 += 32) {
                n5 = FrameDescriptor.frameLengthVolatile(unsafeBuffer2, n7);
                if (n5 == 0) continue;
                if (!TermUnblocker.scanBackToConfirmZeroed(unsafeBuffer2, n7, n2)) break;
                n6 = n7 - n2;
                TermUnblocker.resetHeader(unsafeBuffer, unsafeBuffer2, n2, n4, n6);
                status = Status.UNBLOCKED;
                break;
            }
            if (n7 == unsafeBuffer2.capacity() && 0 == FrameDescriptor.frameLengthVolatile(unsafeBuffer2, n2)) {
                n6 = n7 - n2;
                TermUnblocker.resetHeader(unsafeBuffer, unsafeBuffer2, n2, n4, n6);
                status = Status.UNBLOCKED_TO_END;
            }
        }
        return status;
    }

    private static void resetHeader(UnsafeBuffer unsafeBuffer, UnsafeBuffer unsafeBuffer2, int n2, int n3, int n4) {
        LogBufferDescriptor.applyDefaultHeader(unsafeBuffer, unsafeBuffer2, n2);
        FrameDescriptor.frameType(unsafeBuffer2, n2, 0);
        FrameDescriptor.frameTermOffset(unsafeBuffer2, n2);
        FrameDescriptor.frameTermId(unsafeBuffer2, n2, n3);
        FrameDescriptor.frameLengthOrdered(unsafeBuffer2, n2, n4);
    }

    private static boolean scanBackToConfirmZeroed(UnsafeBuffer unsafeBuffer, int n2, int n3) {
        boolean bl2 = true;
        for (int i2 = n2 - 32; i2 >= n3; i2 -= 32) {
            if (0 == FrameDescriptor.frameLengthVolatile(unsafeBuffer, i2)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static enum Status {
        NO_ACTION,
        UNBLOCKED,
        UNBLOCKED_TO_END;

    }
}

