/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.media.InterfaceSearchAddress;
import io.aeron.driver.media.SocketAddressParser;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class UdpNameResolutionTransport
extends UdpChannelTransport {
    private final UnsafeBuffer unsafeBuffer;
    private final ByteBuffer byteBuffer;

    public UdpNameResolutionTransport(UdpChannel udpChannel, InetSocketAddress inetSocketAddress, UnsafeBuffer unsafeBuffer, MediaDriver.Context context) {
        super(udpChannel, null, inetSocketAddress, null, context);
        this.unsafeBuffer = unsafeBuffer;
        this.byteBuffer = unsafeBuffer.byteBuffer();
    }

    public int poll(UdpFrameHandler udpFrameHandler, long l2) {
        int n2;
        int n3 = 0;
        InetSocketAddress inetSocketAddress = this.receive(this.byteBuffer);
        if (null != inetSocketAddress && this.isValidFrame(this.unsafeBuffer, n2 = this.byteBuffer.position())) {
            this.receiveHook(this.unsafeBuffer, n2, inetSocketAddress);
            n3 = udpFrameHandler.onFrame(this.unsafeBuffer, n2, inetSocketAddress, l2);
        }
        return n3;
    }

    public int sendTo(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        int n2 = byteBuffer.remaining();
        int n3 = 0;
        try {
            if (null != this.sendDatagramChannel && this.sendDatagramChannel.isOpen()) {
                this.sendHook(byteBuffer, inetSocketAddress);
                n3 = this.sendDatagramChannel.send(byteBuffer, inetSocketAddress);
            }
        }
        catch (IOException iOException) {
            UdpNameResolutionTransport.sendError(n2, iOException, inetSocketAddress);
        }
        return n3;
    }

    public InetSocketAddress boundAddress() {
        try {
            return (InetSocketAddress)this.receiveDatagramChannel.getLocalAddress();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InetSocketAddress getInterfaceAddress(String string) {
        try {
            return InterfaceSearchAddress.parse(string).getAddress();
        }
        catch (UnknownHostException unknownHostException) {
            LangUtil.rethrowUnchecked(unknownHostException);
            return null;
        }
    }

    public static InetSocketAddress getInetSocketAddress(String string, NameResolver nameResolver) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = SocketAddressParser.parse(string, "endpoint", false, nameResolver);
            if (inetSocketAddress.isUnresolved()) {
                throw new UnknownHostException("unresolved - endpoint=" + string + ", name-resolver=" + nameResolver.getClass().getName());
            }
        }
        catch (UnknownHostException unknownHostException) {
            LangUtil.rethrowUnchecked(unknownHostException);
        }
        return inetSocketAddress;
    }

    @FunctionalInterface
    public static interface UdpFrameHandler {
        public int onFrame(UnsafeBuffer var1, int var2, InetSocketAddress var3, long var4);
    }
}

