/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.SenderRhsPadding;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.status.DutyCycleStallTracker;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public final class Sender
extends SenderRhsPadding
implements Agent {
    private NetworkPublication[] networkPublications = new NetworkPublication[0];
    private final long statusMessageReadTimeoutNs;
    private final long reResolutionCheckIntervalNs;
    private final int dutyCycleRatio;
    private final ControlTransportPoller controlTransportPoller;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter totalBytesSent;
    private final AtomicCounter resolutionChanges;
    private final NanoClock nanoClock;
    private final CachedNanoClock cachedNanoClock;
    private final DriverConductorProxy conductorProxy;
    private final DutyCycleTracker dutyCycleTracker;

    Sender(MediaDriver.Context context) {
        this.controlTransportPoller = context.controlTransportPoller();
        this.commandQueue = context.senderCommandQueue();
        this.totalBytesSent = context.systemCounters().get(SystemCounterDescriptor.BYTES_SENT);
        this.resolutionChanges = context.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES);
        this.nanoClock = context.nanoClock();
        this.cachedNanoClock = context.senderCachedNanoClock();
        this.statusMessageReadTimeoutNs = context.statusMessageTimeoutNs() >> 1;
        this.reResolutionCheckIntervalNs = context.reResolutionCheckIntervalNs();
        this.dutyCycleRatio = context.sendToStatusMessagePollRatio();
        this.conductorProxy = context.driverConductorProxy();
        this.dutyCycleTracker = context.senderDutyCycleTracker();
    }

    @Override
    public void onStart() {
        long l2 = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(l2);
        this.dutyCycleTracker.update(l2);
        this.reResolutionDeadlineNs = l2 + this.reResolutionCheckIntervalNs;
        if (this.dutyCycleTracker instanceof DutyCycleStallTracker) {
            DutyCycleStallTracker dutyCycleStallTracker = (DutyCycleStallTracker)this.dutyCycleTracker;
            dutyCycleStallTracker.maxCycleTime().appendToLabel(": " + this.conductorProxy.threadingMode().name());
            dutyCycleStallTracker.cycleTimeThresholdExceededCount().appendToLabel(": threshold=" + dutyCycleStallTracker.cycleTimeThresholdNs() + "ns " + this.conductorProxy.threadingMode().name());
        }
    }

    @Override
    public void onClose() {
        this.controlTransportPoller.close();
    }

    @Override
    public int doWork() {
        long l2 = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(l2);
        this.dutyCycleTracker.measureAndUpdate(l2);
        int n2 = this.commandQueue.drain(Runnable::run, 2);
        int n3 = this.doSend(l2);
        int n4 = 0;
        if (0 == n3 || ++this.dutyCycleCounter >= this.dutyCycleRatio || this.controlPollDeadlineNs - l2 < 0L) {
            n4 = this.controlTransportPoller.pollTransports();
            this.dutyCycleCounter = 0;
            this.controlPollDeadlineNs = l2 + this.statusMessageReadTimeoutNs;
        }
        if (this.reResolutionCheckIntervalNs > 0L && this.reResolutionDeadlineNs - l2 < 0L) {
            this.reResolutionDeadlineNs = l2 + this.reResolutionCheckIntervalNs;
            this.controlTransportPoller.checkForReResolutions(l2, this.conductorProxy);
        }
        return n2 + n3 + n4;
    }

    @Override
    public String roleName() {
        return "sender";
    }

    void onRegisterSendChannelEndpoint(SendChannelEndpoint sendChannelEndpoint) {
        sendChannelEndpoint.openChannel(this.conductorProxy);
        sendChannelEndpoint.registerForRead(this.controlTransportPoller);
        sendChannelEndpoint.indicateActive();
    }

    void onCloseSendChannelEndpoint(SendChannelEndpoint sendChannelEndpoint) {
        sendChannelEndpoint.close();
    }

    void onNewNetworkPublication(NetworkPublication networkPublication) {
        this.networkPublications = ArrayUtil.add(this.networkPublications, networkPublication);
        networkPublication.channelEndpoint().registerForSend(networkPublication);
    }

    void onRemoveNetworkPublication(NetworkPublication networkPublication) {
        this.networkPublications = ArrayUtil.remove(this.networkPublications, networkPublication);
        networkPublication.channelEndpoint().unregisterForSend(networkPublication);
        networkPublication.senderRelease();
    }

    void onAddDestination(SendChannelEndpoint sendChannelEndpoint, ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        sendChannelEndpoint.addDestination(channelUri, inetSocketAddress);
    }

    void onRemoveDestination(SendChannelEndpoint sendChannelEndpoint, ChannelUri channelUri, InetSocketAddress inetSocketAddress) {
        sendChannelEndpoint.removeDestination(channelUri, inetSocketAddress);
    }

    void onResolutionChange(SendChannelEndpoint sendChannelEndpoint, String string, InetSocketAddress inetSocketAddress) {
        sendChannelEndpoint.resolutionChange(string, inetSocketAddress);
        this.resolutionChanges.getAndAddOrdered(1L);
    }

    private int doSend(long l2) {
        int n2;
        int n3;
        int n4 = 0;
        NetworkPublication[] networkPublicationArray = this.networkPublications;
        int n5 = networkPublicationArray.length;
        if ((n3 = this.roundRobinIndex++) >= n5) {
            n3 = 0;
            this.roundRobinIndex = 0;
        }
        for (n2 = n3; n2 < n5; ++n2) {
            n4 += networkPublicationArray[n2].send(l2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += networkPublicationArray[n2].send(l2);
        }
        this.totalBytesSent.getAndAddOrdered(n4);
        return n4;
    }
}

