/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tools;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javafx.event.EventHandler;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.PrefixSelectionComboBox;

public class PrefixSelectionCustomizer {
    public static final int DEFAULT_TYPING_DELAY = 500;
    private static final String SELECTION_PREFIX_STRING = "selectionPrefixString";
    private static final Object SELECTION_PREFIX_TASK = "selectionPrefixTask";
    public static final BiFunction<ComboBox, String, Optional> DEFAULT_LOOKUP_COMBOBOX = (comboBox, string) -> {
        if (comboBox == null || string == null || string.isEmpty()) {
            return Optional.empty();
        }
        return comboBox.getItems().stream().filter(Objects::nonNull).filter(object -> {
            String string2;
            String string3 = string2 = comboBox.getConverter() == null ? object.toString() : comboBox.getConverter().toString(object);
            if (string2 != null && !string2.isEmpty()) {
                return string2.toUpperCase(Locale.ROOT).startsWith(string.toUpperCase(Locale.ROOT));
            }
            return false;
        }).findFirst();
    };
    public static final BiFunction<ChoiceBox, String, Optional> DEFAULT_LOOKUP_CHOICEBOX = (choiceBox, string) -> {
        if (choiceBox == null || string == null || string.isEmpty()) {
            return Optional.empty();
        }
        return choiceBox.getItems().stream().filter(Objects::nonNull).filter(object -> {
            String string2;
            String string3 = string2 = choiceBox.getConverter() == null ? object.toString() : choiceBox.getConverter().toString(object);
            if (string2 != null && !string2.isEmpty()) {
                return string2.toUpperCase(Locale.ROOT).startsWith(string.toUpperCase(Locale.ROOT));
            }
            return false;
        }).findFirst();
    };
    private static EventHandler<KeyEvent> handler = new EventHandler<KeyEvent>(){
        private ScheduledExecutorService executorService = null;
        private PrefixSelectionComboBox prefixSelectionComboBox;
        private int typingDelay;
        private Object result;

        public void handle(KeyEvent keyEvent) {
            this.keyPressed(keyEvent);
        }

        private <T> void keyPressed(KeyEvent keyEvent) {
            KeyCode keyCode = keyEvent.getCode();
            if (keyCode.isLetterKey() || keyCode.isDigitKey() || keyCode == KeyCode.SPACE || keyCode == KeyCode.BACK_SPACE) {
                ChoiceBox choiceBox;
                T t2;
                if (keyEvent.getSource() instanceof PrefixSelectionComboBox && keyCode == KeyCode.BACK_SPACE && !((PrefixSelectionComboBox)((Object)keyEvent.getSource())).isBackSpaceAllowed()) {
                    return;
                }
                String string = keyEvent.getText();
                if (keyEvent.getSource() instanceof ComboBox) {
                    ComboBox comboBox = (ComboBox)keyEvent.getSource();
                    T t3 = this.getEntryWithKey(string, (Control)comboBox);
                    if (t3 != null) {
                        comboBox.setValue(t3);
                        ComboBoxListViewSkin comboBoxListViewSkin = (ComboBoxListViewSkin)comboBox.getSkin();
                        ((ListView)comboBoxListViewSkin.getPopupContent()).scrollTo(t3);
                    }
                } else if (keyEvent.getSource() instanceof ChoiceBox && (t2 = this.getEntryWithKey(string, (Control)(choiceBox = (ChoiceBox)keyEvent.getSource()))) != null) {
                    choiceBox.setValue(t2);
                }
            }
        }

        private <T> T getEntryWithKey(String string, Control control) {
            Object object2;
            this.result = null;
            this.typingDelay = 500;
            this.prefixSelectionComboBox = control instanceof PrefixSelectionComboBox ? (PrefixSelectionComboBox)control : null;
            String string2 = this.processInput((String)control.getProperties().get((Object)PrefixSelectionCustomizer.SELECTION_PREFIX_STRING), string);
            control.getProperties().put((Object)PrefixSelectionCustomizer.SELECTION_PREFIX_STRING, (Object)string2);
            if (this.prefixSelectionComboBox != null) {
                this.typingDelay = this.prefixSelectionComboBox.getTypingDelay();
                object2 = this.prefixSelectionComboBox.getLookup();
                if (object2 != null) {
                    object2.apply((ComboBox)this.prefixSelectionComboBox, (String)string2).ifPresent(object -> {
                        this.result = object;
                    });
                }
            } else if (control instanceof ComboBox) {
                DEFAULT_LOOKUP_COMBOBOX.apply((ComboBox)control, string2).ifPresent(object -> {
                    this.result = object;
                });
            } else if (control instanceof ChoiceBox) {
                DEFAULT_LOOKUP_CHOICEBOX.apply((ChoiceBox)control, string2).ifPresent(object -> {
                    this.result = object;
                });
            }
            object2 = (ScheduledFuture)control.getProperties().get(SELECTION_PREFIX_TASK);
            if (object2 != null) {
                object2.cancel(false);
            }
            object2 = this.getExecutorService().schedule(() -> control.getProperties().put((Object)PrefixSelectionCustomizer.SELECTION_PREFIX_STRING, (Object)""), (long)this.typingDelay, TimeUnit.MILLISECONDS);
            control.getProperties().put(SELECTION_PREFIX_TASK, object2);
            return (T)this.result;
        }

        private ScheduledExecutorService getExecutorService() {
            if (this.executorService == null) {
                this.executorService = Executors.newScheduledThreadPool(1, runnable -> {
                    Thread thread = new Thread(runnable);
                    thread.setDaemon(true);
                    return thread;
                });
            }
            return this.executorService;
        }

        private String processInput(String string, String string2) {
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (char c2 : string.concat(string2).toCharArray()) {
                if (c2 == '\b') {
                    if (stringBuilder.length() <= 0) continue;
                    stringBuilder.delete(0, stringBuilder.length());
                    break;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
    };

    public static void customize(ComboBox<?> comboBox) {
        if (!comboBox.isEditable()) {
            comboBox.addEventHandler(KeyEvent.KEY_PRESSED, handler);
        }
        comboBox.editableProperty().addListener((observableValue, bl2, bl3) -> {
            if (!bl3.booleanValue()) {
                comboBox.addEventHandler(KeyEvent.KEY_PRESSED, handler);
            } else {
                comboBox.removeEventHandler(KeyEvent.KEY_PRESSED, handler);
            }
        });
    }

    public static void customize(ChoiceBox<?> choiceBox) {
        choiceBox.addEventHandler(KeyEvent.KEY_PRESSED, handler);
    }
}

