/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2.filter.filtermenubutton;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.tableview2.filter.parser.aggregate.AggregatorsParser;
import impl.org.controlsfx.tableview2.filter.parser.number.NumberParser;
import impl.org.controlsfx.tableview2.filter.parser.string.StringParser;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.util.StringConverter;
import org.controlsfx.control.tableview2.filter.filtermenubutton.FilterMenuButton;

public class DefaultFilterMenuButtonFactory {
    private static final List<Class<?>> PRIMITIVE_NUMERIC_TYPES = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);

    public static FilterMenuButton forClass(Class<?> clazz) {
        if (DefaultFilterMenuButtonFactory.isNumber(clazz)) {
            return new FilterNumberMenuButton();
        }
        return new FilterStringMenuButton();
    }

    private static boolean isNumber(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return Number.class.isAssignableFrom(clazz) || PRIMITIVE_NUMERIC_TYPES.stream().anyMatch(clazz2 -> clazz == clazz2);
    }

    private static class FilterNumberMenuButton
    extends FilterMenuButton {
        private final List<MenuItem> items;
        private NumberParser<? extends Number> operator = new NumberParser();
        private String operatorString = "";

        public FilterNumberMenuButton() {
            this.getStyleClass().add((Object)"filter-menu-button");
            ToggleGroup toggleGroup = new ToggleGroup();
            this.items = this.operator.operators().stream().filter(string -> AggregatorsParser.getStrings().noneMatch(string2 -> string2.equals(string))).map(string -> {
                RadioButton radioButton = new RadioButton(string);
                radioButton.setToggleGroup(toggleGroup);
                return new CustomMenuItem((Node)radioButton);
            }).collect(Collectors.toList());
            this.getItems().addAll(this.items);
            toggleGroup.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
                RadioButton radioButton = (RadioButton)toggle2;
                this.operatorString = radioButton.getText();
                this.buttonText.set((Object)this.operator.getSymbol(this.operatorString));
            });
            ((Toggle)toggleGroup.getToggles().get(0)).setSelected(true);
        }

        public Predicate<? extends Number> parse(String string) {
            return this.operator.parse(this.operatorString + " " + string);
        }

        @Override
        public Predicate<?> parse(String string, StringConverter<?> stringConverter) {
            return this.parse(string);
        }

        @Override
        public String getErrorMessage() {
            return this.operator.getErrorMessage();
        }
    }

    private static class FilterStringMenuButton
    extends FilterMenuButton {
        private final List<MenuItem> items;
        private StringParser<?> operator = new StringParser();
        private String operatorString = "";
        private final CheckBox caseSensitive;

        public FilterStringMenuButton() {
            this.getStyleClass().add((Object)"filter-menu-button");
            this.caseSensitive = new CheckBox(Localization.localize(Localization.asKey("southfilter.menubutton.checkbox.sensitive")));
            CustomMenuItem customMenuItem = new CustomMenuItem((Node)this.caseSensitive);
            customMenuItem.setHideOnClick(false);
            this.getItems().add((Object)customMenuItem);
            this.getItems().add((Object)new SeparatorMenuItem());
            ToggleGroup toggleGroup = new ToggleGroup();
            this.items = this.operator.operators().stream().filter(string -> AggregatorsParser.getStrings().noneMatch(string2 -> string2.equals(string))).map(string -> {
                RadioButton radioButton = new RadioButton(string);
                radioButton.setToggleGroup(toggleGroup);
                return new CustomMenuItem((Node)radioButton);
            }).collect(Collectors.toList());
            this.getItems().addAll(this.items);
            toggleGroup.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> this.updateSymbol((RadioButton)toggle2));
            ((Toggle)toggleGroup.getToggles().get(0)).setSelected(true);
            this.caseSensitive.selectedProperty().addListener((observableValue, bl2, bl3) -> this.updateSymbol((RadioButton)toggleGroup.getSelectedToggle()));
        }

        private void updateSymbol(RadioButton radioButton) {
            this.operator.setCaseSensitive(this.caseSensitive.isSelected());
            this.operatorString = radioButton.getText();
            this.buttonText.set((Object)this.operator.getSymbol(radioButton.getText()));
            this.setTooltip(new Tooltip(this.operatorString + " (" + Localization.localize(Localization.asKey("southfilter.menubutton.sensitive." + (this.caseSensitive.isSelected() ? "enabled" : "disabled"))) + ")"));
        }

        public Predicate parse(String string) {
            return this.parse(string, (StringConverter)null);
        }

        public Predicate<?> parse(String string, StringConverter stringConverter) {
            this.operator.setCaseSensitive(this.caseSensitive.isSelected());
            this.operator.setConverter(stringConverter);
            return this.operator.parse(this.operatorString + " \"" + string + "\"");
        }

        @Override
        public String getErrorMessage() {
            return this.operator.getErrorMessage();
        }
    }
}

