/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.CellViewSkin;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewBehavior;
import impl.org.controlsfx.spreadsheet.GridVirtualFlow;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.HorizontalPicker;
import impl.org.controlsfx.spreadsheet.RectangleSelection;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import impl.org.controlsfx.spreadsheet.VerticalHeader;
import java.time.LocalDate;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.Screen;
import javafx.util.Callback;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridViewSkin
extends TableViewSkinBase<ObservableList<SpreadsheetCell>, ObservableList<SpreadsheetCell>, TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>, TableColumn<ObservableList<SpreadsheetCell>, ?>> {
    public static final double DEFAULT_CELL_HEIGHT = 24.0;
    private static final double DATE_CELL_MIN_WIDTH = 200.0 - Screen.getPrimary().getDpi();
    final Map<GridRow, Set<CellView>> deportedCells = new HashMap<GridRow, Set<CellView>>();
    ObservableMap<Integer, Double> rowHeightMap = FXCollections.observableHashMap();
    private GridCellEditor gridCellEditor;
    protected final SpreadsheetHandle handle;
    protected SpreadsheetView spreadsheetView;
    protected VerticalHeader verticalHeader;
    protected HorizontalPicker horizontalPickers;
    private ObservableSet<Integer> currentlyFixedRow = FXCollections.observableSet(new HashSet());
    private final ObservableList<Integer> selectedRows = FXCollections.observableArrayList();
    private final ObservableList<Integer> selectedColumns = FXCollections.observableArrayList();
    private double fixedRowHeight = 0.0;
    BitSet hBarValue;
    BitSet rowToLayout;
    RectangleSelection rectangleSelection;
    double fixedColumnWidth;
    BooleanProperty lastRowLayout = new SimpleBooleanProperty(true);
    private GridViewBehavior behavior;
    private InvalidationListener rowToLayoutListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridViewSkin.this.rowToLayout = GridViewSkin.this.initRowToLayoutBitSet();
        }
    };
    private final InvalidationListener vbarValueListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridViewSkin.this.verticalScroll();
        }
    };
    private final ListChangeListener<Integer> fixedRowsListener = new ListChangeListener<Integer>(){

        public void onChanged(ListChangeListener.Change<? extends Integer> change) {
            GridViewSkin.this.hBarValue.clear();
            while (change.next()) {
                if (change.wasPermutated()) {
                    for (Integer n2 : change.getList()) {
                        GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n2), true);
                    }
                    continue;
                }
                block2: for (Integer n2 : change.getRemoved()) {
                    GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n2), false);
                    if (GridViewSkin.this.spreadsheetView.getGrid().getRows().size() <= n2) continue;
                    List list = (List)GridViewSkin.this.spreadsheetView.getGrid().getRows().get(n2.intValue());
                    for (SpreadsheetCell spreadsheetCell : list) {
                        if (GridViewSkin.this.spreadsheetView.getRowSpanFilter(spreadsheetCell) <= 1) continue;
                        GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n2), true);
                        continue block2;
                    }
                }
                for (Integer n2 : change.getAddedSubList()) {
                    GridViewSkin.this.rowToLayout.set(GridViewSkin.this.spreadsheetView.getFilteredRow(n2), true);
                }
            }
            GridViewSkin.this.getFlow().requestLayout();
        }
    };
    private final SetChangeListener<? super Integer> currentlyFixedRowListener = new SetChangeListener<Integer>(){

        public void onChanged(SetChangeListener.Change<? extends Integer> change) {
            GridViewSkin.this.computeFixedRowHeight();
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> change) {
            GridViewSkin.this.hBarValue.clear();
            GridViewSkin.this.getFlow().requestLayout();
        }
    };

    public GridViewSkin(final SpreadsheetHandle spreadsheetHandle) {
        super((Control)spreadsheetHandle.getGridView());
        this.behavior = new GridViewBehavior(spreadsheetHandle.getGridView());
        this.handle = spreadsheetHandle;
        this.spreadsheetView = spreadsheetHandle.getView();
        this.gridCellEditor = new GridCellEditor(spreadsheetHandle);
        SpreadsheetGridView spreadsheetGridView = spreadsheetHandle.getGridView();
        spreadsheetGridView.setRowFactory((Callback)new Callback<TableView<ObservableList<SpreadsheetCell>>, TableRow<ObservableList<SpreadsheetCell>>>(){

            public TableRow<ObservableList<SpreadsheetCell>> call(TableView<ObservableList<SpreadsheetCell>> tableView) {
                return new GridRow(spreadsheetHandle);
            }
        });
        this.getVirtualFlow().setCellFactory(virtualFlow -> this.createCell());
        spreadsheetGridView.getStyleClass().add((Object)"cell-spreadsheet");
        this.getCurrentlyFixedRow().addListener(this.currentlyFixedRowListener);
        this.spreadsheetView.getFixedRows().addListener(this.fixedRowsListener);
        this.spreadsheetView.getFixedColumns().addListener(this.fixedColumnsListener);
        this.init();
        spreadsheetHandle.getView().gridProperty().addListener(this.rowToLayoutListener);
        spreadsheetHandle.getView().hiddenRowsProperty().addListener(this.rowToLayoutListener);
        spreadsheetHandle.getView().hiddenColumnsProperty().addListener(this.rowToLayoutListener);
        this.hBarValue = new BitSet(this.getItemCount());
        this.rowToLayout = this.initRowToLayoutBitSet();
        this.computeFixedRowHeight();
        EventHandler eventHandler = mouseEvent -> {
            if (spreadsheetGridView.getEditingCell() != null) {
                spreadsheetGridView.edit(-1, null);
            }
            spreadsheetGridView.requestFocus();
        };
        this.getFlow().getVerticalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.getFlow().getHorizontalBar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        GridViewBehavior gridViewBehavior = this.getBehavior();
        gridViewBehavior.setOnFocusPreviousRow(() -> this.onFocusAboveCell());
        gridViewBehavior.setOnFocusNextRow(() -> this.onFocusBelowCell());
        gridViewBehavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        gridViewBehavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        gridViewBehavior.setOnScrollPageDown(bl2 -> this.onScrollPageDown((boolean)bl2));
        gridViewBehavior.setOnScrollPageUp(bl2 -> this.onScrollPageUp((boolean)bl2));
        gridViewBehavior.setOnSelectPreviousRow(() -> this.onSelectAboveCell());
        gridViewBehavior.setOnSelectNextRow(() -> this.onSelectBelowCell());
        gridViewBehavior.setOnSelectLeftCell(() -> this.onSelectLeftCell());
        gridViewBehavior.setOnSelectRightCell(() -> this.onSelectRightCell());
        gridViewBehavior.setOnFocusLeftCell(() -> this.onFocusLeftCell());
        gridViewBehavior.setOnFocusRightCell(() -> this.onFocusRightCell());
        this.registerChangeListener((ObservableValue)spreadsheetGridView.fixedCellSizeProperty(), observableValue -> this.getFlow().setFixedCellSize(((TableView)this.getSkinnable()).getFixedCellSize()));
    }

    private TableRow<ObservableList<SpreadsheetCell>> createCell() {
        TableRow tableRow = null;
        TableView tableView = (TableView)this.getSkinnable();
        tableRow = (TableRow)tableView.getRowFactory().call((Object)tableView);
        tableRow.updateTableView(tableView);
        return tableRow;
    }

    public double getRowHeight(int n2) {
        if (n2 == -1) {
            return 24.0;
        }
        Double d2 = (Double)this.rowHeightMap.get((Object)this.spreadsheetView.getModelRow(n2));
        if (d2 == null) {
            double d3 = this.handle.getView().getGrid().getRowHeight(this.spreadsheetView.getModelRow(n2));
            return d3 == -1.0 ? 24.0 : d3;
        }
        return d2;
    }

    public double getFixedRowHeight() {
        return this.fixedRowHeight;
    }

    public ObservableList<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    public ObservableList<Integer> getSelectedColumns() {
        return this.selectedColumns;
    }

    public GridCellEditor getSpreadsheetCellEditorImpl() {
        return this.gridCellEditor;
    }

    public GridRow getRowIndexed(int n2) {
        Object object;
        List<?> list = this.getFlow().getCells();
        if (!list.isEmpty() && n2 >= (object = (IndexedCell)list.get(0)).getIndex() && n2 - object.getIndex() < list.size()) {
            return (GridRow)((Object)list.get(n2 - object.getIndex()));
        }
        for (IndexedCell indexedCell : this.getFlow().getFixedCells()) {
            if (indexedCell.getIndex() != n2) continue;
            return (GridRow)indexedCell;
        }
        return null;
    }

    public int getFirstRow(SpreadsheetCell spreadsheetCell, int n2) {
        while (--n2 >= 0 && ((ObservableList)this.spreadsheetView.getItems().get(n2)).get(spreadsheetCell.getColumn()) == spreadsheetCell) {
        }
        return n2 + 1;
    }

    public GridRow getRow(int n2) {
        if (n2 < this.getFlow().getCells().size()) {
            return (GridRow)((Object)this.getFlow().getCells().get(n2));
        }
        return null;
    }

    public final boolean containsRow(int n2) {
        for (Object obj : this.getFlow().getCells()) {
            if (((GridRow)((Object)obj)).getIndex() != n2 || !(((GridRow)((Object)obj)).getLayoutY() >= 0.0)) continue;
            return true;
        }
        return false;
    }

    public int getCellsSize() {
        return this.getFlow().getCells().size();
    }

    public ScrollBar getHBar() {
        if (this.getFlow() != null) {
            return this.getFlow().getHorizontalBar();
        }
        return null;
    }

    public ScrollBar getVBar() {
        return this.getFlow().getVerticalBar();
    }

    public void resizeRowsToFitContent() {
        Grid grid = this.spreadsheetView.getGrid();
        int n2 = this.handle.getView().getGrid().getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!grid.isRowResizable(i2)) continue;
            this.resizeRowToFitContent(i2);
        }
    }

    public void resizeRowToFitContent(int n2) {
        Node node;
        if (((TableView)this.getSkinnable()).getColumns().isEmpty()) {
            return;
        }
        TableColumn tableColumn = (TableColumn)((TableView)this.getSkinnable()).getColumns().get(0);
        ObservableList observableList = this.handle.getGridView().getItems();
        if (observableList == null || observableList.isEmpty()) {
            return;
        }
        if (!this.spreadsheetView.getGrid().isRowResizable(n2)) {
            return;
        }
        Callback callback = tableColumn.getCellFactory();
        if (callback == null) {
            return;
        }
        CellView cellView = (CellView)((Object)callback.call((Object)tableColumn));
        if (cellView == null) {
            return;
        }
        cellView.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        double d2 = 5.0;
        Node node2 = node = cellView.getSkin() == null ? null : cellView.getSkin().getNode();
        if (node instanceof Region) {
            Region region = (Region)node;
            d2 = region.snappedTopInset() + region.snappedBottomInset();
        }
        double d3 = 0.0;
        this.getChildren().add((Object)cellView);
        int n3 = ((TableView)this.getSkinnable()).getColumns().size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TableColumn tableColumn2 = (TableColumn)((TableView)this.getSkinnable()).getColumns().get(i2);
            cellView.updateTableColumn(tableColumn2);
            cellView.updateTableView(this.handle.getGridView());
            cellView.updateIndex(n2);
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)cellView.getItem();
            double d4 = tableColumn2.getWidth();
            if (spreadsheetCell != null && spreadsheetCell.getColumn() == i2 && spreadsheetCell.getColumnSpan() > 1) {
                int n4 = ((TableView)this.getSkinnable()).getVisibleLeafColumns().size() - i2;
                int n5 = spreadsheetCell.getColumnSpan();
                for (int i3 = 1; i3 < n5 && i3 < n4; ++i3) {
                    double d5 = this.snapSize(((TableView)this.getSkinnable()).getVisibleLeafColumn(i2 + i3).getWidth());
                    d4 += d5;
                }
            }
            if (spreadsheetCell == null || spreadsheetCell.getColumn() != i2 || (cellView.getText() == null || cellView.getText().isEmpty()) && cellView.getGraphic() == null) continue;
            cellView.setWrapText(true);
            cellView.applyCss();
            d3 = Math.max(d3, cellView.prefHeight(d4));
        }
        this.getChildren().remove((Object)cellView);
        this.rowHeightMap.put((Object)n2, (Object)(d3 + d2));
        Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.RowHeightEvent(n2, d3 + d2));
        this.rectangleSelection.updateRectangle();
    }

    public void resizeRowsToMaximum() {
        int n2;
        this.resizeRowsToFitContent();
        Grid grid = this.spreadsheetView.getGrid();
        double d2 = 0.0;
        Iterator iterator = this.rowHeightMap.keySet().iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            d2 = Math.max(d2, (Double)this.rowHeightMap.get((Object)n2));
        }
        this.rowHeightMap.clear();
        int n3 = this.handle.getView().getGrid().getRows().size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (!grid.isRowResizable(n2)) continue;
            Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.RowHeightEvent(n2, d2));
            this.rowHeightMap.put((Object)n2, (Object)d2);
        }
        this.rectangleSelection.updateRectangle();
    }

    public void resizeRowsToDefault() {
        double d2;
        this.rowHeightMap.clear();
        Grid grid = this.spreadsheetView.getGrid();
        for (GridRow gridRow : this.getFlow().getCells()) {
            if (!grid.isRowResizable(this.spreadsheetView.getModelRow(gridRow.getIndex()))) continue;
            d2 = gridRow.computePrefHeight(-1.0);
            if (gridRow.getPrefHeight() == d2) continue;
            gridRow.setRowHeight(d2);
            gridRow.requestLayout();
        }
        this.getFlow().layoutChildren();
        for (GridRow gridRow : this.getFlow().getCells()) {
            d2 = this.getRowHeight(this.spreadsheetView.getModelRow(gridRow.getIndex()));
            if (gridRow.getHeight() == d2 || !grid.isRowResizable(this.spreadsheetView.getModelRow(gridRow.getIndex()))) continue;
            gridRow.setRowHeight(d2);
        }
        this.rectangleSelection.updateRectangle();
    }

    public void resizeColumnToFitContent(TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn, int n2) {
        ObservableList<ObservableList<SpreadsheetCell>> observableList;
        Node node;
        TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn2 = tableColumn;
        ObservableList observableList2 = this.handle.getGridView().getItems();
        if (observableList2 == null || observableList2.isEmpty()) {
            return;
        }
        Callback callback = tableColumn2.getCellFactory();
        if (callback == null) {
            return;
        }
        TableCell tableCell = (TableCell)callback.call(tableColumn2);
        if (tableCell == null) {
            return;
        }
        int n3 = this.handle.getGridView().getColumns().indexOf(tableColumn);
        if (n2 == 30 && this.handle.isColumnWidthSet(n3)) {
            return;
        }
        double d2 = ((SpreadsheetColumn)this.spreadsheetView.getColumns().get(n3)).getFilter() != null ? 0.0 : 10.0;
        Node node2 = node = tableCell.getSkin() == null ? null : tableCell.getSkin().getNode();
        if (node instanceof Region) {
            observableList = (ObservableList<ObservableList<SpreadsheetCell>>)node;
            d2 = observableList.snappedLeftInset() + observableList.snappedRightInset();
        }
        tableCell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
        observableList = this.spreadsheetView.getGrid().getRows();
        int n4 = n2 == -1 ? observableList2.size() : Math.min(observableList2.size(), n2 == 30 ? 100 : n2);
        double d3 = 0.0;
        boolean bl2 = false;
        tableCell.updateTableColumn(tableColumn2);
        tableCell.updateTableView((TableView)this.handle.getGridView());
        if (tableCell.getSkin() == null) {
            tableCell.setSkin((Skin)new CellViewSkin((CellView)tableCell));
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            tableCell.updateIndex(i2);
            if ((tableCell.getText() == null || tableCell.getText().isEmpty()) && tableCell.getGraphic() == null) continue;
            this.getChildren().add((Object)tableCell);
            if (((SpreadsheetCell)tableCell.getItem()).getItem() instanceof LocalDate) {
                bl2 = true;
            }
            tableCell.applyCss();
            double d4 = tableCell.prefWidth(-1.0);
            SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)observableList.get(i2)).get(n3);
            if (this.spreadsheetView.getColumnSpan(spreadsheetCell) > 1) {
                for (int i3 = this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()); i3 < this.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()) + this.spreadsheetView.getColumnSpan(spreadsheetCell); ++i3) {
                    if (i3 == n3) continue;
                    d4 -= ((SpreadsheetColumn)this.spreadsheetView.getColumns().get(i3)).getWidth();
                }
            }
            d3 = Math.max(d3, d4);
            this.getChildren().remove((Object)tableCell);
        }
        tableCell.updateIndex(-1);
        double d5 = d3 + d2;
        if (this.handle.getGridView().getColumnResizePolicy() == TableView.CONSTRAINED_RESIZE_POLICY) {
            d5 = Math.max(d5, tableColumn2.getWidth());
        }
        if (bl2 && d5 < DATE_CELL_MIN_WIDTH) {
            d5 = DATE_CELL_MIN_WIDTH;
        }
        d5 = this.snapSize(d5);
        if (tableColumn2.getPrefWidth() != d5 || tableColumn2.getWidth() == d5) {
            tableColumn2.setPrefWidth(d5);
        }
        this.rectangleSelection.updateRectangle();
    }

    protected final void init() {
        this.rectangleSelection = new RectangleSelection(this, (TableViewSpanSelectionModel)this.handle.getGridView().getSelectionModel());
        this.getFlow().getVerticalBar().valueProperty().addListener(this.vbarValueListener);
        this.verticalHeader = new VerticalHeader(this.handle);
        this.getChildren().add((Object)this.verticalHeader);
        ((HorizontalHeader)this.getTableHeaderRow()).init();
        this.verticalHeader.init(this, (HorizontalHeader)this.getTableHeaderRow());
        this.horizontalPickers = new HorizontalPicker((HorizontalHeader)this.getTableHeaderRow(), this.spreadsheetView);
        this.getChildren().add((Object)this.horizontalPickers);
        this.getFlow().init(this.spreadsheetView);
        this.getBehavior().setGridViewSkin(this);
    }

    public GridViewBehavior getBehavior() {
        return this.behavior;
    }

    protected final ObservableSet<Integer> getCurrentlyFixedRow() {
        return this.currentlyFixedRow;
    }

    public ObservableList<TableColumn<ObservableList<SpreadsheetCell>, ?>> getColumns() {
        return this.handle.getGridView().getColumns();
    }

    public void resize(TableColumnBase<?, ?> tableColumnBase, int n2) {
        if (tableColumnBase.isResizable()) {
            int n3 = this.getColumns().indexOf(tableColumnBase);
            TableColumn tableColumn = (TableColumn)this.getColumns().get(n3);
            this.resizeColumnToFitContent(tableColumn, n2);
            Event.fireEvent((EventTarget)this.spreadsheetView, (Event)new SpreadsheetView.ColumnWidthEvent(n3, tableColumn.getWidth()));
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6;
        if (this.spreadsheetView == null) {
            return;
        }
        double d7 = this.verticalHeader.computeHeaderWidth();
        double d8 = d6 = this.spreadsheetView.getColumnPickers().isEmpty() ? 0.0 : 16.0;
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            d2 += d7;
            d4 -= d7;
        } else {
            d2 = 0.0;
        }
        super.layoutChildren(d2, d3 += d6, d4, d5 - d6);
        double d9 = ((TableView)this.getSkinnable()).getLayoutBounds().getHeight() / 2.0;
        double d10 = 0.0;
        if (!this.spreadsheetView.getColumnPickers().isEmpty()) {
            this.layoutInArea((Node)this.horizontalPickers, d2, d3 - 16.0, d4, d10, d9, HPos.CENTER, VPos.CENTER);
        }
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            d10 = this.getTableHeaderRow().prefHeight(-1.0);
            d10 = d10 < 24.0 ? 24.0 : d10;
            this.layoutInArea((Node)this.getTableHeaderRow(), d2, d3, d4, d10, d9, HPos.CENTER, VPos.CENTER);
            d3 += d10;
        }
        if (this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) {
            this.layoutInArea((Node)this.verticalHeader, d2 - d7, d3 - d10, d4, d5, d9, HPos.CENTER, VPos.CENTER);
        }
    }

    protected void onFocusAboveCell() {
        this.focusScroll();
    }

    protected void onFocusBelowCell() {
        this.focusScroll();
    }

    private int getFixedRowSize() {
        int n2 = 0;
        for (Integer n3 : this.spreadsheetView.getFixedRows()) {
            if (this.spreadsheetView.getHiddenRows().get(n3)) continue;
            ++n2;
        }
        return n2;
    }

    void focusScroll() {
        TableView.TableViewFocusModel tableViewFocusModel = this.handle.getGridView().getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        int n2 = tableViewFocusModel.getFocusedIndex();
        this.getFlow().scrollTo(n2);
        this.scrollHorizontally();
    }

    protected void onSelectAboveCell() {
        super.onSelectAboveCell();
        this.scrollHorizontally();
    }

    protected void onSelectBelowCell() {
        super.onSelectBelowCell();
        this.scrollHorizontally();
    }

    protected VirtualFlow<TableRow<ObservableList<SpreadsheetCell>>> createVirtualFlow() {
        return new GridVirtualFlow<TableRow<ObservableList<SpreadsheetCell>>>(this);
    }

    protected TableHeaderRow createTableHeaderRow() {
        return new HorizontalHeader(this);
    }

    public HorizontalHeader getHorizontalHeader() {
        return (HorizontalHeader)this.getTableHeaderRow();
    }

    public void scrollHorizontally() {
        super.scrollHorizontally();
    }

    protected void scrollHorizontally(TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn) {
        if (tableColumn == null || !tableColumn.isVisible()) {
            return;
        }
        this.fixedColumnWidth = 0.0;
        double d2 = this.getFlow().getHorizontalBar().getValue();
        int n2 = this.getColumns().indexOf(tableColumn);
        double d3 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.spreadsheetView.isColumnHidden(i2)) continue;
            SpreadsheetColumn spreadsheetColumn = (SpreadsheetColumn)this.spreadsheetView.getColumns().get(i2);
            if (spreadsheetColumn.isFixed()) {
                this.fixedColumnWidth += spreadsheetColumn.getWidth();
            }
            d3 += spreadsheetColumn.getWidth();
        }
        double d4 = d3 + tableColumn.getWidth();
        double d5 = this.handle.getView().getWidth() - this.snappedLeftInset() - this.snappedRightInset() - this.verticalHeader.getVerticalHeaderWidth();
        double d6 = this.getFlow().getHorizontalBar().getMax();
        if (d3 < d2 + this.fixedColumnWidth && d3 >= 0.0 && d3 >= this.fixedColumnWidth) {
            double d7 = d3 - this.fixedColumnWidth < 0.0 ? d3 : d3 - this.fixedColumnWidth;
            this.getFlow().getHorizontalBar().setValue(d7);
        } else if (d3 > d2 + d5) {
            double d8 = d3 < 0.0 || d4 > d5 ? d3 - d2 - this.fixedColumnWidth : 0.0;
            double d9 = d2 + d8 > d6 ? d6 : d2 + d8;
            this.getFlow().getHorizontalBar().setValue(d9);
        }
    }

    private void verticalScroll() {
        this.verticalHeader.requestLayout();
    }

    GridVirtualFlow<?> getFlow() {
        return (GridVirtualFlow)this.getVirtualFlow();
    }

    private BitSet initRowToLayoutBitSet() {
        int n2 = this.getItemCount();
        BitSet bitSet = new BitSet(n2);
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            if (this.spreadsheetView.getFixedRows().contains((Object)this.spreadsheetView.getModelRow(i2))) {
                bitSet.set(i2);
                continue;
            }
            List list = (List)this.handle.getGridView().getItems().get(i2);
            for (SpreadsheetCell spreadsheetCell : list) {
                if (this.spreadsheetView.getRowSpanFilter(spreadsheetCell) <= 1) continue;
                bitSet.set(i2);
                continue block0;
            }
        }
        return bitSet;
    }

    public void computeFixedRowHeight() {
        this.fixedRowHeight = 0.0;
        Iterator iterator = this.getCurrentlyFixedRow().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this.fixedRowHeight += this.getRowHeight(n2);
        }
    }

    public final int getItemCount() {
        return ((TableView)this.getSkinnable()).getItems() == null ? 0 : ((TableView)this.getSkinnable()).getItems().size();
    }

    public void setHbarValue(double d2) {
        this.setHbarValue(d2, 0);
    }

    public void setHbarValue(double d2, int n2) {
        if (n2 > 5) {
            return;
        }
        int n3 = n2 + 1;
        if (this.getFlow().getScene() == null) {
            Platform.runLater(() -> this.setHbarValue(d2, n3));
            return;
        }
        this.getHBar().setValue(d2);
    }
}

