/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.unmarshaller;

import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.unmarshaller.XmlVisitor;
import com.sun.xml.bind.v2.util.FatalAdapter;
import javax.xml.namespace.NamespaceContext;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.SAXException;

final class ValidatingUnmarshaller
implements XmlVisitor,
XmlVisitor.TextPredictor {
    private final XmlVisitor next;
    private final ValidatorHandler validator;
    private NamespaceContext nsContext = null;
    private final XmlVisitor.TextPredictor predictor;
    private char[] buf = new char[256];

    public ValidatingUnmarshaller(Schema schema, XmlVisitor xmlVisitor) {
        this.validator = schema.newValidatorHandler();
        this.next = xmlVisitor;
        this.predictor = xmlVisitor.getPredictor();
        this.validator.setErrorHandler(new FatalAdapter(this.getContext()));
    }

    @Override
    public void startDocument(LocatorEx locatorEx, NamespaceContext namespaceContext) throws SAXException {
        this.nsContext = namespaceContext;
        this.validator.setDocumentLocator(locatorEx);
        this.validator.startDocument();
        this.next.startDocument(locatorEx, namespaceContext);
    }

    @Override
    public void endDocument() throws SAXException {
        this.nsContext = null;
        this.validator.endDocument();
        this.next.endDocument();
    }

    @Override
    public void startElement(TagName tagName) throws SAXException {
        String string;
        if (this.nsContext != null && (string = tagName.getPrefix().intern()) != "") {
            this.validator.startPrefixMapping(string, this.nsContext.getNamespaceURI(string));
        }
        this.validator.startElement(tagName.uri, tagName.local, tagName.getQname(), tagName.atts);
        this.next.startElement(tagName);
    }

    @Override
    public void endElement(TagName tagName) throws SAXException {
        this.validator.endElement(tagName.uri, tagName.local, tagName.getQname());
        this.next.endElement(tagName);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.validator.startPrefixMapping(string, string2);
        this.next.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this.validator.endPrefixMapping(string);
        this.next.endPrefixMapping(string);
    }

    @Override
    public void text(CharSequence charSequence) throws SAXException {
        int n2 = charSequence.length();
        if (this.buf.length < n2) {
            this.buf = new char[n2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buf[i2] = charSequence.charAt(i2);
        }
        this.validator.characters(this.buf, 0, n2);
        if (this.predictor.expectText()) {
            this.next.text(charSequence);
        }
    }

    @Override
    public UnmarshallingContext getContext() {
        return this.next.getContext();
    }

    @Override
    public XmlVisitor.TextPredictor getPredictor() {
        return this;
    }

    @Override
    @Deprecated
    public boolean expectText() {
        return true;
    }
}

