/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerFloat<BeanT>
extends Lister<BeanT, float[], Float, FloatArrayPack> {
    private PrimitiveArrayListerFloat() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Float.TYPE, new PrimitiveArrayListerFloat());
    }

    @Override
    public ListIterator<Float> iterator(final float[] fArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Float>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < fArray.length;
            }

            @Override
            public Float next() {
                return Float.valueOf(fArray[this.idx++]);
            }
        };
    }

    @Override
    public FloatArrayPack startPacking(BeanT BeanT, Accessor<BeanT, float[]> accessor) {
        return new FloatArrayPack();
    }

    @Override
    public void addToPack(FloatArrayPack floatArrayPack, Float f2) {
        floatArrayPack.add(f2);
    }

    @Override
    public void endPacking(FloatArrayPack floatArrayPack, BeanT BeanT, Accessor<BeanT, float[]> accessor) throws AccessorException {
        accessor.set(BeanT, floatArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, float[]> accessor) throws AccessorException {
        accessor.set(BeanT, new float[0]);
    }

    static final class FloatArrayPack {
        float[] buf = new float[16];
        int size;

        FloatArrayPack() {
        }

        void add(Float f2) {
            if (this.buf.length == this.size) {
                float[] fArray = new float[this.buf.length * 2];
                System.arraycopy(this.buf, 0, fArray, 0, this.buf.length);
                this.buf = fArray;
            }
            if (f2 != null) {
                this.buf[this.size++] = f2.floatValue();
            }
        }

        float[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            float[] fArray = new float[this.size];
            System.arraycopy(this.buf, 0, fArray, 0, this.size);
            return fArray;
        }
    }
}

