/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.ListIterator;
import com.sun.xml.bind.v2.runtime.reflect.Lister;

final class PrimitiveArrayListerBoolean<BeanT>
extends Lister<BeanT, boolean[], Boolean, BooleanArrayPack> {
    private PrimitiveArrayListerBoolean() {
    }

    static void register() {
        Lister.primitiveArrayListers.put(Boolean.TYPE, new PrimitiveArrayListerBoolean());
    }

    @Override
    public ListIterator<Boolean> iterator(final boolean[] blArray, XMLSerializer xMLSerializer) {
        return new ListIterator<Boolean>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < blArray.length;
            }

            @Override
            public Boolean next() {
                return blArray[this.idx++];
            }
        };
    }

    @Override
    public BooleanArrayPack startPacking(BeanT BeanT, Accessor<BeanT, boolean[]> accessor) {
        return new BooleanArrayPack();
    }

    @Override
    public void addToPack(BooleanArrayPack booleanArrayPack, Boolean bl2) {
        booleanArrayPack.add(bl2);
    }

    @Override
    public void endPacking(BooleanArrayPack booleanArrayPack, BeanT BeanT, Accessor<BeanT, boolean[]> accessor) throws AccessorException {
        accessor.set(BeanT, booleanArrayPack.build());
    }

    @Override
    public void reset(BeanT BeanT, Accessor<BeanT, boolean[]> accessor) throws AccessorException {
        accessor.set(BeanT, new boolean[0]);
    }

    static final class BooleanArrayPack {
        boolean[] buf = new boolean[16];
        int size;

        BooleanArrayPack() {
        }

        void add(Boolean bl2) {
            if (this.buf.length == this.size) {
                boolean[] blArray = new boolean[this.buf.length * 2];
                System.arraycopy(this.buf, 0, blArray, 0, this.buf.length);
                this.buf = blArray;
            }
            if (bl2 != null) {
                this.buf[this.size++] = bl2;
            }
        }

        boolean[] build() {
            if (this.buf.length == this.size) {
                return this.buf;
            }
            boolean[] blArray = new boolean[this.size];
            System.arraycopy(this.buf, 0, blArray, 0, this.size);
            return blArray;
        }
    }
}

