/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack;

import com.sun.istack.XMLStreamException2;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLStreamReaderToContentHandler {
    private final XMLStreamReader staxStreamReader;
    private final ContentHandler saxHandler;
    private final boolean eagerQuit;
    private final boolean fragment;
    private final String[] inscopeNamespaces;

    public XMLStreamReaderToContentHandler(XMLStreamReader xMLStreamReader, ContentHandler contentHandler, boolean bl2, boolean bl3) {
        this(xMLStreamReader, contentHandler, bl2, bl3, new String[0]);
    }

    public XMLStreamReaderToContentHandler(XMLStreamReader xMLStreamReader, ContentHandler contentHandler, boolean bl2, boolean bl3, String[] stringArray) {
        this.staxStreamReader = xMLStreamReader;
        this.saxHandler = contentHandler;
        this.eagerQuit = bl2;
        this.fragment = bl3;
        this.inscopeNamespaces = (String[])stringArray.clone();
        assert (stringArray.length % 2 == 0);
    }

    public void bridge() throws XMLStreamException {
        try {
            int n2;
            int n3 = 0;
            int n4 = this.staxStreamReader.getEventType();
            if (n4 == 7) {
                while (!this.staxStreamReader.isStartElement()) {
                    n4 = this.staxStreamReader.next();
                }
            }
            if (n4 != 1) {
                throw new IllegalStateException("The current event is not START_ELEMENT\n but " + n4);
            }
            this.handleStartDocument();
            for (n2 = 0; n2 < this.inscopeNamespaces.length; n2 += 2) {
                this.saxHandler.startPrefixMapping(this.inscopeNamespaces[n2], this.inscopeNamespaces[n2 + 1]);
            }
            block19: do {
                switch (n4) {
                    case 1: {
                        ++n3;
                        this.handleStartElement();
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        if (--n3 != 0 || !this.eagerQuit) break;
                        break block19;
                    }
                    case 4: {
                        this.handleCharacters();
                        break;
                    }
                    case 9: {
                        this.handleEntityReference();
                        break;
                    }
                    case 3: {
                        this.handlePI();
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 10: {
                        this.handleAttribute();
                        break;
                    }
                    case 13: {
                        this.handleNamespace();
                        break;
                    }
                    case 12: {
                        this.handleCDATA();
                        break;
                    }
                    case 15: {
                        this.handleEntityDecl();
                        break;
                    }
                    case 14: {
                        this.handleNotationDecl();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing event: " + n4);
                    }
                }
                n4 = this.staxStreamReader.next();
            } while (n3 != 0);
            for (n2 = 0; n2 < this.inscopeNamespaces.length; n2 += 2) {
                this.saxHandler.endPrefixMapping(this.inscopeNamespaces[n2]);
            }
            this.handleEndDocument();
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleEndDocument() throws SAXException {
        if (this.fragment) {
            return;
        }
        this.saxHandler.endDocument();
    }

    private void handleStartDocument() throws SAXException {
        if (this.fragment) {
            return;
        }
        this.saxHandler.setDocumentLocator(new Locator(){

            @Override
            public int getColumnNumber() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getColumnNumber();
            }

            @Override
            public int getLineNumber() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getLineNumber();
            }

            @Override
            public String getPublicId() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getPublicId();
            }

            @Override
            public String getSystemId() {
                return XMLStreamReaderToContentHandler.this.staxStreamReader.getLocation().getSystemId();
            }
        });
        this.saxHandler.startDocument();
    }

    private void handlePI() throws XMLStreamException {
        try {
            this.saxHandler.processingInstruction(this.staxStreamReader.getPITarget(), this.staxStreamReader.getPIData());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleCharacters() throws XMLStreamException {
        try {
            this.saxHandler.characters(this.staxStreamReader.getTextCharacters(), this.staxStreamReader.getTextStart(), this.staxStreamReader.getTextLength());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleEndElement() throws XMLStreamException {
        QName qName = this.staxStreamReader.getName();
        try {
            String string = qName.getPrefix();
            String string2 = string == null || string.length() == 0 ? qName.getLocalPart() : string + ':' + qName.getLocalPart();
            this.saxHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), string2);
            int n2 = this.staxStreamReader.getNamespaceCount();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                String string3 = this.staxStreamReader.getNamespacePrefix(i2);
                if (string3 == null) {
                    string3 = "";
                }
                this.saxHandler.endPrefixMapping(string3);
            }
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private void handleStartElement() throws XMLStreamException {
        try {
            int n2 = this.staxStreamReader.getNamespaceCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.saxHandler.startPrefixMapping(XMLStreamReaderToContentHandler.fixNull(this.staxStreamReader.getNamespacePrefix(i2)), XMLStreamReaderToContentHandler.fixNull(this.staxStreamReader.getNamespaceURI(i2)));
            }
            QName qName = this.staxStreamReader.getName();
            String string = qName.getPrefix();
            String string2 = string == null || string.length() == 0 ? qName.getLocalPart() : string + ':' + qName.getLocalPart();
            Attributes attributes = this.getAttributes();
            this.saxHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), string2, attributes);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException2(sAXException);
        }
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private Attributes getAttributes() {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n2 = this.staxStreamReader.getEventType();
        if (n2 != 10 && n2 != 1) {
            throw new InternalError("getAttributes() attempting to process: " + n2);
        }
        for (int i2 = 0; i2 < this.staxStreamReader.getAttributeCount(); ++i2) {
            String string = this.staxStreamReader.getAttributeNamespace(i2);
            if (string == null) {
                string = "";
            }
            String string2 = this.staxStreamReader.getAttributeLocalName(i2);
            String string3 = this.staxStreamReader.getAttributePrefix(i2);
            String string4 = string3 == null || string3.length() == 0 ? string2 : string3 + ':' + string2;
            String string5 = this.staxStreamReader.getAttributeType(i2);
            String string6 = this.staxStreamReader.getAttributeValue(i2);
            attributesImpl.addAttribute(string, string2, string4, string5, string6);
        }
        return attributesImpl;
    }

    private void handleNamespace() {
    }

    private void handleAttribute() {
    }

    private void handleDTD() {
    }

    private void handleComment() {
    }

    private void handleEntityReference() {
    }

    private void handleSpace() {
    }

    private void handleNotationDecl() {
    }

    private void handleEntityDecl() {
    }

    private void handleCDATA() {
    }
}

