/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

public class MailcapTokenizer {
    public static final int UNKNOWN_TOKEN = 0;
    public static final int START_TOKEN = 1;
    public static final int STRING_TOKEN = 2;
    public static final int EOI_TOKEN = 5;
    public static final int SLASH_TOKEN = 47;
    public static final int SEMICOLON_TOKEN = 59;
    public static final int EQUALS_TOKEN = 61;
    private String data;
    private int dataIndex;
    private int dataLength;
    private int currentToken;
    private String currentTokenValue;
    private boolean isAutoquoting;
    private char autoquoteChar;

    public MailcapTokenizer(String string) {
        this.data = string;
        this.dataIndex = 0;
        this.dataLength = string.length();
        this.currentToken = 1;
        this.currentTokenValue = "";
        this.isAutoquoting = false;
        this.autoquoteChar = (char)59;
    }

    public void setIsAutoquoting(boolean bl2) {
        this.isAutoquoting = bl2;
    }

    public int getCurrentToken() {
        return this.currentToken;
    }

    public static String nameForToken(int n2) {
        String string = "really unknown";
        switch (n2) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "start";
                break;
            }
            case 2: {
                string = "string";
                break;
            }
            case 5: {
                string = "EOI";
                break;
            }
            case 47: {
                string = "'/'";
                break;
            }
            case 59: {
                string = "';'";
                break;
            }
            case 61: {
                string = "'='";
            }
        }
        return string;
    }

    public String getCurrentTokenValue() {
        return this.currentTokenValue;
    }

    public int nextToken() {
        if (this.dataIndex < this.dataLength) {
            while (this.dataIndex < this.dataLength && MailcapTokenizer.isWhiteSpaceChar(this.data.charAt(this.dataIndex))) {
                ++this.dataIndex;
            }
            if (this.dataIndex < this.dataLength) {
                char c2 = this.data.charAt(this.dataIndex);
                if (this.isAutoquoting) {
                    if (c2 == ';' || c2 == '=') {
                        this.currentToken = c2;
                        this.currentTokenValue = new Character(c2).toString();
                        ++this.dataIndex;
                    } else {
                        this.processAutoquoteToken();
                    }
                } else if (MailcapTokenizer.isStringTokenChar(c2)) {
                    this.processStringToken();
                } else if (c2 == '/' || c2 == ';' || c2 == '=') {
                    this.currentToken = c2;
                    this.currentTokenValue = new Character(c2).toString();
                    ++this.dataIndex;
                } else {
                    this.currentToken = 0;
                    this.currentTokenValue = new Character(c2).toString();
                    ++this.dataIndex;
                }
            } else {
                this.currentToken = 5;
                this.currentTokenValue = null;
            }
        } else {
            this.currentToken = 5;
            this.currentTokenValue = null;
        }
        return this.currentToken;
    }

    private void processStringToken() {
        int n2 = this.dataIndex;
        while (this.dataIndex < this.dataLength && MailcapTokenizer.isStringTokenChar(this.data.charAt(this.dataIndex))) {
            ++this.dataIndex;
        }
        this.currentToken = 2;
        this.currentTokenValue = this.data.substring(n2, this.dataIndex);
    }

    private void processAutoquoteToken() {
        int n2 = this.dataIndex;
        boolean bl2 = false;
        while (this.dataIndex < this.dataLength && !bl2) {
            char c2 = this.data.charAt(this.dataIndex);
            if (c2 != this.autoquoteChar) {
                ++this.dataIndex;
                continue;
            }
            bl2 = true;
        }
        this.currentToken = 2;
        this.currentTokenValue = MailcapTokenizer.fixEscapeSequences(this.data.substring(n2, this.dataIndex));
    }

    private static boolean isSpecialChar(char c2) {
        boolean bl2 = false;
        switch (c2) {
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': {
                bl2 = true;
            }
        }
        return bl2;
    }

    private static boolean isControlChar(char c2) {
        return Character.isISOControl(c2);
    }

    private static boolean isWhiteSpaceChar(char c2) {
        return Character.isWhitespace(c2);
    }

    private static boolean isStringTokenChar(char c2) {
        return !MailcapTokenizer.isSpecialChar(c2) && !MailcapTokenizer.isControlChar(c2) && !MailcapTokenizer.isWhiteSpaceChar(c2);
    }

    private static String fixEscapeSequences(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\\') {
                stringBuffer.append(c2);
                continue;
            }
            if (i2 < n2 - 1) {
                char c3 = string.charAt(i2 + 1);
                stringBuffer.append(c3);
                ++i2;
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

