/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions;

import java.util.function.Supplier;
import javafx.animation.Interpolator;
import javafx.beans.value.WritableValue;

public class JFXKeyValue<T> {
    private WritableValue<T> target;
    private Supplier<WritableValue<T>> targetSupplier;
    private Supplier<T> endValueSupplier;
    private T endValue;
    private Supplier<Boolean> animateCondition = () -> true;
    private Interpolator interpolator;

    private JFXKeyValue() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public T getEndValue() {
        return this.endValue == null ? this.endValueSupplier.get() : this.endValue;
    }

    public WritableValue<T> getTarget() {
        return this.target == null ? this.targetSupplier.get() : this.target;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public boolean isValid() {
        return this.animateCondition == null ? true : this.animateCondition.get();
    }

    public static final class JFXKeyValueBuilder<T> {
        private WritableValue<T> target;
        private Supplier<WritableValue<T>> targetSupplier;
        private Supplier<T> endValueSupplier;
        private T endValue;
        private Supplier<Boolean> animateCondition = () -> true;
        private Interpolator interpolator = Interpolator.EASE_BOTH;

        private JFXKeyValueBuilder() {
        }

        public JFXKeyValueBuilder<T> setTarget(WritableValue<T> writableValue) {
            this.target = writableValue;
            return this;
        }

        public JFXKeyValueBuilder<T> setTargetSupplier(Supplier<WritableValue<T>> supplier) {
            this.targetSupplier = supplier;
            return this;
        }

        public JFXKeyValueBuilder<T> setEndValueSupplier(Supplier<T> supplier) {
            this.endValueSupplier = supplier;
            return this;
        }

        public JFXKeyValueBuilder<T> setEndValue(T t2) {
            this.endValue = t2;
            return this;
        }

        public JFXKeyValueBuilder<T> setAnimateCondition(Supplier<Boolean> supplier) {
            this.animateCondition = supplier;
            return this;
        }

        public JFXKeyValueBuilder<T> setInterpolator(Interpolator interpolator) {
            this.interpolator = interpolator;
            return this;
        }

        public JFXKeyValue<T> build() {
            JFXKeyValue jFXKeyValue = new JFXKeyValue();
            jFXKeyValue.target = this.target;
            jFXKeyValue.interpolator = this.interpolator;
            jFXKeyValue.targetSupplier = this.targetSupplier;
            jFXKeyValue.endValue = this.endValue;
            jFXKeyValue.endValueSupplier = this.endValueSupplier;
            jFXKeyValue.animateCondition = this.animateCondition;
            return jFXKeyValue;
        }
    }

    public static final class Builder {
        public <T> JFXKeyValueBuilder<T> setTarget(WritableValue<T> writableValue) {
            JFXKeyValueBuilder<T> jFXKeyValueBuilder = new JFXKeyValueBuilder<T>();
            jFXKeyValueBuilder.setTarget(writableValue);
            return jFXKeyValueBuilder;
        }

        public <T> JFXKeyValueBuilder<T> setTargetSupplier(Supplier<WritableValue<T>> supplier) {
            JFXKeyValueBuilder<T> jFXKeyValueBuilder = new JFXKeyValueBuilder<T>();
            jFXKeyValueBuilder.setTargetSupplier(supplier);
            return jFXKeyValueBuilder;
        }

        public <T> JFXKeyValueBuilder<T> setEndValueSupplier(Supplier<T> supplier) {
            JFXKeyValueBuilder<T> jFXKeyValueBuilder = new JFXKeyValueBuilder<T>();
            jFXKeyValueBuilder.setEndValueSupplier(supplier);
            return jFXKeyValueBuilder;
        }

        public <T> JFXKeyValueBuilder<T> setEndValue(T t2) {
            JFXKeyValueBuilder<T> jFXKeyValueBuilder = new JFXKeyValueBuilder<T>();
            jFXKeyValueBuilder.setEndValue(t2);
            return jFXKeyValueBuilder;
        }

        public <T> JFXKeyValueBuilder<T> setAnimateCondition(Supplier<Boolean> supplier) {
            JFXKeyValueBuilder jFXKeyValueBuilder = new JFXKeyValueBuilder();
            jFXKeyValueBuilder.setAnimateCondition(supplier);
            return jFXKeyValueBuilder;
        }

        public <T> JFXKeyValueBuilder<T> setInterpolator(Interpolator interpolator) {
            JFXKeyValueBuilder jFXKeyValueBuilder = new JFXKeyValueBuilder();
            jFXKeyValueBuilder.setInterpolator(interpolator);
            return jFXKeyValueBuilder;
        }
    }
}

