/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Path;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

class JFXColorPickerUI
extends Pane {
    private CachedTransition selectorTransition;
    private int pickerSize = 400;
    private int selectorSize = 20;
    private double centerX;
    private double centerY;
    private double huesRadius;
    private double slRadius;
    private double currentHue = 0.0;
    private ImageView huesCircleView;
    private ImageView slCircleView;
    private Pane colorSelector;
    private Pane selector;
    private CurveTransition colorsTransition;
    private ObservableList<Node> colorNodes = FXCollections.observableArrayList();
    private boolean allowColorChange = true;
    private ParallelTransition pTrans;

    public JFXColorPickerUI(int n2) {
        JFXDepthManager.setDepth((Node)this, 1);
        this.pickerSize = n2;
        this.centerX = (double)n2 / 2.0;
        this.centerY = (double)n2 / 2.0;
        double d2 = (double)n2 / 2.0;
        this.huesRadius = d2 * 0.9;
        double d3 = d2 * 0.8;
        double d4 = d2;
        this.slRadius = d2 * 0.7;
        this.huesCircleView = new ImageView(this.getHuesCircle(n2, n2));
        Circle circle = new Circle(this.centerX, this.centerY, d4 - 2.0);
        Circle circle2 = new Circle(this.centerX, this.centerY, d3 + 2.0);
        this.huesCircleView.setClip((Node)Path.subtract((Shape)circle, (Shape)circle2));
        this.getChildren().add((Object)this.huesCircleView);
        Circle circle3 = new Circle(d2 - d3);
        Circle circle4 = new Circle(d2 - this.huesRadius);
        this.colorSelector = new Pane();
        this.colorSelector.setStyle("-fx-border-color:#424242; -fx-border-width:1px; -fx-background-color:rgba(255, 255, 255, 0.87);");
        this.colorSelector.setPrefSize(d2 - d3, d2 - d3);
        this.colorSelector.setShape(Path.subtract((Shape)circle3, (Shape)circle4));
        this.colorSelector.setCache(true);
        this.colorSelector.setMouseTransparent(true);
        this.colorSelector.setPickOnBounds(false);
        this.getChildren().add((Object)this.colorSelector);
        this.huesCircleView.addEventHandler(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            if (this.colorsTransition != null) {
                this.colorsTransition.stop();
            }
            double d2 = mouseEvent.getX() - this.centerX;
            double d3 = mouseEvent.getY() - this.centerY;
            double d4 = Math.atan2(d3, d2);
            double d5 = this.centerX + this.huesRadius * Math.cos(d4);
            double d6 = this.centerY + this.huesRadius * Math.sin(d4);
            this.colorSelector.setRotate(90.0 + Math.toDegrees(Math.atan2(d3, d2)));
            this.colorSelector.setTranslateX(d5 - this.colorSelector.getPrefWidth() / 2.0);
            this.colorSelector.setTranslateY(d6 - this.colorSelector.getPrefHeight() / 2.0);
        });
        this.huesCircleView.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            double d2 = mouseEvent.getX() - this.centerX;
            double d3 = mouseEvent.getY() - this.centerY;
            double d4 = Math.atan2(d3, d2);
            double d5 = this.centerX + this.huesRadius * Math.cos(d4);
            double d6 = this.centerY + this.huesRadius * Math.sin(d4);
            this.colorsTransition = new CurveTransition(new Point2D(this.colorSelector.getTranslateX() + this.colorSelector.getPrefWidth() / 2.0, this.colorSelector.getTranslateY() + this.colorSelector.getPrefHeight() / 2.0), new Point2D(d5, d6));
            this.colorsTransition.play();
        });
        this.colorSelector.translateXProperty().addListener((observableValue, number, number2) -> this.updateHSLCircleColor((int)((double)number2.intValue() + this.colorSelector.getPrefWidth() / 2.0), (int)(this.colorSelector.getTranslateY() + this.colorSelector.getPrefHeight() / 2.0)));
        this.colorSelector.translateYProperty().addListener((observableValue, number, number2) -> this.updateHSLCircleColor((int)(this.colorSelector.getTranslateX() + this.colorSelector.getPrefWidth() / 2.0), (int)((double)number2.intValue() + this.colorSelector.getPrefHeight() / 2.0)));
        this.slCircleView = new ImageView(this.getSLCricle(n2, n2));
        this.slCircleView.setClip((Node)new Circle(this.centerX, this.centerY, this.slRadius - 2.0));
        this.slCircleView.setPickOnBounds(false);
        this.getChildren().add((Object)this.slCircleView);
        this.selector = new Pane();
        Circle circle5 = new Circle((double)(this.selectorSize / 2));
        Circle circle6 = new Circle((double)(this.selectorSize / 2) * 0.5);
        this.selector.setShape(Path.subtract((Shape)circle5, (Shape)circle6));
        this.selector.setStyle("-fx-border-color:#424242; -fx-border-width:1px;-fx-background-color:rgba(255, 255, 255, 0.87);");
        this.selector.setPrefSize((double)this.selectorSize, (double)this.selectorSize);
        this.selector.setMinSize((double)this.selectorSize, (double)this.selectorSize);
        this.selector.setMaxSize((double)this.selectorSize, (double)this.selectorSize);
        this.selector.setCache(true);
        this.selector.setMouseTransparent(true);
        this.getChildren().add((Object)this.selector);
        this.slCircleView.addEventHandler(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            if (this.selectorTransition != null) {
                this.selectorTransition.stop();
            }
            if (Math.pow(mouseEvent.getX() - this.centerX, 2.0) + Math.pow(mouseEvent.getY() - this.centerY, 2.0) < Math.pow(this.slRadius - 2.0, 2.0)) {
                this.selector.setTranslateX(mouseEvent.getX() - this.selector.getPrefWidth() / 2.0);
                this.selector.setTranslateY(mouseEvent.getY() - this.selector.getPrefHeight() / 2.0);
            } else {
                double d2 = mouseEvent.getX() - this.centerX;
                double d3 = mouseEvent.getY() - this.centerY;
                double d4 = Math.atan2(d3, d2);
                double d5 = this.centerX + (this.slRadius - 2.0) * Math.cos(d4);
                double d6 = this.centerY + (this.slRadius - 2.0) * Math.sin(d4);
                this.selector.setTranslateX(d5 - this.selector.getPrefWidth() / 2.0);
                this.selector.setTranslateY(d6 - this.selector.getPrefHeight() / 2.0);
            }
        });
        this.slCircleView.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.selectorTransition = new CachedTransition((Node)this.selector, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.selector.translateXProperty(), (Object)(mouseEvent.getX() - this.selector.getPrefWidth() / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selector.translateYProperty(), (Object)(mouseEvent.getY() - this.selector.getPrefHeight() / 2.0), Interpolator.EASE_BOTH)})})){
                {
                    this.setCycleDuration(Duration.millis((double)160.0));
                    this.setDelay(Duration.seconds((double)0.0));
                }
            };
            this.selectorTransition.play();
        });
        this.selector.translateXProperty().addListener((observableValue, number, number2) -> this.setColorAtLocation(number2.intValue() + this.selectorSize / 2, (int)this.selector.getTranslateY() + this.selectorSize / 2));
        this.selector.translateYProperty().addListener((observableValue, number, number2) -> this.setColorAtLocation((int)this.selector.getTranslateX() + this.selectorSize / 2, number2.intValue() + this.selectorSize / 2));
        double d5 = 20.0 - this.centerX;
        double d6 = 20.0 - this.centerY;
        double d7 = Math.atan2(d6, d5);
        double d8 = this.centerX + this.huesRadius * Math.cos(d7);
        double d9 = this.centerY + this.huesRadius * Math.sin(d7);
        this.colorSelector.setRotate(90.0 + Math.toDegrees(Math.atan2(d6, d5)));
        this.colorSelector.setTranslateX(d8 - this.colorSelector.getPrefWidth() / 2.0);
        this.colorSelector.setTranslateY(d9 - this.colorSelector.getPrefHeight() / 2.0);
        this.selector.setTranslateX(this.centerX - this.selector.getPrefWidth() / 2.0);
        this.selector.setTranslateY(this.centerY - this.selector.getPrefHeight() / 2.0);
    }

    public void addColorSelectionNode(Node ... nodeArray) {
        this.colorNodes.addAll((Object[])nodeArray);
    }

    public void removeColorSelectionNode(Node ... nodeArray) {
        this.colorNodes.removeAll((Object[])nodeArray);
    }

    private void updateHSLCircleColor(int n2, int n3) {
        Color color = this.huesCircleView.getImage().getPixelReader().getColor(n2, n3);
        double d2 = Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue()));
        double d3 = Math.min(color.getRed(), Math.min(color.getGreen(), color.getBlue()));
        double d4 = 0.0;
        if (d2 != d3) {
            double d5 = d2 - d3;
            if (d2 == color.getRed()) {
                d4 = (color.getGreen() - color.getBlue()) / d5 + (double)(color.getGreen() < color.getBlue() ? 6 : 0);
            } else if (d2 == color.getGreen()) {
                d4 = (color.getBlue() - color.getRed()) / d5 + 2.0;
            } else if (d2 == color.getBlue()) {
                d4 = (color.getRed() - color.getGreen()) / d5 + 4.0;
            }
            d4 /= 6.0;
        }
        this.currentHue = this.map(d4, 0.0, 1.0, 0.0, 255.0);
        this.refreshHSLCircle();
    }

    private void refreshHSLCircle() {
        ColorAdjust colorAdjust = new ColorAdjust();
        colorAdjust.setHue(this.map(this.currentHue + (double)(this.currentHue < 127.5 ? 1 : -1) * 127.5, 0.0, 255.0, -1.0, 1.0));
        this.slCircleView.setEffect((Effect)colorAdjust);
        this.setColorAtLocation((int)this.selector.getTranslateX() + this.selectorSize / 2, (int)this.selector.getTranslateY() + this.selectorSize / 2);
    }

    public void moveToColor(Color color) {
        double d2;
        double d3;
        double d4;
        this.allowColorChange = false;
        double d5 = Math.max(color.getRed(), Math.max(color.getGreen(), color.getBlue()));
        double d6 = Math.min(color.getRed(), Math.min(color.getGreen(), color.getBlue()));
        double d7 = 0.0;
        double d8 = (d5 + d6) / 2.0;
        double d9 = 0.0;
        if (d5 == d6) {
            d9 = 0.0;
            d7 = 0.0;
        } else {
            d4 = d5 - d6;
            double d10 = d9 = d8 > 0.5 ? d4 / (2.0 - d5 - d6) : d4 / (d5 + d6);
            if (d5 == color.getRed()) {
                d7 = (color.getGreen() - color.getBlue()) / d4 + (double)(color.getGreen() < color.getBlue() ? 6 : 0);
            } else if (d5 == color.getGreen()) {
                d7 = (color.getBlue() - color.getRed()) / d4 + 2.0;
            } else if (d5 == color.getBlue()) {
                d7 = (color.getRed() - color.getGreen()) / d4 + 4.0;
            }
            d7 /= 6.0;
        }
        this.currentHue = this.map(d7, 0.0, 1.0, 0.0, 255.0);
        d4 = this.map(this.currentHue, 0.0, 255.0, -Math.PI, Math.PI);
        double d11 = this.centerX + this.huesRadius * Math.cos(d4);
        double d12 = this.centerY + this.huesRadius * Math.sin(d4);
        this.colorsTransition = new CurveTransition(new Point2D(this.colorSelector.getTranslateX() + this.colorSelector.getPrefWidth() / 2.0, this.colorSelector.getTranslateY() + this.colorSelector.getPrefHeight() / 2.0), new Point2D(d11, d12));
        d9 = this.map(d9, 0.0, 1.0, 0.0, 255.0);
        d8 = this.map(d8, 0.0, 1.0, 0.0, 255.0);
        Point2D point2D = this.getPointFromSL((int)d9, (int)d8, this.slRadius);
        double d13 = this.centerX - point2D.getX();
        double d14 = this.centerY - point2D.getY();
        if (Math.pow(d13 - this.centerX, 2.0) + Math.pow(d14 - this.centerY, 2.0) < Math.pow(this.slRadius - 2.0, 2.0)) {
            d3 = d13 - this.selector.getPrefWidth() / 2.0;
            d2 = d14 - this.selector.getPrefHeight() / 2.0;
        } else {
            double d15 = d13 - this.centerX;
            double d16 = d14 - this.centerY;
            d4 = Math.atan2(d16, d15);
            d11 = this.centerX + (this.slRadius - 2.0) * Math.cos(d4);
            d12 = this.centerY + (this.slRadius - 2.0) * Math.sin(d4);
            d3 = d11 - this.selector.getPrefWidth() / 2.0;
            d2 = d12 - this.selector.getPrefHeight() / 2.0;
        }
        this.selectorTransition = new CachedTransition((Node)this.selector, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.selector.translateXProperty(), (Object)d3, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.selector.translateYProperty(), (Object)d2, Interpolator.EASE_BOTH)})})){
            {
                this.setCycleDuration(Duration.millis((double)160.0));
                this.setDelay(Duration.seconds((double)0.0));
            }
        };
        if (this.pTrans != null) {
            this.pTrans.stop();
        }
        this.pTrans = new ParallelTransition(new Animation[]{this.colorsTransition, this.selectorTransition});
        this.pTrans.setOnFinished(actionEvent -> {
            if (this.pTrans.getStatus() == Animation.Status.STOPPED) {
                this.allowColorChange = true;
            }
        });
        this.pTrans.play();
        this.refreshHSLCircle();
    }

    private void setColorAtLocation(int n2, int n3) {
        if (this.allowColorChange) {
            Color color = this.getColorAtLocation(n2, n3);
            String string = "rgb(" + color.getRed() * 255.0 + "," + color.getGreen() * 255.0 + "," + color.getBlue() * 255.0 + ");";
            for (Node node : this.colorNodes) {
                node.setStyle("-fx-background-color:" + string + "; -fx-fill:" + string + ";");
            }
        }
    }

    private Color getColorAtLocation(double d2, double d3) {
        double d4 = d2 - this.centerX;
        double d5 = d3 - this.centerY;
        return this.getColor(d5, d4);
    }

    private Image getHuesCircle(int n2, int n3) {
        WritableImage writableImage = new WritableImage(n2, n3);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        Point2D point2D = new Point2D((double)n2 / 2.0, (double)n3 / 2.0);
        double d2 = 0.8 * (double)n2 / 2.0;
        double d3 = (double)n2 / 2.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d4 = (double)i3 - point2D.getX();
                double d5 = (double)i2 - point2D.getY();
                double d6 = Math.sqrt(d4 * d4 + d5 * d5);
                double d7 = Math.atan2(d5, d4);
                if (!(d6 > d2) || !(d6 < d3)) continue;
                double d8 = this.map(d7, -Math.PI, Math.PI, 0.0, 255.0);
                double d9 = 255.0;
                double d10 = 152.0;
                pixelWriter.setColor(i3, i2, this.HSL2RGB(d8, d9, d10));
            }
        }
        return writableImage;
    }

    private Image getSLCricle(int n2, int n3) {
        WritableImage writableImage = new WritableImage(n2, n3);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        Point2D point2D = new Point2D((double)n2 / 2.0, (double)n3 / 2.0);
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                double d2 = (double)i3 - point2D.getX();
                double d3 = (double)i2 - point2D.getY();
                pixelWriter.setColor(i3, i2, this.getColor(d3, d2));
            }
        }
        return writableImage;
    }

    private double clamp(double d2, double d3, double d4) {
        return Math.min(Math.max(d2, d3), d4);
    }

    private Color getColor(double d2, double d3) {
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = 0.65 * ((double)this.pickerSize / 2.0);
        Color color = Color.BLUE;
        if (d4 <= d5 * 1.1) {
            double d6 = -1.5707963267948966;
            double d7 = d6 + 2.0943951023931953;
            double d8 = d7 + 2.0943951023931953;
            double d9 = d5 * Math.sin(d7);
            double d10 = d5 * Math.cos(d7);
            double d11 = d5 * Math.sin(d8);
            double d12 = d5 * Math.cos(d8);
            double[] dArray = this.circleFrom3Points(new Point2D(d9, d10), new Point2D(d11, d12), new Point2D(d2 += 0.01, d3));
            double d13 = dArray[0];
            double d14 = 0.0;
            double d15 = dArray[2];
            double d16 = Math.atan2(d2 - d13, d3 - d14);
            double d17 = Math.atan2(d9 - d13, d10 - d14);
            double d18 = Math.atan2(d11 - d13, d12 - d14);
            double d19 = d13 > 0.0 ? d13 - d15 : d13 + d15;
            double d20 = this.map(d19, -d5, d5, 255.0, 0.0);
            double d21 = 255.0;
            double d22 = d18 - d17;
            double d23 = d16 - d17;
            if (d2 < d9) {
                d22 = d22 < 0.0 ? Math.PI * 2 + d22 : d22;
                d22 = Math.abs(Math.PI * 2 - d22);
                d23 = d23 < 0.0 ? Math.PI * 2 + d23 : d23;
                d23 = Math.abs(Math.PI * 2 - d23);
            }
            d21 = this.map(d23, 0.0, d22, 0.0, 255.0);
            if (d4 > d5) {
                d20 = 255.0 - d20;
                if (d21 < 0.0 && d3 < 0.0) {
                    d21 = 255.0;
                }
            }
            d21 = this.clamp(d21, 0.0, 255.0);
            if (d20 < 10.0 && d2 < d9 || d20 > 240.0 && d2 > d9) {
                d20 = 255.0 - d20;
            }
            d20 = this.clamp(d20, 0.0, 255.0);
            color = this.HSL2RGB(this.currentHue, d20, d21);
        }
        return color;
    }

    private double map(double d2, double d3, double d4, double d5, double d6) {
        return d5 + (d6 - d5) * ((d2 - d3) / (d4 - d3));
    }

    private Color HSL2RGB(double d2, double d3, double d4) {
        d2 = this.map(d2, 0.0, 255.0, 0.0, 359.0);
        d3 = this.map(d3, 0.0, 255.0, 0.0, 1.0);
        double d5 = d4 = this.map(d4, 0.0, 255.0, 0.0, 1.0);
        double d6 = d4;
        double d7 = d4;
        double d8 = d4 <= 0.5 ? d4 * (1.0 + d3) : d4 + d3 - d4 * d3;
        double d9 = d4 + d4 - d8;
        double d10 = (d8 - d9) / d8;
        int n2 = (int)Math.floor(d2 /= 60.0);
        double d11 = d2 - (double)n2;
        double d12 = d8 * d10 * d11;
        double d13 = d9 + d12;
        double d14 = d8 - d12;
        if (d8 > 0.0) {
            switch (n2) {
                case 0: {
                    d5 = d8;
                    d6 = d13;
                    d7 = d9;
                    break;
                }
                case 1: {
                    d5 = d14;
                    d6 = d8;
                    d7 = d9;
                    break;
                }
                case 2: {
                    d5 = d9;
                    d6 = d8;
                    d7 = d13;
                    break;
                }
                case 3: {
                    d5 = d9;
                    d6 = d14;
                    d7 = d8;
                    break;
                }
                case 4: {
                    d5 = d13;
                    d6 = d9;
                    d7 = d8;
                    break;
                }
                case 5: {
                    d5 = d8;
                    d6 = d9;
                    d7 = d14;
                }
            }
        }
        return new Color(d5, d6, d7, 1.0);
    }

    private double[] circleFrom3Points(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = point2D2.getX();
        double d5 = point2D2.getY();
        double d6 = point2D3.getX();
        double d7 = point2D3.getY();
        double d8 = (d4 + d2) / 2.0;
        double d9 = (d5 + d3) / 2.0;
        double d10 = d4 - d2;
        double d11 = -(d5 - d3);
        double d12 = (d6 + d4) / 2.0;
        double d13 = (d7 + d5) / 2.0;
        double d14 = d6 - d4;
        double d15 = -(d7 - d5);
        double d16 = (d9 * d11 * d15 + d12 * d11 * d14 - d8 * d10 * d15 - d13 * d11 * d15) / (d11 * d14 - d10 * d15);
        double d17 = (d16 - d8) * d10 / d11 + d9;
        double d18 = d16 - d2;
        double d19 = d17 - d3;
        double d20 = Math.sqrt(d18 * d18 + d19 * d19);
        return new double[]{d16, d17, d20};
    }

    private Point2D getPointFromSL(int n2, int n3, double d2) {
        double d3 = this.map(n2, 0.0, 255.0, -d2, d2);
        double d4 = 0.0;
        double d5 = d4 + 2.0943951023931953;
        double d6 = d5 + 2.0943951023931953;
        double d7 = d2 * Math.sin(d5);
        double d8 = d2 * Math.cos(d5);
        double d9 = d2 * Math.sin(d6);
        double d10 = d2 * Math.cos(d6);
        double d11 = 0.0;
        double[] dArray = this.circleFrom3Points(new Point2D(d7, d8), new Point2D(d11, d3), new Point2D(d9, d10));
        double d12 = dArray[0];
        double d13 = dArray[1];
        double d14 = dArray[2];
        double d15 = Math.atan2(d7 - d12, d8 - d13);
        double d16 = Math.atan2(d9 - d12, d10 - d13);
        double d17 = this.map(n3, 0.0, 255.0, d16, d15);
        double d18 = d12 + d14 * Math.sin(d17);
        double d19 = d13 + d14 * Math.cos(d17);
        if (d3 < d8) {
            d17 = this.map(n3, 0.0, 255.0, d15, d16 + Math.PI * 2);
            d18 = -d12 - d14 * Math.sin(d17);
            d19 = d13 + d14 * Math.cos(d17);
        }
        return new Point2D(d18, d19);
    }

    private Point2D rotate(Point2D point2D, Point2D point2D2, double d2) {
        double d3 = point2D2.getX() + (point2D.getX() - point2D2.getX()) * Math.cos(d2) - (point2D.getY() - point2D2.getY()) * Math.sin(d2);
        double d4 = point2D2.getY() + (point2D.getX() - point2D2.getX()) * Math.sin(d2) + (point2D.getY() - point2D2.getY()) * Math.cos(d2);
        return new Point2D(d3, d4);
    }

    private final class CurveTransition
    extends Transition {
        Point2D from;
        double fromTheta;
        double toTheta;

        public CurveTransition(Point2D point2D, Point2D point2D2) {
            this.from = point2D;
            double d2 = point2D.getX() - JFXColorPickerUI.this.centerX;
            double d3 = point2D.getY() - JFXColorPickerUI.this.centerY;
            this.fromTheta = Math.atan2(d3, d2);
            double d4 = point2D2.getX() - JFXColorPickerUI.this.centerX;
            double d5 = point2D2.getY() - JFXColorPickerUI.this.centerY;
            this.toTheta = Math.atan2(d5, d4);
            this.setInterpolator(Interpolator.EASE_BOTH);
            this.setDelay(Duration.millis((double)0.0));
            this.setCycleDuration(Duration.millis((double)240.0));
        }

        protected void interpolate(double d2) {
            double d3 = Math.min(Math.abs(this.toTheta - this.fromTheta), Math.PI * 2 - Math.abs(this.toTheta - this.fromTheta));
            if (d3 == Math.PI * 2 - Math.abs(this.toTheta - this.fromTheta)) {
                int n2 = -1;
                if (this.toTheta < this.fromTheta) {
                    n2 = 1;
                }
                d3 = (double)n2 * d3;
            } else {
                d3 = this.toTheta - this.fromTheta;
            }
            Point2D point2D = JFXColorPickerUI.this.rotate(this.from, new Point2D(JFXColorPickerUI.this.centerX, JFXColorPickerUI.this.centerY), d2 * d3);
            JFXColorPickerUI.this.colorSelector.setRotate(90.0 + Math.toDegrees(Math.atan2(point2D.getY() - JFXColorPickerUI.this.centerY, point2D.getX() - JFXColorPickerUI.this.centerX)));
            JFXColorPickerUI.this.colorSelector.setTranslateX(point2D.getX() - JFXColorPickerUI.this.colorSelector.getPrefWidth() / 2.0);
            JFXColorPickerUI.this.colorSelector.setTranslateY(point2D.getY() - JFXColorPickerUI.this.colorSelector.getPrefHeight() / 2.0);
        }
    }
}

