/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import javafx.animation.FadeTransition;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

@DefaultProperty(value="control")
public class JFXBadge
extends StackPane {
    private Group badge;
    protected Node control;
    private boolean enabled = true;
    private static final String DEFAULT_STYLE_CLASS = "jfx-badge";
    protected ObjectProperty<Pos> position = new SimpleObjectProperty();
    private SimpleStringProperty text = new SimpleStringProperty();

    public JFXBadge() {
        this(null);
    }

    public JFXBadge(Node node) {
        this(node, Pos.TOP_RIGHT);
    }

    public JFXBadge(Node node, Pos pos3) {
        this.initialize();
        this.setPosition(pos3);
        this.setControl(node);
        this.position.addListener((observableValue, pos, pos2) -> StackPane.setAlignment((Node)this.badge, (Pos)pos2));
    }

    public void setControl(Node node) {
        if (node != null) {
            this.control = node;
            this.badge = new Group();
            this.getChildren().add((Object)node);
            this.getChildren().add((Object)this.badge);
            if (node instanceof Region) {
                ((Region)node).widthProperty().addListener((observableValue, number, number2) -> this.refreshBadge());
                ((Region)node).heightProperty().addListener((observableValue, number, number2) -> this.refreshBadge());
            }
            this.text.addListener((observableValue, string, string2) -> this.refreshBadge());
        }
    }

    public Node getControl() {
        return this.control;
    }

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
    }

    public void refreshBadge() {
        this.badge.getChildren().clear();
        if (this.enabled) {
            Label label = new Label(this.text.getValue());
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().add((Object)"badge-pane");
            stackPane.getChildren().add((Object)label);
            this.badge.getChildren().add((Object)stackPane);
            StackPane.setAlignment((Node)this.badge, (Pos)this.getPosition());
            FadeTransition fadeTransition = new FadeTransition(Duration.millis((double)666.0), (Node)this.badge);
            fadeTransition.setFromValue(0.0);
            fadeTransition.setToValue(1.0);
            fadeTransition.setCycleCount(1);
            fadeTransition.setAutoReverse(true);
            fadeTransition.play();
        }
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public Pos getPosition() {
        return this.position == null ? Pos.TOP_RIGHT : (Pos)this.position.get();
    }

    public ObjectProperty<Pos> positionProperty() {
        return this.position;
    }

    public void setPosition(Pos pos) {
        this.position.set((Object)pos);
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String string) {
        this.text.set(string);
    }

    public final StringProperty textProperty() {
        return this.text;
    }
}

