/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import java.io.IOException;

public abstract class TypeSerializer {
    public abstract TypeSerializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public WritableTypeId typeId(Object object, JsonToken jsonToken) {
        WritableTypeId writableTypeId = new WritableTypeId(object, jsonToken);
        switch (this.getTypeInclusion()) {
            case EXISTING_PROPERTY: {
                writableTypeId.include = WritableTypeId.Inclusion.PAYLOAD_PROPERTY;
                writableTypeId.asProperty = this.getPropertyName();
                break;
            }
            case EXTERNAL_PROPERTY: {
                writableTypeId.include = WritableTypeId.Inclusion.PARENT_PROPERTY;
                writableTypeId.asProperty = this.getPropertyName();
                break;
            }
            case PROPERTY: {
                writableTypeId.include = WritableTypeId.Inclusion.METADATA_PROPERTY;
                writableTypeId.asProperty = this.getPropertyName();
                break;
            }
            case WRAPPER_ARRAY: {
                writableTypeId.include = WritableTypeId.Inclusion.WRAPPER_ARRAY;
                break;
            }
            case WRAPPER_OBJECT: {
                writableTypeId.include = WritableTypeId.Inclusion.WRAPPER_OBJECT;
                break;
            }
            default: {
                VersionUtil.throwInternal();
            }
        }
        return writableTypeId;
    }

    public WritableTypeId typeId(Object object, JsonToken jsonToken, Object object2) {
        WritableTypeId writableTypeId = this.typeId(object, jsonToken);
        writableTypeId.id = object2;
        return writableTypeId;
    }

    public WritableTypeId typeId(Object object, Class<?> clazz, JsonToken jsonToken) {
        WritableTypeId writableTypeId = this.typeId(object, jsonToken);
        writableTypeId.forValueType = clazz;
        return writableTypeId;
    }

    public abstract WritableTypeId writeTypePrefix(JsonGenerator var1, WritableTypeId var2) throws IOException;

    public abstract WritableTypeId writeTypeSuffix(JsonGenerator var1, WritableTypeId var2) throws IOException;

    @Deprecated
    public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, JsonToken.VALUE_STRING));
    }

    @Deprecated
    public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, JsonToken.START_OBJECT));
    }

    @Deprecated
    public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, JsonToken.START_ARRAY));
    }

    @Deprecated
    public void writeTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeLegacySuffix(jsonGenerator, this.typeId(object, JsonToken.VALUE_STRING));
    }

    @Deprecated
    public void writeTypeSuffixForObject(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeLegacySuffix(jsonGenerator, this.typeId(object, JsonToken.START_OBJECT));
    }

    @Deprecated
    public void writeTypeSuffixForArray(Object object, JsonGenerator jsonGenerator) throws IOException {
        this._writeLegacySuffix(jsonGenerator, this.typeId(object, JsonToken.START_ARRAY));
    }

    @Deprecated
    public void writeTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, clazz, JsonToken.VALUE_STRING));
    }

    @Deprecated
    public void writeTypePrefixForObject(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, clazz, JsonToken.START_OBJECT));
    }

    @Deprecated
    public void writeTypePrefixForArray(Object object, JsonGenerator jsonGenerator, Class<?> clazz) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, clazz, JsonToken.START_ARRAY));
    }

    @Deprecated
    public void writeCustomTypePrefixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, JsonToken.VALUE_STRING, string));
    }

    @Deprecated
    public void writeCustomTypePrefixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, JsonToken.START_OBJECT, string));
    }

    @Deprecated
    public void writeCustomTypePrefixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this.writeTypePrefix(jsonGenerator, this.typeId(object, JsonToken.START_ARRAY, string));
    }

    @Deprecated
    public void writeCustomTypeSuffixForScalar(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeLegacySuffix(jsonGenerator, this.typeId(object, JsonToken.VALUE_STRING, string));
    }

    @Deprecated
    public void writeCustomTypeSuffixForObject(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeLegacySuffix(jsonGenerator, this.typeId(object, JsonToken.START_OBJECT, string));
    }

    @Deprecated
    public void writeCustomTypeSuffixForArray(Object object, JsonGenerator jsonGenerator, String string) throws IOException {
        this._writeLegacySuffix(jsonGenerator, this.typeId(object, JsonToken.START_ARRAY, string));
    }

    protected final void _writeLegacySuffix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) throws IOException {
        writableTypeId.wrapperWritten = !jsonGenerator.canWriteTypeId();
        this.writeTypeSuffix(jsonGenerator, writableTypeId);
    }
}

