/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.inject.Inject;
import us.hebi.gui.lib.aqq;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.asi;
import us.hebi.gui.lib.asn;
import us.hebi.gui.lib.atf;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.azf;
import us.hebi.gui.lib.bba;
import us.hebi.gui.views.scope.components.UpdateItem;

public class UpdateController
implements Initializable {
    @FXML
    protected Parent updateCheck;
    @FXML
    protected VBox updateStatus;
    @FXML
    protected Text statusText;
    @FXML
    protected Hyperlink changelogLink;
    @FXML
    protected Button refreshBtn;
    @FXML
    protected Button updateAllBtn;
    @FXML
    protected VBox items;
    private static final String changelogUrl = "https://docs.hebi.us/downloads_changelogs.html#firmware-changelog";
    @Inject
    atf lookupService;
    @Inject
    asi bootloaderService;
    @Inject
    asg notificationService;
    @Inject
    azf webViewer;
    protected final DoubleProperty numActiveTasks = new SimpleDoubleProperty(0.0);
    protected final ObservableList<UpdateItem> updateableItems = FXCollections.observableArrayList();
    protected final BooleanProperty isEmpty = new SimpleBooleanProperty(true);
    @Inject
    protected ExecutorService executorService;

    protected void updateAll(ActionEvent actionEvent) {
        String string = "This action will update the firmware of all devices on the network. This \nwill cause devices to reboot even if they are actively being used. Are \nyou sure that you want to update all devices at once?";
        if (!this.notificationService.h(string)) {
            return;
        }
        Iterator iterator = this.updateableItems.iterator();
        while (iterator.hasNext()) {
            ((UpdateItem)iterator.next()).update(actionEvent);
        }
    }

    protected void refreshList(ActionEvent actionEvent) {
        this.lookupService.getAutoUpdateCheck().clearUpdatesAvailableFlag();
        this.changelogLink.setVisible(false);
        if (this.lookupService.getModuleList().size() == 0) {
            this.statusText.setText("Could not find any devices on your network");
            return;
        }
        List<aqq> list = this.lookupService.getModuleList().stream().filter(aqq2 -> !aqq2.j.get()).collect(Collectors.toList());
        if (list.size() == 0) {
            this.statusText.setText("All of the devices on your network are stale or can't be updated");
            return;
        }
        Task<List<asn>> task = this.bootloaderService.createUpdateInfoTask(list, bba.d);
        ayo.a(task, list2 -> this.setItemList(list, (List<asn>)list2), throwable -> this.setItemList(list, Collections.emptyList()));
        this.updateCheck.visibleProperty().bind((ObservableValue)task.runningProperty());
        this.updateableItems.clear();
        this.executorService.submit((Runnable)task);
    }

    protected void setItemList(List<aqq> list, List<asn> list2) {
        this.updateCheck.visibleProperty().unbind();
        if (!list2.stream().anyMatch(asn::aM)) {
            this.statusText.setText("Could not connect to server");
            return;
        }
        List list3 = list2.stream().filter(asn::aN).map(asn2 -> this.createUpdateItem((asn)asn2, this.numActiveTasks)).collect(Collectors.toList());
        this.updateableItems.addAll(list3);
        if (list3.size() == 0) {
            this.statusText.setText("All of the devices on your network already have the latest version");
            return;
        }
        this.statusText.setText("Found updates for " + list3.size() + " out of " + list.size() + " devices on your network");
        this.changelogLink.setVisible(true);
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.statusText.setText("");
        this.refreshBtn.setOnAction(this::refreshList);
        this.updateAllBtn.setOnAction(this::updateAll);
        this.refreshBtn.disableProperty().bind((ObservableValue)this.updateCheck.visibleProperty().or((ObservableBooleanValue)this.numActiveTasks.greaterThan(0)).or((ObservableBooleanValue)Bindings.isEmpty(this.lookupService.getModuleList())));
        this.updateAllBtn.disableProperty().bind((ObservableValue)this.updateCheck.visibleProperty().or((ObservableBooleanValue)this.isEmpty));
        this.updateCheck.setVisible(false);
        this.updateCheck.managedProperty().bind((ObservableValue)this.updateCheck.visibleProperty());
        this.updateStatus.visibleProperty().bind((ObservableValue)this.updateCheck.visibleProperty().not().and((ObservableBooleanValue)this.statusText.textProperty().isNotEmpty()));
        this.updateStatus.managedProperty().bind((ObservableValue)this.statusText.visibleProperty());
        this.changelogLink.setVisible(false);
        this.changelogLink.managedProperty().bind((ObservableValue)this.changelogLink.visibleProperty());
        this.changelogLink.setOnAction(actionEvent -> this.webViewer.showDocument(changelogUrl));
        this.items.getParent().visibleProperty().bind((ObservableValue)this.isEmpty.not());
        this.items.getChildren().clear();
        this.updateableItems.clear();
        this.updateableItems.addListener(change -> {
            this.isEmpty.set(this.updateableItems.size() == 0);
            List list = this.updateableItems.stream().map(UpdateItem::getContent).collect(Collectors.toList());
            this.setItemNodes(list);
        });
    }

    protected UpdateItem createUpdateItem(asn asn2, DoubleProperty doubleProperty) {
        return new UpdateItem(asn2, doubleProperty);
    }

    protected void setItemNodes(List<? extends Pane> list) {
        this.items.getChildren().setAll(list);
    }
}

