/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.assets;

import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.DrawMode;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import us.hebi.gui.lib.ame;
import us.hebi.gui.lib.anc;
import us.hebi.gui.lib.bag;
import us.hebi.gui.views.scope.assets.AssetCache;

public enum Asset {
    A_2038_02("01-HEBI_A-2038-02_Export.obj", new Transform[0]),
    A_2039_02("02-HEBI_A-2039-02_Export.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS), new Rotate(180.0, Rotate.X_AXIS)}),
    A_2040_01L_Inside("03-HEBI_A-2040-01L-Inside_Export.obj", new Transform[0]),
    A_2040_01L_Outside("04-HEBI_A-2040-01L-Outside_Export.obj", new Transform[0]),
    A_2040_01R_Inside("05-HEBI_A-2040-01R-Inside_Export.obj", new Transform[0]),
    A_2040_01R_Outside("06-HEBI_A-2040-01R-Outside_Export.obj", new Transform[0]),
    A_2042_01L("07-HEBI_A-2042-01L_Export.obj", new Transform[0]),
    A_2042_01R("08-HEBI_A-2042-01R_Export.obj", new Transform[0]),
    A_2043_01("09-HEBI_A-2043-01_Export.obj", new Transform[0]),
    A_2074_01("10-HEBI_A-2074-01_Export.obj", new Transform[0]),
    Gripper("12-HEBI_Gripper_Export.obj", new Transform[0]),
    A_2220_01_Right("HEBI_A-2220-01_Export.obj", new Transform[0]),
    A_2220_01_Left("HEBI_A-2220-01_Export.obj", new Transform[]{new Rotate(180.0, Rotate.Z_AXIS)}),
    A_2221_01_Inside("HEBI_A-2221-01-Inside_Export.obj", new Transform[0]),
    A_2221_01_Inside_Flip("HEBI_A-2221-01-Inside_Export_Flip.obj", new Transform[0]),
    A_2221_01_Outside("HEBI_A-2221-01-Outside_Export.obj", new Transform[0]),
    A_2221_01_Outside_Flip("HEBI_A-2221-01-Outside_Export_Flip.obj", new Transform[0]),
    A_2222_01_Inside("HEBI_A-2222-01-Inside_Export.obj", new Transform[0]),
    A_2222_01_Outside("HEBI_A-2222-01-Outside_Export.obj", new Transform[0]),
    A_2225_01("HEBI_A-2225-01_Export.obj", new Transform[0]),
    A_2119_01("HEBI_A-2119-01_Export.obj", new Transform[0]),
    A_2226_01("HEBI_A-2226-01_Export.obj", new Transform[0]),
    PE_2033_01("HEBI_PE-2033-01.obj", new Transform[0]),
    PM_2132_01L("HEBI_PM-2132-01L_Export.obj", new Transform[0]),
    PM_2132_01R("HEBI_PM-2132-01R_Export.obj", new Transform[0]),
    PM_2200_01("HEBI_PM-2200-01_Export.obj", new Transform[0]),
    PM_2200_02("HEBI_PM-2200-02_Export.obj", new Transform[0]),
    R8("HEBI_R8_Export.obj", new Transform[0]),
    X5("HEBI_X5_Export.obj", new Transform[0]),
    X8("HEBI_X8_Export.obj", new Transform[0]),
    T5("HEBI_T5_Export.obj", new Transform[0]),
    T8("HEBI_T8_Export.obj", new Transform[0]),
    Iphone("GrabCad_Iphone.obj", new Transform[]{new Rotate(90.0, Rotate.X_AXIS)});

    private static final List<Asset> commonAssets;
    private static final boolean enableTubeModels = false;
    public static final PhongMaterial TUBE_MATERIAL;
    private final bag loader;
    private final Transform[] transforms;
    private final URL url;

    private static URL getUrl(String string) {
        return Optional.ofNullable(System.getProperty("hebi.assets.directory")).map(ame.a(string2 -> new URI((String)string2).resolve(string).toURL())).orElseGet(() -> Asset.class.getResource(string));
    }

    private Asset(String string2, Transform ... transformArray) {
        this.url = Objects.requireNonNull(Asset.getUrl(string2), () -> "built-in asset is missing: " + string2);
        this.transforms = transformArray;
        this.loader = AssetCache.getLoader(this.url);
    }

    public final Group getModel() {
        Group group = this.loader.getModel();
        if (this.transforms.length > 0) {
            group.getTransforms().addAll((Object[])this.transforms);
        }
        return group;
    }

    public static Node getTubeModel(double d2) {
        Cylinder cylinder = new Cylinder(15.875, anc.a.f(d2), 8);
        cylinder.setCullFace(CullFace.BACK);
        cylinder.setDrawMode(DrawMode.FILL);
        cylinder.setMaterial((Material)TUBE_MATERIAL);
        cylinder.getTransforms().add((Object)new Rotate(-90.0, Rotate.X_AXIS));
        Cylinder cylinder2 = cylinder;
        cylinder2.setTranslateZ(cylinder2.getHeight() / 2.0);
        return cylinder;
    }

    final URL getUrl() {
        return this.url;
    }

    public static void loadCommonAssets() {
        commonAssets.forEach(asset -> asset.loader.cj());
    }

    static {
        commonAssets = List.of(A_2038_02, A_2039_02, A_2074_01, A_2119_01, X5, X8, PM_2132_01R, A_2040_01R_Outside, R8, A_2220_01_Right, A_2221_01_Outside, Gripper);
        TUBE_MATERIAL = new PhongMaterial();
        TUBE_MATERIAL.setDiffuseColor(Color.web((String)"0x404040ff"));
        TUBE_MATERIAL.setSpecularColor(Color.web((String)"0x333333ff"));
        TUBE_MATERIAL.setSpecularPower(20.0);
    }
}

