/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.rima;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.plugins.XValueIndicator;
import io.fair_acc.chartfx.plugins.YRangeIndicator;
import io.fair_acc.chartfx.plugins.YValueIndicator;
import io.fair_acc.chartfx.plugins.Zoomer;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.spi.DataRange;
import io.fair_acc.dataset.utils.DataSetStyleBuilder;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.inject.Inject;
import us.hebi.gui.lib.amm;
import us.hebi.gui.lib.apn;
import us.hebi.gui.lib.apo;
import us.hebi.gui.lib.aqx;
import us.hebi.gui.lib.ars;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.avc;
import us.hebi.gui.lib.avp;
import us.hebi.gui.lib.avq;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.bae;

public class TfmImageView
extends VBox {
    @Inject
    apo tfmImageAnalysis;
    @Inject
    aqx properties;

    public TfmImageView() {
        b.a(this);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("tfmimageview.css").toExternalForm());
        this.setPrefHeight(500.0);
        this.initialize();
    }

    void initialize() {
        Chart chart = ayo.a(this.createTfmChart(), "tfm-chart");
        Chart chart2 = ayo.a(this.createColorPicker(), "color-picker");
        VBox.setVgrow((Node)chart, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{chart, chart2});
    }

    private Chart createTfmChart() {
        avp avp2 = new avp("image").a();
        avc avc2 = avc.a("selected", 1000, new String[0]);
        avc2.addStyleClasses(new String[]{"trace-points"});
        avc2.setStyle(DataSetStyleBuilder.instance().setDatasetColor("black").setLineWidth(2.0).build());
        avc avc3 = avc.a("surface", 1000, new String[0]);
        avc3.addStyleClasses(new String[]{"trace-solid"});
        avc3.setStyle(DataSetStyleBuilder.instance().setDatasetColor("lightgreen").setMarkerSize(3.0).build());
        XYChart xYChart = new XYChart();
        Zoomer zoomer = auz.a();
        xYChart.getToolBar().setVisible(false);
        xYChart.getPlugins().add((Object)zoomer);
        xYChart.getRenderers().setAll((Object[])new Renderer[]{new avq(avp2), auz.a()});
        DefaultNumericAxis defaultNumericAxis = (DefaultNumericAxis)xYChart.getFirstAxis(Orientation.HORIZONTAL);
        defaultNumericAxis.setTickUnit(5.0);
        defaultNumericAxis.setSide(Side.TOP);
        defaultNumericAxis.setUnit("mm");
        defaultNumericAxis.setName("x width");
        defaultNumericAxis.setAutoRanging(false);
        DefaultNumericAxis defaultNumericAxis2 = (DefaultNumericAxis)xYChart.getFirstAxis(Orientation.VERTICAL);
        defaultNumericAxis2.setTickUnit(5.0);
        defaultNumericAxis2.invertAxis(true);
        defaultNumericAxis2.setUnit("mm");
        defaultNumericAxis2.setName("z depth");
        defaultNumericAxis2.setAutoRanging(false);
        YValueIndicator yValueIndicator = new YValueIndicator((Axis)defaultNumericAxis2, 0.0);
        YValueIndicator yValueIndicator2 = new YValueIndicator((Axis)defaultNumericAxis2, 0.0);
        YRangeIndicator yRangeIndicator = new YRangeIndicator(defaultNumericAxis2, yValueIndicator.getValue(), yValueIndicator2.getValue());
        DoubleBinding doubleBinding = Bindings.createDoubleBinding(() -> Math.min(yValueIndicator.getValue(), yValueIndicator2.getValue()), (Observable[])new Observable[]{yValueIndicator.valueProperty(), yValueIndicator2.valueProperty()});
        DoubleBinding doubleBinding2 = Bindings.createDoubleBinding(() -> Math.max(yValueIndicator.getValue(), yValueIndicator2.getValue()), (Observable[])new Observable[]{yValueIndicator.valueProperty(), yValueIndicator2.valueProperty()});
        yRangeIndicator.lowerBoundProperty().bind((ObservableValue)doubleBinding);
        yRangeIndicator.upperBoundProperty().bind((ObservableValue)doubleBinding2);
        xYChart.getPlugins().addAll((Object[])new ChartPlugin[]{yValueIndicator, yValueIndicator2, yRangeIndicator});
        ayo.a(this.tfmImageAnalysis::o, (ObservableDoubleValue)doubleBinding);
        ayo.a(this.tfmImageAnalysis::p, (ObservableDoubleValue)doubleBinding2);
        this.tfmImageAnalysis.f(apn2 -> {
            avc2.y(apn2.P());
            apn2.a(avc2::d);
            avc2.bI();
            avc3.y(apn2.a.r.aw());
            amm amm2 = avc3::d;
            apn apn3 = apn2;
            float f2 = apn3.a.cB;
            float f3 = apn3.a.cC;
            int n2 = apn3.a.r.aw();
            float[] fArray = apn3.a.r.y;
            for (int i2 = 0; i2 < n2; ++i2) {
                amm2.accept(f2 + f3 * (float)i2, fArray[i2]);
            }
            avc3.bI();
            apn apn4 = apn2;
            apn3 = apn4;
            apn3 = apn2;
            avp2.a((Image)apn2.c.a, apn2.a.cD, apn4.a.cD + apn3.a.cF * (float)apn3.a.gg, apn2.a.cE, apn3.a.cE + apn3.a.cG * (float)apn3.a.gh);
        });
        yValueIndicator.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MIN_DEPTH", 1.0));
        yValueIndicator2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MAX_DEPTH", 11.0));
        ObservableList<DataSet> observableList = ((Chart)xYChart).getAllDatasets();
        DataRange dataRange = new DataRange();
        DataRange dataRange2 = new DataRange();
        Runnable runnable = () -> {
            double d2;
            if (!zoomer.zoomStackDeque().isEmpty()) {
                return;
            }
            dataRange.clear();
            dataRange2.clear();
            for (DataSet dataSet : observableList) {
                AxisDescription axisDescription = dataSet.getAxisDescription(0);
                dataRange.add(axisDescription.getMin());
                dataRange.add(axisDescription.getMax());
                AxisDescription axisDescription2 = dataSet.getAxisDescription(1);
                dataRange2.add(axisDescription2.getMin());
                dataRange2.add(axisDescription2.getMax());
            }
            double d3 = dataRange.getLength() / xYChart.getCanvas().getWidth();
            double d4 = dataRange2.getLength() / xYChart.getCanvas().getHeight();
            double d5 = d3 / d4;
            if (d2 > 1.0) {
                double d6 = dataRange2.getLength() * (d5 - 1.0);
                DataRange dataRange3 = dataRange2;
                dataRange3.set(dataRange3.getMin(), dataRange2.getMax() + d6);
            } else if (d5 < 1.0) {
                double d7 = dataRange.getLength() * (1.0 / d5 - 1.0);
                DataRange dataRange4 = dataRange;
                dataRange4.set(dataRange4.getMin(), dataRange.getMax() + d7);
            }
            if (doubleBinding2.get() > dataRange2.getMax()) {
                if (yValueIndicator.getValue() > dataRange2.getMax()) {
                    yValueIndicator.setValue(dataRange2.getMax());
                }
                if (yValueIndicator2.getValue() > dataRange2.getMax()) {
                    yValueIndicator2.setValue(dataRange2.getMax());
                }
            }
            if (doubleBinding.get() < dataRange2.getMin()) {
                if (yValueIndicator.getValue() < dataRange2.getMin()) {
                    yValueIndicator.setValue(dataRange2.getMin());
                }
                if (yValueIndicator2.getValue() < dataRange2.getMin()) {
                    yValueIndicator2.setValue(dataRange2.getMin());
                }
            }
            defaultNumericAxis.set(dataRange.getMin(), dataRange.getMax());
            defaultNumericAxis2.set(dataRange2.getMin(), dataRange2.getMax());
        };
        ayo.a(runnable, new Observable[]{xYChart.getCanvas().heightProperty(), xYChart.getCanvas().widthProperty()});
        avp2.addListener((bitState, n2) -> ayo.b(runnable));
        return xYChart;
    }

    private Chart createColorPicker() {
        Color[] colorArray = this.tfmImageAnalysis.b.a();
        ars ars2 = new ars(1.0, 1.0);
        ars ars3 = new ars(1.0, 1.0);
        ars ars4 = new ars((double)colorArray.length, 1.0);
        ars2.a(0, colorArray[0]);
        ars3.a(0, colorArray[colorArray.length - 1]);
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            ars4.a(i2, colorArray[i2]);
        }
        XYChart xYChart = new XYChart();
        xYChart.setLegendVisible(false);
        xYChart.getGridRenderer().getHorizontalMajorGrid().setVisible(false);
        xYChart.getGridRenderer().getVerticalMajorGrid().setVisible(false);
        xYChart.getToolBar().setVisible(false);
        Axis axis = xYChart.getXAxis();
        axis.setTickUnit(100.0);
        axis.setUnit(null);
        axis.setName("intensity");
        XValueIndicator xValueIndicator = new XValueIndicator(axis, 0.0);
        XValueIndicator xValueIndicator2 = new XValueIndicator(axis, 0.0);
        xYChart.getPlugins().addAll((Object[])new ChartPlugin[]{xValueIndicator, xValueIndicator2});
        bae bae2 = new bae(axis);
        ayo.a(this.tfmImageAnalysis::n, (ObservableDoubleValue)bae2.valueProperty());
        xYChart.getPlugins().add((Object)bae2);
        avp avp2 = new avp("below");
        avp avp3 = new avp("above");
        avp avp4 = new avp("range");
        xYChart.getRenderers().setAll((Object[])new Renderer[]{new avq(avp2, avp3, avp4)});
        ayo.a(() -> {
            double d2 = Math.min(xValueIndicator.getValue(), xValueIndicator2.getValue());
            double d3 = Math.max(xValueIndicator.getValue(), xValueIndicator2.getValue());
            this.tfmImageAnalysis.b.dE = d2;
            this.tfmImageAnalysis.b.F = d3;
            avp2.a((Image)ars2.a, 0.0, d2, 0.0, 0.1);
            avp3.a((Image)ars3.a, d3, 350.0, 0.0, 0.1);
            avp4.a((Image)ars4.a, d2, d3, 0.0, 0.1);
        }, new Observable[]{xValueIndicator.valueProperty(), xValueIndicator2.valueProperty()});
        xValueIndicator.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_COLORMAP_MIN", 50.0));
        xValueIndicator2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_COLORMAP_MAX", 235.0));
        bae2.valueProperty().bindBidirectional((Property)this.properties.getDouble("TFM_MIN_INTENSITY", 122.0));
        return xYChart;
    }
}

