/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.hrdf;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import us.hebi.gui.lib.ame;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.ayx;

public abstract class DirectoryUpdateService {
    protected WatchService watcher;
    @Inject
    protected ayx pathResolver;
    @Inject
    protected ExecutorService executor;
    @Inject
    protected asg notificationService;
    Path directoryPath;
    final String subDir;

    protected DirectoryUpdateService(String string) {
        this.subDir = string;
    }

    protected abstract void onDirectoryUpdate();

    @PostConstruct
    public void init() {
        this.directoryPath = this.pathResolver.b(this.subDir);
        try {
            Files.createDirectories(this.directoryPath, new FileAttribute[0]);
            this.onDirectoryUpdate();
            this.watcher = FileSystems.getDefault().newWatchService();
            this.directoryPath.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.executor.submit(() -> {
                while (true) {
                    WatchKey watchKey;
                    try {
                        watchKey = this.watcher.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    catch (ClosedWatchServiceException closedWatchServiceException) {
                        return;
                    }
                    boolean bl2 = false;
                    Iterator<WatchEvent<?>> iterator = watchKey.pollEvents().iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next().kind() == StandardWatchEventKinds.OVERFLOW) continue;
                        bl2 = true;
                    }
                    watchKey.reset();
                    if (!bl2) continue;
                    this.onDirectoryUpdate();
                }
            });
            return;
        }
        catch (IOException iOException) {
            this.notificationService.i("Can't establish watch service for robot directory: " + iOException.getMessage());
            return;
        }
    }

    @PreDestroy
    public void delete() {
        AutoCloseable[] cfr_ignored_0 = new AutoCloseable[0];
        ame.a(this.watcher);
    }

    public Path getDirectoryPath() {
        return this.directoryPath;
    }
}

