/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.logviewer.hebilog;

import java.util.function.Supplier;
import us.hebi.gui.lib.anc;
import us.hebi.gui.lib.auz;
import us.hebi.gui.lib.awf;
import us.hebi.gui.lib.bbh;
import us.hebi.gui.lib.bbl;
import us.hebi.gui.lib.bbn;
import us.hebi.gui.lib.bbo;
import us.hebi.gui.lib.bbq;
import us.hebi.gui.lib.bbr;
import us.hebi.gui.lib.bbt;
import us.hebi.gui.lib.bbw;
import us.hebi.gui.lib.bcu;
import us.hebi.gui.lib.bcv;
import us.hebi.gui.lib.bcw;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.jh;
import us.hebi.gui.lib.jk;
import us.hebi.gui.lib.lu;
import us.hebi.gui.views.logviewer.hebilog.HebiLogFeedback;
import us.hebi.gui.views.logviewer.state.ChartCategory;
import us.hebi.gui.views.logviewer.state.ChartList;
import us.hebi.gui.views.logviewer.state.TDoubleArrayListRegistry;

public class XyzLogData {
    private bcw treeFK;
    private bcu FK;
    private bcv numericalJacobian;
    private bbw staticConnections;
    private int numEntries = 0;
    private int numDevices = 0;
    private jh time;
    private jh[] position;
    private jh[] positionCmd;
    private jh[] velocity;
    private jh[] velocityCmd;
    private jh[] gyroX;
    private jh[] gyroY;
    private jh[] gyroZ;
    public jh[] centerOfMass;
    public jh[] xyzPosition;
    public jh[] xyzPositionCmd;
    public jh xyzPositionErrorMagnitude;
    public jh[] xyzVelocity;
    public jh[] xyzVelocityCmd;
    public jh xyzVelocityMagnitude;
    public jh xyzVelocityMagnitudeCmd;
    public jh[] imuVelocity;
    private double[] tmpPos;
    private double[] tmpPosCmd;
    private double[] tmpVel;
    private double[] tmpVelCmd;
    static final double XYZ_SCALE = anc.a.f(1.0);

    public void setLogData(HebiLogFeedback hebiLogFeedback) {
        this.time = hebiLogFeedback.time;
        this.position = hebiLogFeedback.position;
        this.positionCmd = hebiLogFeedback.positionCmd;
        this.velocity = hebiLogFeedback.velocity;
        this.velocityCmd = hebiLogFeedback.velocityCmd;
        this.gyroX = hebiLogFeedback.gyroX;
        this.gyroY = hebiLogFeedback.gyroY;
        this.gyroZ = hebiLogFeedback.gyroZ;
        this.numEntries = hebiLogFeedback.time.size();
        this.numDevices = hebiLogFeedback.numJoints;
        this.update();
    }

    public void setKinematics(bbt bbt2) {
        this.treeFK = new bcw(bbt2);
        bbr bbr2 = bbt2.a(true);
        this.FK = new bcu(bbr2);
        this.numericalJacobian = new bcv(this.FK);
        bbt bbt3 = bbt2;
        bbw bbw2 = new bbw(bbt3.W());
        bbl bbl2 = bbl.c();
        jk jk2 = new jk(bbt3.V());
        for (int i2 = 0; i2 < bbt3.W(); ++i2) {
            jk jk3;
            jk jk4 = jk3 = jk2;
            jk3.i = new int[10];
            jk4.M = 0;
            boolean bl2 = false;
            int n2 = bbt3.ad.indexOf(bbt3.J.get(i2));
            block1: for (int i3 = n2 + 1; i3 < bbt3.a.size() && !bl2; ++i3) {
                Object object;
                if (bbt3.a.k(i3) == n2) {
                    object = bbt3.ad.get(i3);
                    if (object instanceof bbq) {
                        bl2 = true;
                        bbw2.bz[i2] = bbt3.J.indexOf((bbq)object);
                    } else {
                        jk2.b(i3);
                        n2 = i3;
                    }
                }
                int n3 = i2;
                object = bbw2.a[n3];
                bbl2.b();
                int n4 = 0;
                while (true) {
                    jk jk5 = jk2;
                    if (n4 >= jk5.M) continue block1;
                    int n5 = jk2.k(n4);
                    bbl bbl3 = bbt3.ad.get(n5).f();
                    bbn.a(bbl2, bbl3, (bbl)object);
                    bbl2.c((bbl)object);
                    ++n4;
                }
            }
        }
        this.staticConnections = bbw2;
        this.update();
    }

    public boolean hasValidCombination() {
        return this.FK != null && this.numEntries > 0 && this.FK.d.numJoints == this.numDevices;
    }

    public void update() {
        if (!this.hasValidCombination()) {
            return;
        }
        this.resize();
        bbo bbo2 = bbo.d();
        bbo bbo3 = bbo.d();
        lu lu2 = new lu(0, 0);
        lu lu3 = new lu(0, 0);
        bbl bbl2 = bbl.c();
        bbh bbh2 = new bbh();
        for (int i2 = 0; i2 < this.numEntries; ++i2) {
            this.fillTmpArrays(i2);
            bbo bbo4 = bbo3;
            double[] dArray = this.tmpPos;
            this.treeFK.a(this.tmpPos).a(bbo4);
            bbo3.a(XYZ_SCALE);
            this.centerOfMass[0].d(bbo3.a1);
            this.centerOfMass[1].d(bbo3.a2);
            this.centerOfMass[2].d(bbo3.a3);
            this.FK.a(this.tmpPos, bbl2);
            this.xyzPosition[0].d(XYZ_SCALE * bbl2.dL);
            this.xyzPosition[1].d(XYZ_SCALE * bbl2.dN);
            this.xyzPosition[2].d(XYZ_SCALE * bbl2.dR);
            this.FK.a(this.tmpPosCmd, bbl2);
            this.xyzPositionCmd[0].d(XYZ_SCALE * bbl2.dL);
            this.xyzPositionCmd[1].d(XYZ_SCALE * bbl2.dN);
            this.xyzPositionCmd[2].d(XYZ_SCALE * bbl2.dR);
            double d2 = this.xyzPositionCmd[0].a(i2) - this.xyzPosition[0].a(i2);
            double d3 = this.xyzPositionCmd[1].a(i2) - this.xyzPosition[1].a(i2);
            double d4 = this.xyzPositionCmd[2].a(i2) - this.xyzPosition[2].a(i2);
            double d5 = d2;
            double d6 = d3;
            double d7 = d4;
            this.xyzPositionErrorMagnitude.d(Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7));
            this.numericalJacobian.a(this.tmpPos, bbh2);
            lu2.a(this.tmpVelCmd.length, 1, true, this.tmpVel);
            h.a(bbh2, lu2, lu3);
            double d8 = XYZ_SCALE * lu3.h[0];
            double d9 = XYZ_SCALE * lu3.h[1];
            double d10 = XYZ_SCALE * lu3.h[2];
            this.xyzVelocity[0].d(d8);
            this.xyzVelocity[1].d(d9);
            this.xyzVelocity[2].d(d10);
            double d11 = d8;
            double d12 = d9;
            double d13 = d10;
            this.xyzVelocityMagnitude.d(Math.sqrt(d11 * d11 + d12 * d12 + d13 * d13));
            this.numericalJacobian.a(this.tmpPosCmd, bbh2);
            lu2.a(this.tmpVelCmd.length, 1, true, this.tmpVelCmd);
            h.a(bbh2, lu2, lu3);
            d8 = XYZ_SCALE * lu3.h[0];
            d9 = XYZ_SCALE * lu3.h[1];
            d10 = XYZ_SCALE * lu3.h[2];
            this.xyzVelocityCmd[0].d(d8);
            this.xyzVelocityCmd[1].d(d9);
            this.xyzVelocityCmd[2].d(d10);
            double d14 = d8;
            double d15 = d9;
            double d16 = d10;
            this.xyzVelocityMagnitudeCmd.d(Math.sqrt(d14 * d14 + d15 * d15 + d16 * d16));
            for (int i3 = 0; i3 < this.numDevices; ++i3) {
                double d17 = Double.NaN;
                int n2 = i3;
                Object object = this.staticConnections;
                if (n2 < ((bbw)object).bz.length && ((bbw)object).bz[n2] >= 0) {
                    n2 = i3;
                    int n3 = this.staticConnections.bz[n2];
                    bbo2.a1 = this.gyroX[n3].a(i2);
                    bbo2.a2 = this.gyroY[n3].a(i2);
                    bbo2.a3 = this.gyroZ[n3].a(i2);
                    int n4 = i3;
                    bbo4 = bbo3;
                    bbo bbo5 = bbo2;
                    object = this.staticConnections.a[n4];
                    bbo4.a1 = ((bbl)object).u * bbo5.a1 + ((bbl)object).w * bbo5.a2 + ((bbl)object).dO * bbo5.a3;
                    bbo4.a2 = ((bbl)object).v * bbo5.a1 + ((bbl)object).x * bbo5.a2 + ((bbl)object).dP * bbo5.a3;
                    bbo4.a3 = ((bbl)object).dK * bbo5.a1 + ((bbl)object).dM * bbo5.a2 + ((bbl)object).dQ * bbo5.a3;
                    d17 = bbo3.a3 - this.gyroZ[i3].a(i2);
                }
                this.imuVelocity[i3].d(d17);
            }
        }
    }

    public void getCharts(ChartList chartList) {
        if (!this.hasValidCombination()) {
            return;
        }
        chartList.setTime(this.time).setTraceType(awf.a).addXyzCommandChart(ChartCategory.Cartesian, "Position", "mm", -50.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addXyzErrorChart(ChartCategory.Cartesian, "Position Error", "mm", 0.0, 50.0, this.xyzPositionCmd, this.xyzPosition).addSingleTrace(ChartCategory.Cartesian, "Position Error Magnitude", "mm", 0.0, 10.0, this.xyzPositionErrorMagnitude).addXyzCommandChart(ChartCategory.Cartesian, "Velocity", "mm/s", -50.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addXyzErrorChart(ChartCategory.Cartesian, "Velocity Error", "mm/s", 0.0, 50.0, this.xyzVelocityCmd, this.xyzVelocity).addTimeTraces((Supplier<String>)ChartCategory.Cartesian, "Velocity Magnitude", "mm/s", 0.0, 500.0, new jh[]{this.xyzVelocityMagnitudeCmd, this.xyzVelocityMagnitude}, renderer -> {
            auz.a(renderer, 0, "xyz velocity command", "trace-dashed", "color-primary-muted");
            auz.a(renderer, 1, "xyz velocity feedback", "trace-solid", "color-primary");
        }).addXyzChart(ChartCategory.Cartesian, "Center of Mass", "mm", -50.0, 50.0, this.centerOfMass).addCommandChart(ChartCategory.Encoders, "Velocity IMU", "rad/s", -5.0, 5.0, this.imuVelocity, this.velocity).addErrorChart(ChartCategory.Encoders, "Velocity IMU Error", "rad/s", 0.0, 0.05, this.imuVelocity, this.velocity);
    }

    private void fillTmpArrays(int n2) {
        for (int i2 = 0; i2 < this.numDevices; ++i2) {
            this.tmpPos[i2] = this.position[i2].a(n2);
            this.tmpPosCmd[i2] = this.positionCmd[i2].a(n2);
            this.tmpVel[i2] = this.velocity[i2].a(n2);
            this.tmpVelCmd[i2] = this.velocityCmd[i2].a(n2);
        }
    }

    private void resize() {
        this.centerOfMass = TDoubleArrayListRegistry.resizeMultiple(this.centerOfMass, 3, this.numEntries);
        this.xyzPosition = TDoubleArrayListRegistry.resizeMultiple(this.xyzPosition, 3, this.numEntries);
        this.xyzPositionCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzPositionCmd, 3, this.numEntries);
        this.xyzPositionErrorMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzPositionErrorMagnitude, this.numEntries);
        this.xyzVelocity = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocity, 3, this.numEntries);
        this.xyzVelocityCmd = TDoubleArrayListRegistry.resizeMultiple(this.xyzVelocityCmd, 3, this.numEntries);
        this.xyzVelocityMagnitude = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitude, this.numEntries);
        this.xyzVelocityMagnitudeCmd = TDoubleArrayListRegistry.resizeSingle(this.xyzVelocityMagnitudeCmd, this.numEntries);
        this.imuVelocity = TDoubleArrayListRegistry.resizeMultiple(this.imuVelocity, this.numDevices, this.numEntries);
        this.tmpPos = new double[this.position.length];
        this.tmpPosCmd = new double[this.position.length];
        this.tmpVel = new double[this.position.length];
        this.tmpVelCmd = new double[this.position.length];
    }
}

