/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.c;

public abstract class d
extends StackPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(d.class);
    public static final String DEFAULT_ENDING = "View";
    public static final String CSS_FILE_ENDING = ".css";
    public static final String BSS_FILE_ENDING = ".bss";
    protected ObjectProperty<Object> presenterProperty;
    protected FXMLLoader fxmlLoader;
    protected String bundleName;
    protected ResourceBundle bundle;
    protected c presenterFactory;
    protected Function<String, Object> injectionContext;
    protected URL resource;
    protected static Executor FX_PLATFORM_EXECUTOR = Platform::runLater;
    protected static final ExecutorService PARENT_CREATION_POOL = d.getExecutorService();

    public d() {
        this(null, string -> null);
    }

    public d(c c2) {
        this(c2, string -> null);
    }

    public d(Function<String, Object> function) {
        this(null, function);
    }

    public d(c c2, Function<String, Object> function) {
        this.presenterFactory = c2;
        this.injectionContext = function;
        d d2 = this;
        d2.init(d2.getFXMLName());
    }

    private void init(String string) {
        this.presenterProperty = new SimpleObjectProperty();
        this.resource = ((Object)((Object)this)).getClass().getResource(string);
        this.bundleName = this.getBundleName();
        this.bundle = d.getResourceBundle(this.bundleName);
    }

    FXMLLoader loadSynchronously(URL uRL, ResourceBundle resourceBundle, String string) throws IllegalStateException {
        FXMLLoader fXMLLoader = new FXMLLoader(uRL, resourceBundle);
        c c2 = this.discover();
        Callback callback = clazz -> c2.instantiatePresenter(clazz, this.injectionContext);
        fXMLLoader.setControllerFactory(callback);
        try {
            fXMLLoader.load();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Cannot load " + string, iOException);
        }
        return fXMLLoader;
    }

    c discover() {
        if (this.presenterFactory != null) {
            return this.presenterFactory;
        }
        List<c> list = StreamSupport.stream(c.a().spliterator(), false).collect(Collectors.toList());
        if (list.isEmpty()) {
            return b::instantiatePresenter;
        }
        if (list.size() == 1) {
            return (c)list.get(0);
        }
        list.forEach(c2 -> LOGGER.error(c2.toString()));
        throw new IllegalStateException("More than one PresenterFactories discovered");
    }

    void initializeFXMLLoader() {
        if (this.fxmlLoader == null) {
            this.fxmlLoader = this.loadSynchronously(this.resource, this.bundle, this.bundleName);
            this.presenterProperty.set(this.fxmlLoader.getController());
        }
    }

    public Parent getView() {
        this.initializeFXMLLoader();
        Parent parent = (Parent)this.fxmlLoader.getRoot();
        this.addCSSIfAvailable(parent);
        return parent;
    }

    public void getView(Consumer<Parent> consumer) {
        ((CompletableFuture)CompletableFuture.supplyAsync(this::getView, FX_PLATFORM_EXECUTOR).thenAccept((Consumer)consumer)).exceptionally(this::exceptionReporter);
    }

    public void getViewAsync(Consumer<Parent> consumer) {
        ((CompletableFuture)CompletableFuture.supplyAsync(this::getView, PARENT_CREATION_POOL).thenAcceptAsync((Consumer)consumer, FX_PLATFORM_EXECUTOR)).exceptionally(this::exceptionReporter);
    }

    public Node getViewWithoutRootContainer() {
        ObservableList observableList = this.getView().getChildrenUnmodifiable();
        if (observableList.isEmpty()) {
            return null;
        }
        return (Node)observableList.listIterator().next();
    }

    void addCSSIfAvailable(Parent parent) {
        URL uRL = ((Object)((Object)this)).getClass().getResource(this.getBinaryStyleSheetName());
        if (uRL == null) {
            uRL = ((Object)((Object)this)).getClass().getResource(this.getStyleSheetName());
        }
        if (uRL == null) {
            return;
        }
        String string = uRL.toExternalForm();
        if (!parent.getStylesheets().contains((Object)string)) {
            parent.getStylesheets().add((Object)string);
        }
    }

    String getStyleSheetName() {
        return this.getResourceCamelOrLowerCase(false, CSS_FILE_ENDING);
    }

    String getBinaryStyleSheetName() {
        return this.getResourceCamelOrLowerCase(false, BSS_FILE_ENDING);
    }

    final String getFXMLName() {
        return this.getResourceCamelOrLowerCase(true, ".fxml");
    }

    String getResourceCamelOrLowerCase(boolean bl2, String string) {
        String string2 = this.getConventionalName(true, string);
        if (((Object)((Object)this)).getClass().getResource(string2) != null) {
            return string2;
        }
        LOGGER.info("File: " + string2 + " not found, attempting with camel case");
        string2 = this.getConventionalName(false, string);
        URL uRL = ((Object)((Object)this)).getClass().getResource(string2);
        if (bl2 && uRL == null) {
            String string3 = "Cannot load file " + string2;
            LOGGER.error(string3);
            LOGGER.error("Stopping initialization phase...");
            throw new IllegalStateException(string3);
        }
        return string2;
    }

    public Object getPresenter() {
        this.initializeFXMLLoader();
        return this.presenterProperty.get();
    }

    public void getPresenter(Consumer<Object> consumer) {
        this.presenterProperty.addListener((observableValue, object, object2) -> consumer.accept(object2));
    }

    protected String getConventionalName(boolean bl2, String string) {
        return this.getConventionalName(bl2) + string;
    }

    protected String getConventionalName(boolean bl2) {
        String string = d.stripEnding(((Object)((Object)this)).getClass().getSimpleName());
        if (bl2) {
            string = string.toLowerCase();
        }
        return string;
    }

    String getBundleName() {
        String string = this.getConventionalName(true);
        return ((Object)((Object)this)).getClass().getPackage().getName() + "." + string;
    }

    static String stripEnding(String string) {
        if (!string.endsWith(DEFAULT_ENDING)) {
            return string;
        }
        int n2 = string.lastIndexOf(DEFAULT_ENDING);
        return string.substring(0, n2);
    }

    public static ResourceBundle getResourceBundle(String string) {
        try {
            return ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    static ExecutorService getExecutorService() {
        return Executors.newCachedThreadPool(runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            String string = thread.getName();
            thread.setName("afterburner.fx-" + string);
            thread.setDaemon(true);
            return thread;
        });
    }

    public Void exceptionReporter(Throwable throwable) {
        LOGGER.error("Exception thrown in afterburner.fx", throwable);
        return null;
    }
}

