/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import picocli.CommandLine;
import us.hebi.gui.lib.act;
import us.hebi.gui.lib.aec;
import us.hebi.gui.lib.aee;
import us.hebi.gui.lib.afc;
import us.hebi.gui.lib.agp;
import us.hebi.gui.lib.aii;
import us.hebi.gui.lib.ame;
import us.hebi.gui.lib.atr;
import us.hebi.gui.lib.ats;
import us.hebi.gui.lib.atv;
import us.hebi.gui.lib.atz;
import us.hebi.gui.lib.awz;
import us.hebi.gui.lib.axg;
import us.hebi.gui.lib.axi;
import us.hebi.gui.lib.axk;
import us.hebi.gui.lib.axl;
import us.hebi.gui.lib.bpr;
import us.hebi.gui.lib.bpv;
import us.hebi.gui.lib.bqu;
import us.hebi.gui.lib.bxj;
import us.hebi.gui.lib.wv;
import us.hebi.gui.lib.wx;

public final class axf
extends awz {
    @CommandLine.Parameters(index="0", paramLabel="mode", description={"Chooses the operating mode [calibration, errorlog, getinfo, getfbk, readlog]"})
    private axi a;
    @CommandLine.Option(names={"--frequency"}, description={"Sets the frequency [Hz] for modes that poll device data."})
    private double frequency = 10.0;
    @CommandLine.Option(names={"--imu-accel-offset"}, description={"Sets the xyz accelerometer offset after calibration. Expects 3 numbers separated by commas."}, split=",")
    private float[] imuAccelOffsets;
    @CommandLine.Option(names={"--imu-rotation"}, description={"Sets the 3x3 rotation matrix of the IMU after calibration. Expects 9 numbers  separated by commas."}, split=",")
    private float[] imuRotation;
    @CommandLine.Option(names={"--md-motor-adc"}, description={"Runs a calibration procedure and sets motor driver offsets"})
    private boolean mdMotorAdc;
    @CommandLine.Option(names={"--md-encoder-offset"}, description={"Runs a calibration procedure and sets encoder offsets"})
    private boolean mdEncoderOffset;
    @CommandLine.Option(names={"--hebilog"}, description={"Loads a .hebilog file and prints the output"})
    private File hebilogFile;

    @Override
    protected final void run() throws Exception {
        if (this.frequency < 0.0) {
            throw axl.a("frequency");
        }
        if (this.a == axi.errorlog || this.a == axi.getinfo || this.a == axi.getfbk) {
            axf axf2 = this;
            aee aee2 = axf2.b();
            System.out.println("Polling of " + aee2 + " at " + axf2.frequency + " Hz");
            axk axk2 = new axk(aee2);
            axk2.a(axf2.frequency);
            bqu bqu3 = axk2.g.b();
            switch (axf2.a) {
                case errorlog: {
                    bqu3.i(true);
                    break;
                }
                case getinfo: {
                    bqu3.k(true).j(true).a(bpv.b).c(true).b(true).a(true).d(true).e(true).f(true).g(true);
                    break;
                }
                case getfbk: {
                    bqu3.b(true).a(true).d(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported poll mode: " + axf2.a);
                }
            }
            act act2 = (bqu2, l2, bl2) -> {
                switch (this.a) {
                    case errorlog: {
                        bpr bpr2 = bqu2.a;
                        if (bpr2.hO()) {
                            System.out.println(bpr2.T.a(bxj.b));
                        }
                        return;
                    }
                }
                System.out.println(bqu2);
            };
            axk2.c = act2;
            axk2.a();
            Runtime.getRuntime().addShutdownHook(new Thread(axk2::bT));
            while (true) {
                ame.b(100L, TimeUnit.MILLISECONDS);
            }
        }
        if (this.a == axi.calibration) {
            if (this.mdMotorAdc) {
                axf axf3 = this;
                axf3.b();
                aee aee3 = axf3.b();
                System.out.println("Running ADC calibration on " + aee3);
                new axk(aee3);
                ats ats2 = new atr(aee3, afc.b, 200, 38.0f, 4.0f).a();
                System.out.println("Computed fit coefficients for ADC offsets");
                System.out.println("A:   " + Arrays.toString(ats2.a.g()));
                System.out.println("B:   " + Arrays.toString(ats2.b.g()));
                System.out.println("C:   " + Arrays.toString(ats2.c.g()));
                System.out.println("Bus: " + Arrays.toString(ats2.d.g()));
                return;
            }
            if (this.mdEncoderOffset) {
                agp agp2;
                axf axf4 = this;
                axf4.b();
                axf axf5 = axf4;
                aee aee4 = axf4.b();
                System.out.println("Running encoder offset calibration on " + aee4);
                System.out.println("Make sure the following are set:\n   Motor Driver: [Output Encoder] is set to your configured encoder (e.g. A1)\n   Motor Driver: [Motor Encoder] is set to POSITION_COMMAND\n   Motor Driver: [Controller Mode] is set to FOC\n   Gains:        [Control Strategy] is set to DIRECT_FOC\nPress Enter to continue...\n");
                if (axf5.verbose) {
                    System.out.println("Requesting current motor encoder configuration");
                }
                try {
                    aii aii2 = aec.a(aee4);
                    agp2 = aii2.a.a().a();
                }
                catch (IOException iOException) {
                    throw axl.a("Failed to get info message from device", new Object[0]);
                }
                if (axf5.verbose) {
                    System.out.println("Using motor encoder " + agp2);
                }
                atz atz2 = new atv(aee4, agp2, 15.0, 2.0, 11).a();
                System.out.println("Fit Coeffs: " + Arrays.toString(atz2.e.g()));
                return;
            }
        }
        if (this.a == axi.readlog) {
            axf axf6 = this;
            if (!axf6.c(axf6.hebilogFile)) {
                throw axl.a("Invalid '--hebilog' parameter : " + axf6.hebilogFile, new Object[0]);
            }
            try (wx wx2 = wv.a(axf6.hebilogFile);){
                wx2.a(new axg(axf6));
                return;
            }
            catch (IOException iOException) {
                throw axl.a("Failed to read log file. Reason: %s", iOException.getMessage());
            }
        }
        super.run();
    }

    @Override
    protected final void f(List<BiConsumer<bqu, Integer>> list) {
        if (this.imuAccelOffsets != null) {
            axf.a(this.imuAccelOffsets.length == 3, "Accelerometer offset expects 3 values: [x,y,z]. Got %d.", this.imuAccelOffsets.length);
            list.add((bqu2, n2) -> bqu2.a().e().i(true).b(this.imuAccelOffsets));
        }
        if (this.imuRotation != null) {
            axf.a(this.imuRotation.length == 9, "IMU rotation expects 9 values separated by commas. Got %d. ", this.imuRotation.length);
            list.add((bqu2, n2) -> bqu2.a().e().h(true).a(this.imuRotation));
        }
    }

    @Override
    protected final void z(int n2) {
        if (n2 > 1) {
            axf.a(this.imuAccelOffsets == null, "--imu-accel-offset only supports single devices", new Object[0]);
            axf.a(this.imuRotation == null, "--imu-rotation only supports single devices", new Object[0]);
        }
    }

    private aee b() throws axl {
        List<aee> list = this.g();
        if (list.size() > 1) {
            throw axl.b();
        }
        return list.get(0);
    }
}

