/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.ack;
import us.hebi.gui.lib.ame;

@XmlRootElement
public class acj {
    private static final Pattern VALID_STRUCT_FIELD_NAME = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]+$");
    private URL origin;
    private List<String> names = Collections.emptyList();
    private List<String> families = Collections.emptyList();
    private String hrdf;
    private Map<String, String> gains = Collections.emptyMap();
    private List<ack> plugins = Collections.emptyList();
    private Map<String, Object> userData;

    public static acj tryReadFile(Path path) throws IOException {
        aa.a(Files.isRegularFile(path, new LinkOption[0]), (Object)"file is not a regular file");
        return acj.parseURL(ame.a(() -> path.toUri().toURL())).relativizePaths().validate();
    }

    public static acj parseURL(URL uRL) throws IOException {
        Object[] objectArray = new Object[]{uRL};
        String string = "invalid input: %s";
        if (uRL == null) {
            throw new NullPointerException(aa.b(string, objectArray));
        }
        ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
        objectMapper.registerSubtypes(acj.class, ack.class);
        return objectMapper.readValue(uRL, acj.class).setOrigin(uRL);
    }

    private acj setOrigin(URL uRL) {
        this.origin = uRL;
        return this;
    }

    public acj relativizePaths() {
        URI uRI = ame.a(aa.a(this.origin, (Object)"origin: null")::toURI);
        this.hrdf = this.relativize(uRI, this.hrdf);
        this.gains.replaceAll((string, string2) -> this.relativize(uRI, this.gains.get(string)));
        return this;
    }

    private String relativize(URI uRI, String string) {
        if (string == null) {
            return null;
        }
        return Paths.get(uRI.resolve(string)).toAbsolutePath().toString();
    }

    private String relativize(Path path, String string) {
        if (string == null) {
            return null;
        }
        return path.relativize(Paths.get(string, new String[0])).toAbsolutePath().toString();
    }

    public acj validate() {
        aa.a(!this.names.isEmpty(), (Object)"Names must not be empty");
        aa.a(!this.families.isEmpty(), (Object)"Families must not be empty");
        aa.a(this.families.size() == 1 || this.families.size() == this.names.size(), (Object)"Families must be singular or match the number of names");
        acj.validateKeys(this.gains);
        acj.validateKeys(this.userData);
        if (this.plugins != null && !this.plugins.isEmpty()) {
            Iterator<ack> iterator = this.plugins.iterator();
            while (iterator.hasNext()) {
                acj.validateKeys(iterator.next().getProps());
            }
        }
        return this;
    }

    private static void validateKeys(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            Object[] objectArray = new Object[]{string};
            String string2 = "Keys must be alphanumeric with optional underscores and do not start with a number. Encountered invalid key '%s'";
            if (acj.isValidKey(string)) continue;
            throw new IllegalArgumentException(aa.b(string2, objectArray));
        }
    }

    private static boolean isValidKey(String string) {
        return VALID_STRUCT_FIELD_NAME.matcher(string).matches();
    }

    @JsonProperty(value="names", required=true)
    public void setNames(Object object) {
        this.names = acj.toStringList(object);
    }

    @JsonProperty(value="families", required=true)
    public void setFamilies(Object object) {
        this.families = acj.toStringList(object);
    }

    @JsonProperty(value="hrdf")
    public void setHrdf(String string) {
        this.hrdf = string;
    }

    @JsonProperty(value="gains")
    public void setGains(Object object) {
        if (object == null) {
            this.gains = Collections.emptyMap();
            return;
        }
        if (object instanceof String) {
            this.gains = new HashMap<String, String>();
            this.gains.put("default", (String)object);
            return;
        }
        if (object instanceof Map) {
            this.gains = (Map)object;
            return;
        }
        throw new IllegalArgumentException("Expected file or list of named gains. Found: ".concat(String.valueOf(object)));
    }

    @JsonProperty(value="user_data")
    public void setUserData(Object object) {
        if (object == null) {
            this.userData = Collections.emptyMap();
            return;
        }
        if (object instanceof Map) {
            this.userData = (Map)object;
            return;
        }
        throw new IllegalArgumentException("Expected list of key:value pairs. Found: ".concat(String.valueOf(object)));
    }

    @JsonProperty(value="plugins")
    public void setPlugins(List<ack> list) {
        if (list == null) {
            this.plugins = Collections.emptyList();
            return;
        }
        this.plugins = list;
    }

    private static List<String> toStringList(Object object) {
        if (object instanceof String) {
            return Collections.singletonList((String)object);
        }
        if (object instanceof List) {
            return (List)object;
        }
        throw new IllegalArgumentException("Expected string or list of strings");
    }

    @JsonAnySetter
    public void setProperty(String string, Object object) {
        throw new IllegalArgumentException("Encountered unsupported key '" + string + "' with value '" + object + "'");
    }

    public URL getOrigin() {
        return this.origin;
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<String> getFamilies() {
        return this.families;
    }

    public String getHrdf() {
        return this.hrdf;
    }

    public Map<String, String> getGains() {
        return this.gains;
    }

    public List<ack> getPlugins() {
        return this.plugins;
    }

    public Map<String, Object> getUserData() {
        return this.userData;
    }

    public String toString() {
        return "RobotConfig(origin=" + this.getOrigin() + ", names=" + this.getNames() + ", families=" + this.getFamilies() + ", hrdf=" + this.getHrdf() + ", gains=" + this.getGains() + ", plugins=" + this.getPlugins() + ", userData=" + this.getUserData() + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof acj)) {
            return false;
        }
        acj acj2 = (acj)object;
        if (!acj2.canEqual(this)) {
            return false;
        }
        URL uRL = this.getOrigin();
        URL uRL2 = acj2.getOrigin();
        if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
            return false;
        }
        List<String> list = this.getNames();
        List<String> list2 = acj2.getNames();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getFamilies();
        List<String> list4 = acj2.getFamilies();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        String string = this.getHrdf();
        String string2 = acj2.getHrdf();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Map<String, String> map = this.getGains();
        Map<String, String> map2 = acj2.getGains();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        List<ack> list5 = this.getPlugins();
        List<ack> list6 = acj2.getPlugins();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        Map<String, Object> map3 = this.getUserData();
        Map<String, Object> map4 = acj2.getUserData();
        return !(map3 == null ? map4 != null : !((Object)map3).equals(map4));
    }

    protected boolean canEqual(Object object) {
        return object instanceof acj;
    }

    public int hashCode() {
        URL uRL = this.getOrigin();
        int n2 = 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
        List<String> list = this.getNames();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getFamilies();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        String string = this.getHrdf();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Map<String, String> map = this.getGains();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        List<ack> list3 = this.getPlugins();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        Map<String, Object> map2 = this.getUserData();
        return n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
    }
}

