/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableStringValue;

public class TextUtil {
    static final String DEFAULT_DOUBLE_FORMAT = "#0.###";
    private static final DecimalFormat DEFAULT_DECIMAL_FORMAT = TextUtil.createDecimalFormat("#0.###");
    private static final ThreadLocal<DecimalFormat> fourDigitsWithoutZeroesFormat = ThreadLocal.withInitial(() -> TextUtil.createDecimalFormat(DEFAULT_DOUBLE_FORMAT));
    static final double pow4 = 10000.0;
    static final double WHOLE_NUMBER = 4.503599627370496E15;

    public static StringBinding asFormattedString(ReadOnlyDoubleProperty readOnlyDoubleProperty, StringProperty stringProperty) {
        ObjectBinding<DecimalFormat> objectBinding = TextUtil.createDecimalFormat((ObservableStringValue)stringProperty);
        return Bindings.createStringBinding(() -> ((DecimalFormat)objectBinding.get()).format(readOnlyDoubleProperty.get()), (Observable[])new Observable[]{readOnlyDoubleProperty, objectBinding});
    }

    public static ObjectBinding<DecimalFormat> createDecimalFormat(ObservableStringValue observableStringValue) {
        return Bindings.createObjectBinding(() -> TextUtil.createDecimalFormat((String)observableStringValue.get()), (Observable[])new Observable[]{observableStringValue});
    }

    public static DecimalFormat createDecimalFormat(String string) {
        if (DEFAULT_DOUBLE_FORMAT.equals(string) && DEFAULT_DECIMAL_FORMAT != null) {
            return DEFAULT_DECIMAL_FORMAT;
        }
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)DecimalFormatSymbols.getInstance(Locale.US).clone();
        decimalFormatSymbols.setInfinity("Inf");
        decimalFormatSymbols.setNaN("NaN");
        return new DecimalFormat(string, decimalFormatSymbols);
    }

    public static boolean isNullOrBlank(String string) {
        return string == null || string.isBlank();
    }

    public static DoubleBinding asDoubleBinding(ObservableStringValue observableStringValue) {
        return Bindings.createDoubleBinding(() -> TextUtil.parseDouble((String)observableStringValue.get()), (Observable[])new Observable[]{observableStringValue});
    }

    public static BooleanBinding isFinite(ObservableDoubleValue observableDoubleValue) {
        return Bindings.createBooleanBinding(() -> Double.isFinite(observableDoubleValue.get()), (Observable[])new Observable[]{observableDoubleValue});
    }

    public static double parseDouble(String string) {
        if (TextUtil.isNullOrBlank(string)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if ("-inf".equalsIgnoreCase(string) || "-infinity".equalsIgnoreCase(string)) {
                return Double.NEGATIVE_INFINITY;
            }
            if ("inf".equalsIgnoreCase(string) || "infinity".equalsIgnoreCase(string)) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
    }

    public static String format4digitsWithoutZeros(double d2) {
        String string;
        if (Double.isFinite(d2)) {
            d2 = TextUtil.round4(d2);
        }
        return "-0".equals(string = fourDigitsWithoutZeroesFormat.get().format(d2)) ? "0" : string;
    }

    @Deprecated
    private static double round4(double d2) {
        return Double.isNaN(d2) || Math.abs(d2) >= 4.503599627370496E15 ? d2 : (double)Math.round(d2 * 10000.0) / 10000.0;
    }
}

