/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import atlantafx.base.controls.CustomTextField;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class TextFieldUtil {
    private static final Duration FADE_DURATION = Duration.millis((double)350.0);

    public static void setupClearButtonField(CustomTextField customTextField) {
        TextFieldUtil.setupClearButtonField(customTextField, customTextField.rightProperty());
    }

    private static void setupClearButtonField(final TextField textField, ObjectProperty<Node> objectProperty) {
        textField.getStyleClass().add((Object)"clearable-field");
        Region region = new Region();
        region.getStyleClass().addAll((Object[])new String[]{"graphic"});
        StackPane stackPane = new StackPane(new Node[]{region});
        stackPane.getStyleClass().addAll((Object[])new String[]{"clear-button"});
        stackPane.setOpacity(0.0);
        stackPane.setCursor(Cursor.DEFAULT);
        stackPane.setOnMouseReleased(mouseEvent -> textField.clear());
        stackPane.managedProperty().bind((ObservableValue)textField.editableProperty());
        stackPane.visibleProperty().bind((ObservableValue)textField.editableProperty());
        objectProperty.set((Object)stackPane);
        final FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, (Node)stackPane);
        fadeTransition.setCycleCount(1);
        textField.textProperty().addListener(new InvalidationListener(){
            private boolean isButtonVisible = false;

            public void invalidated(Observable observable) {
                boolean bl2;
                String string = textField.getText();
                boolean bl3 = bl2 = string == null || string.isEmpty();
                if (bl2 == this.isButtonVisible) {
                    this.isButtonVisible = !bl2;
                    this.fadeTo(this.isButtonVisible);
                }
            }

            private void fadeTo(boolean bl2) {
                fadeTransition.stop();
                fadeTransition.setFromValue(bl2 ? 0.0 : 1.0);
                fadeTransition.setToValue(bl2 ? 1.0 : 0.0);
                fadeTransition.play();
            }
        });
    }
}

