/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import java.util.function.DoubleUnaryOperator;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class Observables {
    public static Runnable runOnInvalidate(Runnable runnable, Observable ... observableArray) {
        InvalidationListener invalidationListener = observable -> runnable.run();
        for (Observable observable2 : observableArray) {
            observable2.addListener(invalidationListener);
        }
        runnable.run();
        return () -> {
            for (Observable observable : observableArray) {
                observable.removeListener(invalidationListener);
            }
        };
    }

    public static Runnable runOnChange(Runnable runnable, ObservableValue<?> ... observableValueArray) {
        ChangeListener changeListener = (observableValue, object, object2) -> runnable.run();
        for (ObservableValue<?> observableValue2 : observableValueArray) {
            observableValue2.addListener(changeListener);
        }
        runnable.run();
        return () -> {
            for (ObservableValue observableValue : observableValueArray) {
                observableValue.removeListener(changeListener);
            }
        };
    }

    public static DoubleBinding withFallbackOnNan(ReadOnlyDoubleProperty readOnlyDoubleProperty, double d2) {
        return Bindings.createDoubleBinding(() -> !Double.isNaN(readOnlyDoubleProperty.get()) ? readOnlyDoubleProperty.get() : d2, (Observable[])new Observable[]{readOnlyDoubleProperty});
    }

    public static DoubleBinding withFallbackOnNan(ReadOnlyDoubleProperty readOnlyDoubleProperty, double d2, DoubleUnaryOperator doubleUnaryOperator) {
        return Bindings.createDoubleBinding(() -> !Double.isNaN(readOnlyDoubleProperty.get()) ? doubleUnaryOperator.applyAsDouble(readOnlyDoubleProperty.get()) : d2, (Observable[])new Observable[]{readOnlyDoubleProperty});
    }
}

