/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.controls;

import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.text.TextAlignment;
import us.hebi.gui.controls.Css;
import us.hebi.gui.controls.Observables;
import us.hebi.gui.controls.TextUtil;

public class HIconButton
extends JFXButton
implements Css.SizeProperty,
Css.TypeProperty {
    private final ObjectProperty<String> glyphName = new SimpleObjectProperty(null);
    private final ObjectProperty<Css.Type> type = new SimpleObjectProperty((Object)Css.Type.Outline);
    private final ObjectProperty<Css.Size> size = new SimpleObjectProperty((Object)Css.Size.Normal);
    private FontAwesomeIconView iconView = null;

    public HIconButton() {
        Css.addClass(this, "hebi-icon-button");
        this.setContentDisplay(ContentDisplay.TOP);
        this.setTextOverrun(OverrunStyle.CENTER_WORD_ELLIPSIS);
        this.setMnemonicParsing(false);
        this.setWrapText(true);
        this.setTextAlignment(TextAlignment.CENTER);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setMinWidth(60.0);
        Observables.runOnChange(this::setIconGraphic, new ObservableValue[]{this.glyphName});
        Observables.runOnChange(() -> this.getType().applyPseudoState((Node)this), new ObservableValue[]{this.type});
        Observables.runOnChange(() -> this.getSize().applyPseudoState((Node)this), new ObservableValue[]{this.size});
    }

    public String getGlyphName() {
        return (String)this.glyphName.get();
    }

    public ObjectProperty<String> glyphNameProperty() {
        return this.glyphName;
    }

    public void setGlyphName(String string) {
        this.glyphName.set((Object)string);
    }

    private void setIconGraphic() {
        String string = this.getGlyphName();
        if (TextUtil.isNullOrBlank(string)) {
            this.setGraphic(null);
            return;
        }
        if (this.iconView == null) {
            this.iconView = Css.addClass(new FontAwesomeIconView(), "hebi-icon");
        }
        this.setGraphic((Node)this.iconView);
        this.iconView.setGlyphName(string);
    }

    @Override
    public ObjectProperty<Css.Size> sizeProperty() {
        return this.size;
    }

    @Override
    public void setSize(Css.Size size) {
        this.size.set((Object)size);
    }

    @Override
    public Css.Size getSize() {
        return (Css.Size)((Object)this.size.get());
    }

    @Override
    public Css.Type getType() {
        return (Css.Type)((Object)this.type.get());
    }

    @Override
    public ObjectProperty<Css.Type> typeProperty() {
        return this.type;
    }

    @Override
    public void setType(Css.Type type) {
        this.type.set((Object)type);
    }
}

