/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui;

import io.fair_acc.bench.BenchLevel;
import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.bench.LiveDisplayRecorder;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import us.hebi.gui.Scope;
import us.hebi.gui.e;
import us.hebi.gui.lib.alr;
import us.hebi.gui.lib.alw;
import us.hebi.gui.lib.amd;
import us.hebi.gui.lib.ame;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.ana;
import us.hebi.gui.lib.asf;
import us.hebi.gui.lib.asg;
import us.hebi.gui.lib.atf;
import us.hebi.gui.lib.atl;
import us.hebi.gui.lib.auv;
import us.hebi.gui.lib.axz;
import us.hebi.gui.lib.ayo;
import us.hebi.gui.lib.ayx;
import us.hebi.gui.lib.ayy;
import us.hebi.gui.lib.azf;
import us.hebi.gui.lib.azg;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.fc;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.io;
import us.hebi.gui.views.scope.ScopePresenter;
import us.hebi.gui.views.scope.ScopeView;

public class ScopeApp
extends Application {
    private static String[] ipAddresses = null;
    private static final MeasurementRecorder d = MeasurementRecorder.printRecorder().maxLevel(BenchLevel.Debug);
    private static final DurationMeasure c = d.newDuration("Scope initialization");

    public void start(Stage stage) throws Exception {
        c.start();
        if (Boolean.valueOf(amd.a("hebi.debug", "false")).booleanValue()) {
            System.out.println("[debug] setting uncaught exception handler.");
            Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
                throwable.printStackTrace();
                asf.a(throwable, stage.getOwner());
            });
        }
        if (amd.g("hebi.statistics.scope")) {
            alw.b = LiveDisplayRecorder.createChart("Scope Stats", parent -> {
                parent.getStylesheets().add((Object)e.Y);
                Stage stage = new Stage();
                stage.setScene(new Scene(parent));
                Platform.runLater(() -> ((Stage)stage).show());
            });
        }
        ayo.bX();
        Image image = e.d;
        Text text = new Text("Loading ...");
        text.setFill((Paint)Color.WHITE);
        text.setFont(Font.font((double)30.0));
        StackPane stackPane = new StackPane(new Node[]{new ImageView(image), text});
        Stage stage2 = new Stage(StageStyle.TRANSPARENT);
        stage2.setScene(new Scene((Parent)stackPane, (Paint)us.hebi.gui.b.e));
        stage2.getIcons().add((Object)image);
        CompletableFuture<Void> completableFuture = ayy.a(stage2);
        Locale.setDefault(Locale.ENGLISH);
        Logger.getGlobal().setLevel(Level.WARNING);
        b.a(azf.class, azf.a(this));
        b.a(ana.class, ana.a(Scope.class));
        b.a(ExecutorService.class, Executors.newCachedThreadPool(io.a));
        b.a(asg.class, new asg(stage));
        b.a(atl.class, new atl());
        ayx.a("Scope");
        CompletableFuture[] completableFutureArray = new CompletableFuture[3];
        ScopeApp scopeApp = this;
        Supplier<Object> supplier = () -> new atf(h.a());
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> ScopeApp.a("Lookup initialization", supplier)).thenApplyAsync(atf2 -> {
            b.a(atf2);
            b.a(atf.class, atf2);
            return atf2;
        }, ayo.d);
        ((CompletableFuture)completionStage).thenAcceptAsync(atf2 -> {
            List<InetAddress> list;
            if (ipAddresses == null) {
                System.out.println("Automatically determining broadcast addresses");
                list = amw.d();
            } else {
                System.out.println("Requesting Info from " + Arrays.toString(ipAddresses));
                list = Arrays.stream(ipAddresses).map(fc::a).toList();
            }
            List<InetAddress> list2 = list;
            atf2.setAddresses(list2);
            if (list2.isEmpty()) {
                ame.b(8L, TimeUnit.SECONDS);
                List<InetAddress> list3 = amw.d();
                Platform.runLater(() -> atf2.setAddresses(list3));
            }
        });
        completableFutureArray[0] = completionStage;
        supplier = () -> new auv(h.b());
        completableFutureArray[1] = CompletableFuture.supplyAsync(() -> ScopeApp.a("Plotting initialization", supplier)).thenApplyAsync(auv2 -> {
            b.a(auv2);
            b.a(auv.class, auv2);
            return auv2;
        }, ayo.d);
        completableFutureArray[2] = completableFuture;
        CompletableFuture.allOf(completableFutureArray).thenRunAsync(() -> {
            Stage stage3 = stage;
            ScopeView scopeView = new ScopeView();
            Supplier<Parent> supplier = scopeView::getView;
            Parent parent = (Parent)((Supplier<Object>)() -> ScopeApp.a("FXML loading", supplier)).get();
            Scene scene = new Scene(parent);
            stage3.setTitle("HEBI Robotics Scope " + axz.a.af);
            stage3.setScene(scene);
            if (alr.aw()) {
                List list = ayo.a(Path.of(System.getProperty("app.dir"), new String[0]), "icon-*.png").orElseGet(() -> h.a(new Image[]{e.c}));
                stage3.getIcons().setAll((Collection)list);
            }
            ((ScopePresenter)scopeView.getPresenter()).initKeyboardBindings(scene);
            stage3.show();
            stage3.setOnCloseRequest(windowEvent -> Platform.exit());
            azg.d(parent);
            azj.g(parent);
            stage3.getScene().getRoot().mouseTransparentProperty().bind((ObservableValue)stage3.focusedProperty().not());
            c.stop();
            stage2.hide();
            CompletableFuture.supplyAsync(XYChart::new, ayo.d);
        }, ayo.d);
    }

    public void stop() {
        b.a();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            ipAddresses = stringArray;
        }
        ScopeApp.launch((String[])stringArray);
    }

    private static /* synthetic */ Object a(String string, Supplier supplier) {
        DurationMeasure durationMeasure = d.newDebugDuration(string);
        durationMeasure.start();
        Object t2 = supplier.get();
        durationMeasure.stop();
        return t2;
    }
}

