/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.glue;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public class UnsafeAccess {
    public static final Unsafe UNSAFE = UnsafeAccess.findUnsafeOrNull();
    private static final boolean isAvailable = UNSAFE != null;
    public static final int BOOLEAN_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(boolean[].class) : 0;
    public static final int BYTE_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(byte[].class) : 0;
    public static final int CHAR_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(char[].class) : 0;
    public static final int SHORT_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(short[].class) : 0;
    public static final int INT_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(int[].class) : 0;
    public static final int FLOAT_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(float[].class) : 0;
    public static final int LONG_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(long[].class) : 0;
    public static final int DOUBLE_ARRAY_BASE_OFFSET = UNSAFE != null ? UNSAFE.arrayBaseOffset(double[].class) : 0;

    static int getClassVersion() {
        return 50;
    }

    public static boolean isAvailable() {
        return isAvailable;
    }

    private static Unsafe findUnsafeOrNull() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> clazz = Unsafe.class;
                        try {
                            Field field = Unsafe.class.getDeclaredField("theUnsafe");
                            field.setAccessible(true);
                            return (Unsafe)clazz.cast(field.get(clazz));
                        }
                        catch (Exception exception) {
                            for (Field field : clazz.getDeclaredFields()) {
                                if (!clazz.isAssignableFrom(field.getType())) continue;
                                field.setAccessible(true);
                                return (Unsafe)clazz.cast(field.get(clazz));
                            }
                            return null;
                        }
                    }
                });
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

