/*
 * Decompiled with CFR 0.152.
 */
package picocli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoComplete {
    public static final int EXIT_CODE_SUCCESS = 0;
    public static final int EXIT_CODE_INVALID_INPUT = 1;
    public static final int EXIT_CODE_COMMAND_SCRIPT_EXISTS = 2;
    public static final int EXIT_CODE_COMPLETION_SCRIPT_EXISTS = 3;
    public static final int EXIT_CODE_EXECUTION_ERROR = 4;
    private static final String SCRIPT_HEADER = "#!/usr/bin/env bash\n#\n# %1$s Bash Completion\n# =======================\n#\n# Bash completion support for the `%1$s` command,\n# generated by [picocli](https://picocli.info/) version %2$s.\n#\n# Installation\n# ------------\n#\n# 1. Source all completion scripts in your .bash_profile\n#\n#   cd $YOUR_APP_HOME/bin\n#   for f in $(find . -name \"*_completion\"); do line=\". $(pwd)/$f\"; grep \"$line\" ~/.bash_profile || echo \"$line\" >> ~/.bash_profile; done\n#\n# 2. Open a new bash console, and type `%1$s [TAB][TAB]`\n#\n# 1a. Alternatively, if you have [bash-completion](https://github.com/scop/bash-completion) installed:\n#     Place this file in a `bash-completion.d` folder:\n#\n#   * /etc/bash-completion.d\n#   * /usr/local/etc/bash-completion.d\n#   * ~/bash-completion.d\n#\n# Documentation\n# -------------\n# The script is called by bash whenever [TAB] or [TAB][TAB] is pressed after\n# '%1$s (..)'. By reading entered command line parameters,\n# it determines possible bash completions and writes them to the COMPREPLY variable.\n# Bash then completes the user input if only one entry is listed in the variable or\n# shows the options if more than one is listed in COMPREPLY.\n#\n# References\n# ----------\n# [1] http://stackoverflow.com/a/12495480/1440785\n# [2] http://tiswww.case.edu/php/chet/bash/FAQ\n# [3] https://www.gnu.org/software/bash/manual/html_node/The-Shopt-Builtin.html\n# [4] http://zsh.sourceforge.net/Doc/Release/Options.html#index-COMPLETE_005fALIASES\n# [5] https://stackoverflow.com/questions/17042057/bash-check-element-in-array-for-elements-in-another-array/17042655#17042655\n# [6] https://www.gnu.org/software/bash/manual/html_node/Programmable-Completion.html#Programmable-Completion\n# [7] https://stackoverflow.com/questions/3249432/can-a-bash-tab-completion-script-be-used-in-zsh/27853970#27853970\n#\n\nif [ -n \"$BASH_VERSION\" ]; then\n  # Enable programmable completion facilities when using bash (see [3])\n  shopt -s progcomp\nelif [ -n \"$ZSH_VERSION\" ]; then\n  # Make alias a distinct command for completion purposes when using zsh (see [4])\n  setopt COMPLETE_ALIASES\n  alias compopt=complete\n\n  # Enable bash completion in zsh (see [7])\n  # Only initialize completions module once to avoid unregistering existing completions.\n  if ! type compdef > /dev/null; then\n    autoload -U +X compinit && compinit\n  fi\n  autoload -U +X bashcompinit && bashcompinit\nfi\n\n# CompWordsContainsArray takes an array and then checks\n# if all elements of this array are in the global COMP_WORDS array.\n#\n# Returns zero (no error) if all elements of the array are in the COMP_WORDS array,\n# otherwise returns 1 (error).\nfunction CompWordsContainsArray() {\n  declare -a localArray\n  localArray=(\"$@\")\n  local findme\n  for findme in \"${localArray[@]}\"; do\n    if ElementNotInCompWords \"$findme\"; then return 1; fi\n  done\n  return 0\n}\nfunction ElementNotInCompWords() {\n  local findme=\"$1\"\n  local element\n  for element in \"${COMP_WORDS[@]}\"; do\n    if [[ \"$findme\" = \"$element\" ]]; then return 1; fi\n  done\n  return 0\n}\n\n# The `currentPositionalIndex` function calculates the index of the current positional parameter.\n#\n# currentPositionalIndex takes three parameters:\n# the command name,\n# a space-separated string with the names of options that take a parameter, and\n# a space-separated string with the names of boolean options (that don't take any params).\n# When done, this function echos the current positional index to std_out.\n#\n# Example usage:\n# local currIndex=$(currentPositionalIndex \"mysubcommand\" \"$ARG_OPTS\" \"$FLAG_OPTS\")\nfunction currentPositionalIndex() {\n  local commandName=\"$1\"\n  local optionsWithArgs=\"$2\"\n  local booleanOptions=\"$3\"\n  local previousWord\n  local result=0\n\n  for i in $(seq $((COMP_CWORD - 1)) -1 0); do\n    previousWord=${COMP_WORDS[i]}\n    if [ \"${previousWord}\" = \"$commandName\" ]; then\n      break\n    fi\n    if [[ \"${optionsWithArgs}\" =~ ${previousWord} ]]; then\n      ((result-=2)) # Arg option and its value not counted as positional param\n    elif [[ \"${booleanOptions}\" =~ ${previousWord} ]]; then\n      ((result-=1)) # Flag option itself not counted as positional param\n    fi\n    ((result++))\n  done\n  echo \"$result\"\n}\n\n# compReplyArray generates a list of completion suggestions based on an array, ensuring all values are properly escaped.\n#\n# compReplyArray takes a single parameter: the array of options to be displayed\n#\n# The output is echoed to std_out, one option per line.\n#\n# Example usage:\n# local options=(\"foo\", \"bar\", \"baz\")\n# local IFS=$'\\n'\n# COMPREPLY=($(compReplyArray \"${options[@]}\"))\nfunction compReplyArray() {\n  declare -a options\n  options=(\"$@\")\n  local curr_word=${COMP_WORDS[COMP_CWORD]}\n  local i\n  local quoted\n  local optionList=()\n\n  for (( i=0; i<${#options[@]}; i++ )); do\n    # Double escape, since we want escaped values, but compgen -W expands the argument\n    printf -v quoted %%q \"${options[i]}\"\n    quoted=\\'${quoted//\\'/\\'\\\\\\'\\'}\\'\n\n    optionList[i]=$quoted\n  done\n\n  # We also have to add another round of escaping to $curr_word.\n  curr_word=${curr_word//\\\\/\\\\\\\\}\n  curr_word=${curr_word//\\'/\\\\\\'}\n\n  # Actually generate completions.\n  local IFS=$'\\n'\n  echo -e \"$(compgen -W \"${optionList[*]}\" -- \"$curr_word\")\"\n}\n\n";
    private static final String SCRIPT_FOOTER = "\n# Define a completion specification (a compspec) for the\n# `%1$s`, `%1$s.sh`, and `%1$s.bash` commands.\n# Uses the bash `complete` builtin (see [6]) to specify that shell function\n# `_complete_%1$s` is responsible for generating possible completions for the\n# current word on the command line.\n# The `-o default` option means that if the function generated no matches, the\n# default Bash completions and the Readline default filename completions are performed.\ncomplete -F _complete_%1$s -o default %1$s %1$s.sh %1$s.bash\n";

    private AutoComplete() {
    }

    public static void main(String ... stringArray) {
        CommandLine.IExecutionExceptionHandler iExecutionExceptionHandler = new CommandLine.IExecutionExceptionHandler(){

            public int handleExecutionException(Exception exception, CommandLine commandLine, CommandLine.ParseResult parseResult) {
                exception.printStackTrace();
                commandLine.usage(commandLine.getErr());
                return 4;
            }
        };
        int n2 = new CommandLine(new App()).setExecutionExceptionHandler(iExecutionExceptionHandler).execute(stringArray);
        if (n2 == 0 && AutoComplete.exitOnSuccess() || n2 != 0 && AutoComplete.exitOnError()) {
            System.exit(n2);
        }
    }

    private static boolean exitOnSuccess() {
        return AutoComplete.syspropDefinedAndNotFalse("picocli.autocomplete.systemExitOnSuccess");
    }

    private static boolean exitOnError() {
        return AutoComplete.syspropDefinedAndNotFalse("picocli.autocomplete.systemExitOnError");
    }

    private static boolean syspropDefinedAndNotFalse(String string) {
        String string2 = System.getProperty(string);
        return string2 != null && !"false".equalsIgnoreCase(string2);
    }

    private static String bashify(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_') {
                stringBuilder.append(c2);
                continue;
            }
            if (!Character.isSpaceChar(c2)) continue;
            stringBuilder.append('_');
        }
        return stringBuilder.toString();
    }

    private static <T> Predicate<T> negate(final Predicate<T> predicate) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t2) {
                return !predicate.test(t2);
            }
        };
    }

    private static <K, T extends K> List<T> filter(List<T> list, Predicate<K> predicate) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t2 : list) {
            if (!predicate.test(t2)) continue;
            arrayList.add(t2);
        }
        return arrayList;
    }

    private static String sanitizeScriptName(String string) {
        return string.replaceAll("\\.sh", "").replaceAll("\\.bash", "").replaceAll("\\.\\/", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bash(String string, File file, File file2, CommandLine commandLine) throws IOException {
        String string2 = AutoComplete.bash(string, commandLine);
        FileWriter fileWriter = null;
        Writer writer = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(string2);
            if (file2 != null) {
                writer = new FileWriter(file2);
                writer.write("#!/usr/bin/env bash\n\nLIBS=path/to/libs\nCP=\"${LIBS}/myApp.jar\"\njava -cp \"${CP}\" '" + commandLine.getCommand().getClass().getName() + "' $@");
            }
        }
        finally {
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static String bash(String string, CommandLine commandLine) {
        if (string == null) {
            throw new NullPointerException("scriptName");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        string = AutoComplete.sanitizeScriptName(string);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format(SCRIPT_HEADER, string, "4.7.0"));
        List<CommandDescriptor> list = AutoComplete.createHierarchy(string, commandLine);
        stringBuilder.append(AutoComplete.generateEntryPointFunction(string, commandLine, list));
        for (CommandDescriptor commandDescriptor : list) {
            if (commandDescriptor.commandLine.getCommandSpec().usageMessage().hidden()) continue;
            stringBuilder.append(AutoComplete.generateFunctionForCommand(commandDescriptor.functionName, commandDescriptor.commandName, commandDescriptor.commandLine));
        }
        stringBuilder.append(String.format(SCRIPT_FOOTER, string));
        return stringBuilder.toString();
    }

    private static List<CommandDescriptor> createHierarchy(String string, CommandLine commandLine) {
        ArrayList<CommandDescriptor> arrayList = new ArrayList<CommandDescriptor>();
        arrayList.add(new CommandDescriptor("_picocli_" + string, "", "", string, commandLine));
        AutoComplete.createSubHierarchy(string, "", commandLine, arrayList);
        return arrayList;
    }

    private static void createSubHierarchy(String string, String string2, CommandLine commandLine, List<CommandDescriptor> list) {
        String string3;
        Object object;
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            object = entry.getValue().getCommandSpec();
            if (((CommandLine.Model.CommandSpec)object).usageMessage().hidden()) continue;
            string3 = entry.getKey();
            String string4 = AutoComplete.bashify(AutoComplete.concat("_", string2.replace(' ', '_'), string3));
            String string5 = AutoComplete.concat("_", "_picocli", string, string4);
            String string6 = string2.length() == 0 ? AutoComplete.concat("_", "_picocli", string) : AutoComplete.concat("_", "_picocli", string, AutoComplete.bashify(string2.replace(' ', '_')));
            list.add(new CommandDescriptor(string5, string6, string2, string3, entry.getValue()));
        }
        for (Map.Entry<String, CommandLine> entry : commandLine.getSubcommands().entrySet()) {
            if (entry.getValue().getCommandSpec().usageMessage().hidden()) continue;
            object = entry.getKey();
            string3 = AutoComplete.concat(" ", new String[]{string2, object});
            AutoComplete.createSubHierarchy(string, string3, entry.getValue(), list);
        }
    }

    private static String generateEntryPointFunction(String string, CommandLine commandLine, List<CommandDescriptor> list) {
        String string2 = "# Bash completion entry point function.\n# _complete_%1$s finds which commands and subcommands have been specified\n# on the command line and delegates to the appropriate function\n# to generate possible options and subcommands for the last specified subcommand.\nfunction _complete_%1$s() {\n";
        String string3 = "\n  # No subcommands were specified; generate completions for the top-level command.\n  _picocli_%1$s; return $?;\n}\n";
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append(String.format(string2, string));
        AutoComplete.generatedEdgeCaseFunctionCalls(stringBuilder, list);
        AutoComplete.generateFunctionCallsToArrContains(stringBuilder, list);
        stringBuilder.append(String.format(string3, string));
        return stringBuilder.toString();
    }

    private static void generatedEdgeCaseFunctionCalls(StringBuilder stringBuilder, List<CommandDescriptor> list) {
        stringBuilder.append("  # Edge case: if command line has no space after subcommand, then don't assume this subcommand is selected (remkop/picocli#1468).\n");
        for (CommandDescriptor commandDescriptor : list.subList(1, list.size())) {
            String string = AutoComplete.concat(" ", commandDescriptor.parentWithoutTopLevelCommand, commandDescriptor.commandName);
            stringBuilder.append(String.format("  if [ \"${COMP_LINE}\" = \"${COMP_WORDS[0]} %1$s\" ];    then %2$s; return $?; fi\n", string, commandDescriptor.parentFunctionName));
        }
        stringBuilder.append("\n");
    }

    private static void generateFunctionCallsToArrContains(StringBuilder stringBuilder, List<CommandDescriptor> list) {
        stringBuilder.append("  # Find the longest sequence of subcommands and call the bash function for that subcommand.\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CommandDescriptor object : list.subList(1, list.size())) {
            int n2 = arrayList.size();
            String string = AutoComplete.concat(" ", object.parentWithoutTopLevelCommand, object.commandName);
            arrayList.add(String.format("  if CompWordsContainsArray \"${cmds%2$d[@]}\"; then %1$s; return $?; fi\n", object.functionName, n2));
            stringBuilder.append(String.format("  local cmds%2$d=(%1$s)\n", string, n2));
        }
        stringBuilder.append("\n");
        Collections.reverse(arrayList);
        for (String string : arrayList) {
            stringBuilder.append(string);
        }
    }

    private static String concat(String string, String ... stringArray) {
        return AutoComplete.concat(string, Arrays.asList(stringArray));
    }

    private static String concat(String string, List<String> list) {
        return AutoComplete.concat(string, list, null, new NullFunction());
    }

    private static <V, T extends V> String concat(String string, List<T> list, T t2, Function<V, String> function) {
        StringBuilder stringBuilder = new StringBuilder();
        for (T t3 : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(function.apply(t3));
        }
        if (t2 == null) {
            return stringBuilder.toString();
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.append(function.apply(t2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String generateFunctionForCommand(String string, String string2, CommandLine commandLine) {
        void var15_23;
        String string3 = "\n# Generates completions for the options and subcommands of the `%s` %scommand.\nfunction %s() {\n  # Get completion data\n  local curr_word=${COMP_WORDS[COMP_CWORD]}\n%s\n  local commands=\"%s\"\n  local flag_opts=\"%s\"\n  local arg_opts=\"%s\"\n";
        String string4 = "\n  if [[ \"${curr_word}\" == -* ]]; then\n    COMPREPLY=( $(compgen -W \"${flag_opts} ${arg_opts}\" -- \"${curr_word}\") )\n  else\n    local positionals=\"\"\n%s    local IFS=$'\\n'\n    COMPREPLY=( $(compgen -W \"${commands// /$'\\n'}${IFS}${positionals}\" -- \"${curr_word}\") )\n  fi\n}\n";
        CommandLine.Model.CommandSpec commandSpec = commandLine.getCommandSpec();
        String string5 = AutoComplete.optionNames(AutoComplete.filter(commandSpec.options(), new BooleanArgFilter()));
        List<CommandLine.Model.OptionSpec> list = AutoComplete.filter(commandSpec.options(), AutoComplete.negate(new BooleanArgFilter()));
        String string6 = AutoComplete.optionNames(list);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String object22 : commandLine.getSubcommands().keySet()) {
            if (commandLine.getSubcommands().get(object22).getCommandSpec().usageMessage().hidden()) continue;
            linkedHashSet.add(object22);
        }
        if (commandLine.getParent() != null && commandLine.getCommand() instanceof CommandLine.HelpCommand) {
            linkedHashSet = new LinkedHashSet(linkedHashSet);
            for (CommandLine commandLine2 : commandLine.getParent().getSubcommands().values()) {
                if (commandLine == commandLine2 || commandLine2.getCommandSpec().usageMessage().hidden()) continue;
                linkedHashSet.add(commandLine2.getCommandName());
            }
        }
        Iterator<CommandLine> iterator = AutoComplete.concat(" ", new ArrayList<String>(linkedHashSet)).trim();
        StringBuilder stringBuilder = new StringBuilder(1024);
        String string7 = string.equals("_picocli_" + string2) ? "" : "sub";
        String string8 = list.isEmpty() ? "" : "  local prev_word=${COMP_WORDS[COMP_CWORD-1]}\n";
        stringBuilder.append(String.format(string3, string2, string7, string, string8, iterator, string5, string6));
        for (CommandLine.Model.OptionSpec optionSpec : commandSpec.options()) {
            if (optionSpec.hidden() || optionSpec.completionCandidates() == null) continue;
            AutoComplete.generateCompletionCandidates(stringBuilder, optionSpec);
        }
        stringBuilder.append(AutoComplete.generateOptionsSwitch(list));
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : commandSpec.positionalParameters()) {
            if (positionalParamSpec.completionCandidates() == null) continue;
            AutoComplete.generatePositionParamCompletionCandidates(stringBuilder, positionalParamSpec);
        }
        String string9 = AutoComplete.generatePositionalParamsCases(commandSpec.positionalParameters(), "", "${curr_word}");
        String string10 = "";
        if (string9.length() > 0) {
            String string11 = "    local currIndex\n    currIndex=$(currentPositionalIndex \"%s\" \"${arg_opts}\" \"${flag_opts}\")\n%s";
            String string12 = String.format(string11, string2, string9);
        }
        stringBuilder.append(String.format(string4, var15_23));
        return stringBuilder.toString();
    }

    private static void generatePositionParamCompletionCandidates(StringBuilder stringBuilder, CommandLine.Model.PositionalParamSpec positionalParamSpec) {
        String string = AutoComplete.bashify(positionalParamSpec.paramLabel());
        stringBuilder.append(String.format("  local %s_pos_param_args=(\"%s\") # %d-%d values\n", string, AutoComplete.concat("\" \"", AutoComplete.extract(positionalParamSpec.completionCandidates())).trim(), positionalParamSpec.index().min(), positionalParamSpec.index().max()));
    }

    private static void generateCompletionCandidates(StringBuilder stringBuilder, CommandLine.Model.OptionSpec optionSpec) {
        stringBuilder.append(String.format("  local %s_option_args=(\"%s\") # %s values\n", AutoComplete.bashify(optionSpec.paramLabel()), AutoComplete.concat("\" \"", AutoComplete.extract(optionSpec.completionCandidates())).trim(), optionSpec.longestName()));
    }

    private static List<String> extract(Iterable<String> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : iterable) {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static String generatePositionalParamsCases(List<CommandLine.Model.PositionalParamSpec> list, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : list) {
            if (positionalParamSpec.hidden()) continue;
            Class<?> clazz = positionalParamSpec.type();
            if (positionalParamSpec.typeInfo().isMultiValue()) {
                clazz = positionalParamSpec.typeInfo().getAuxiliaryTypes()[0];
            }
            String string3 = AutoComplete.bashify(positionalParamSpec.paramLabel());
            String string4 = stringBuilder.length() > 0 ? "elif" : "if";
            int n2 = positionalParamSpec.index().min();
            int n3 = positionalParamSpec.index().max();
            if (positionalParamSpec.completionCandidates() != null) {
                stringBuilder.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", string, string4, n2, n3));
                stringBuilder.append(String.format("%s      positionals=$( compReplyArray \"${%s_pos_param_args[@]}\" )\n", string, string3, string2));
                continue;
            }
            if (clazz.equals(File.class) || "java.nio.file.Path".equals(clazz.getName())) {
                stringBuilder.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", string, string4, n2, n3));
                stringBuilder.append(String.format("%s      local IFS=$'\\n'\n", string));
                stringBuilder.append(String.format("%s      type compopt &>/dev/null && compopt -o filenames\n", string));
                stringBuilder.append(String.format("%s      positionals=$( compgen -f -- \"%s\" ) # files\n", string, string2));
                continue;
            }
            if (!clazz.equals(InetAddress.class)) continue;
            stringBuilder.append(String.format("%s    %s (( currIndex >= %d && currIndex <= %d )); then\n", string, string4, n2, n3));
            stringBuilder.append(String.format("%s      type compopt &>/dev/null && compopt -o filenames\n", string));
            stringBuilder.append(String.format("%s      positionals=$( compgen -A hostname -- \"%s\" )\n", string, string2));
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(String.format("%s    fi\n", string));
        }
        return stringBuilder.toString();
    }

    private static String generateOptionsSwitch(List<CommandLine.Model.OptionSpec> list) {
        String string = AutoComplete.generateOptionsCases(list, "", "${curr_word}");
        if (string.length() == 0) {
            return "";
        }
        return "\n  type compopt &>/dev/null && compopt +o default\n\n  case ${prev_word} in\n" + string + "  esac\n";
    }

    private static String generateOptionsCases(List<CommandLine.Model.OptionSpec> list, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (CommandLine.Model.OptionSpec optionSpec : list) {
            if (optionSpec.hidden()) continue;
            Class<?> clazz = optionSpec.type();
            if (optionSpec.typeInfo().isMultiValue()) {
                clazz = optionSpec.typeInfo().getAuxiliaryTypes()[0];
            }
            if (optionSpec.completionCandidates() != null) {
                stringBuilder.append(String.format("%s    %s)\n", string, AutoComplete.concat("|", optionSpec.names())));
                stringBuilder.append(String.format("%s      local IFS=$'\\n'\n", string));
                stringBuilder.append(String.format("%s      COMPREPLY=( $( compReplyArray \"${%s_option_args[@]}\" ) )\n", string, AutoComplete.bashify(optionSpec.paramLabel()), string2));
                stringBuilder.append(String.format("%s      return $?\n", string));
                stringBuilder.append(String.format("%s      ;;\n", string));
                continue;
            }
            if (clazz.equals(File.class) || "java.nio.file.Path".equals(clazz.getName())) {
                stringBuilder.append(String.format("%s    %s)\n", string, AutoComplete.concat("|", optionSpec.names())));
                stringBuilder.append(String.format("%s      local IFS=$'\\n'\n", string));
                stringBuilder.append(String.format("%s      type compopt &>/dev/null && compopt -o filenames\n", string));
                stringBuilder.append(String.format("%s      COMPREPLY=( $( compgen -f -- \"%s\" ) ) # files\n", string, string2));
                stringBuilder.append(String.format("%s      return $?\n", string));
                stringBuilder.append(String.format("%s      ;;\n", string));
                continue;
            }
            if (clazz.equals(InetAddress.class)) {
                stringBuilder.append(String.format("%s    %s)\n", string, AutoComplete.concat("|", optionSpec.names())));
                stringBuilder.append(String.format("%s      type compopt &>/dev/null && compopt -o filenames\n", string));
                stringBuilder.append(String.format("%s      COMPREPLY=( $( compgen -A hostname -- \"%s\" ) )\n", string, string2));
                stringBuilder.append(String.format("%s      return $?\n", string));
                stringBuilder.append(String.format("%s      ;;\n", string));
                continue;
            }
            stringBuilder.append(String.format("%s    %s)\n", string, AutoComplete.concat("|", optionSpec.names())));
            stringBuilder.append(String.format("%s      return\n", string));
            stringBuilder.append(String.format("%s      ;;\n", string));
        }
        return stringBuilder.toString();
    }

    private static String optionNames(List<CommandLine.Model.OptionSpec> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CommandLine.Model.OptionSpec optionSpec : list) {
            if (optionSpec.hidden()) continue;
            arrayList.addAll(Arrays.asList(optionSpec.names()));
        }
        return AutoComplete.concat(" ", arrayList, "", new NullFunction()).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int complete(CommandLine.Model.CommandSpec commandSpec, String[] stringArray, int n2, int n3, int n4, List<CharSequence> list) {
        Object object;
        if (commandSpec == null) {
            throw new NullPointerException("spec is null");
        }
        if (stringArray == null) {
            throw new NullPointerException("args is null");
        }
        if (list == null) {
            throw new NullPointerException("candidates list is null");
        }
        if (n2 == stringArray.length) {
            object = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, object, 0, stringArray.length);
            stringArray = object;
            stringArray[n2] = "";
        }
        if (n2 < 0 || n2 >= stringArray.length) {
            throw new IllegalArgumentException("Invalid argIndex " + n2 + ": args array only has " + stringArray.length + " elements.");
        }
        if (n3 < 0 || n3 > stringArray[n2].length()) {
            throw new IllegalArgumentException("Invalid positionInArg " + n3 + ": args[" + n2 + "] (" + stringArray[n2] + ") only has " + stringArray[n2].length() + " characters.");
        }
        object = stringArray[n2];
        boolean bl2 = commandSpec.parser().collectErrors();
        try {
            Object object2;
            String string = ((String)object).substring(0, n3);
            commandSpec.parser().collectErrors(true);
            CommandLine commandLine = new CommandLine(commandSpec);
            CommandLine.ParseResult parseResult = commandLine.parseArgs(stringArray);
            if (n2 >= parseResult.tentativeMatch.size()) {
                object2 = AutoComplete.findCompletionStartPoint(parseResult);
                AutoComplete.addCandidatesForArgsFollowing(object2, list);
            } else {
                object2 = parseResult.tentativeMatch.get(n2);
                if (object2 instanceof CommandLine.Model.CommandSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(((CommandLine.Model.CommandSpec)object2).parent(), list);
                } else if (object2 instanceof CommandLine.Model.OptionSpec) {
                    int n5 = ((String)object).indexOf(commandSpec.parser().separator());
                    if (n5 < 0 || n3 < n5) {
                        AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)object2, commandSpec), list);
                    } else {
                        AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)object2, list);
                        int n6 = commandSpec.parser().separator().length();
                        if (n3 < n5 + n6) {
                            int n7 = n3 - n5;
                            String string2 = commandSpec.parser().separator().substring(n7);
                            for (int i2 = 0; i2 < list.size(); ++i2) {
                                list.set(i2, string2 + list.get(i2));
                            }
                            string = ((String)object).substring(n5, n3);
                        } else {
                            string = ((String)object).substring(n5 + n6, n3);
                        }
                    }
                } else if (object2 instanceof CommandLine.Model.PositionalParamSpec) {
                    AutoComplete.addCandidatesForArgsFollowing(AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)object2, commandSpec), list);
                } else {
                    int n8;
                    for (n8 = n2 - 1; n8 > 0 && !AutoComplete.isPicocliModelObject(parseResult.tentativeMatch.get(n8)); --n8) {
                    }
                    if (n8 < 0) {
                        int n9 = -1;
                        return n9;
                    }
                    AutoComplete.addCandidatesForArgsFollowing(parseResult.tentativeMatch.get(n8), list);
                }
            }
            AutoComplete.filterAndTrimMatchingPrefix(string, list);
            int n10 = list.isEmpty() ? -1 : n4;
            return n10;
        }
        finally {
            commandSpec.parser().collectErrors(bl2);
        }
    }

    private static Object findCompletionStartPoint(CommandLine.ParseResult parseResult) {
        List<Object> list = parseResult.tentativeMatch;
        for (int i2 = 1; i2 <= list.size(); ++i2) {
            Object object = list.get(list.size() - i2);
            if (object instanceof CommandLine.Model.CommandSpec) {
                return object;
            }
            if (!(object instanceof CommandLine.Model.ArgSpec)) continue;
            CommandLine.Range range = ((CommandLine.Model.ArgSpec)object).arity();
            if (i2 < range.min()) {
                return object;
            }
            return AutoComplete.findCommandFor((CommandLine.Model.ArgSpec)object, parseResult.commandSpec());
        }
        return parseResult.commandSpec();
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.ArgSpec argSpec, CommandLine.Model.CommandSpec commandSpec) {
        return argSpec instanceof CommandLine.Model.OptionSpec ? AutoComplete.findCommandFor((CommandLine.Model.OptionSpec)argSpec, commandSpec) : AutoComplete.findCommandFor((CommandLine.Model.PositionalParamSpec)argSpec, commandSpec);
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.OptionSpec optionSpec, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.OptionSpec object : commandSpec.options()) {
            if (object != optionSpec) continue;
            return commandSpec;
        }
        for (CommandLine commandLine : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec commandSpec2 = AutoComplete.findCommandFor(optionSpec, commandLine.getCommandSpec());
            if (commandSpec2 == null) continue;
            return commandSpec2;
        }
        return null;
    }

    private static CommandLine.Model.CommandSpec findCommandFor(CommandLine.Model.PositionalParamSpec positionalParamSpec, CommandLine.Model.CommandSpec commandSpec) {
        for (CommandLine.Model.PositionalParamSpec object : commandSpec.positionalParameters()) {
            if (object != positionalParamSpec) continue;
            return commandSpec;
        }
        for (CommandLine commandLine : commandSpec.subcommands().values()) {
            CommandLine.Model.CommandSpec commandSpec2 = AutoComplete.findCommandFor(positionalParamSpec, commandLine.getCommandSpec());
            if (commandSpec2 == null) continue;
            return commandSpec2;
        }
        return null;
    }

    private static boolean isPicocliModelObject(Object object) {
        return object instanceof CommandLine.Model.CommandSpec || object instanceof CommandLine.Model.OptionSpec || object instanceof CommandLine.Model.PositionalParamSpec;
    }

    private static void filterAndTrimMatchingPrefix(String string, List<CharSequence> list) {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        for (CharSequence charSequence : list) {
            if (!charSequence.toString().startsWith(string)) continue;
            hashSet.add(charSequence.subSequence(string.length(), charSequence.length()));
        }
        list.clear();
        list.addAll(hashSet);
    }

    private static void addCandidatesForArgsFollowing(Object object, List<CharSequence> list) {
        if (object == null) {
            return;
        }
        if (object instanceof CommandLine.Model.CommandSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.CommandSpec)object, list);
        } else if (object instanceof CommandLine.Model.OptionSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.OptionSpec)object, list);
        } else if (object instanceof CommandLine.Model.PositionalParamSpec) {
            AutoComplete.addCandidatesForArgsFollowing((CommandLine.Model.PositionalParamSpec)object, list);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.CommandSpec commandSpec, List<CharSequence> list) {
        if (commandSpec == null) {
            return;
        }
        for (Map.Entry<String, CommandLine> object : commandSpec.subcommands().entrySet()) {
            if (object.getValue().getCommandSpec().usageMessage().hidden()) continue;
            list.add(object.getKey());
            list.addAll(Arrays.asList(object.getValue().getCommandSpec().aliases()));
        }
        list.addAll(commandSpec.optionsMap().keySet());
        for (CommandLine.Model.PositionalParamSpec positionalParamSpec : commandSpec.positionalParameters()) {
            if (positionalParamSpec.hidden()) continue;
            AutoComplete.addCandidatesForArgsFollowing(positionalParamSpec, list);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.OptionSpec optionSpec, List<CharSequence> list) {
        if (optionSpec != null && !optionSpec.hidden()) {
            AutoComplete.addCompletionCandidates(optionSpec.completionCandidates(), list);
        }
    }

    private static void addCandidatesForArgsFollowing(CommandLine.Model.PositionalParamSpec positionalParamSpec, List<CharSequence> list) {
        if (positionalParamSpec != null && !positionalParamSpec.hidden()) {
            AutoComplete.addCompletionCandidates(positionalParamSpec.completionCandidates(), list);
        }
    }

    private static void addCompletionCandidates(Iterable<String> iterable, List<CharSequence> list) {
        if (iterable != null) {
            for (String string : iterable) {
                list.add(string);
            }
        }
    }

    private static class CommandDescriptor {
        final String functionName;
        final String parentFunctionName;
        final String parentWithoutTopLevelCommand;
        final String commandName;
        final CommandLine commandLine;

        CommandDescriptor(String string, String string2, String string3, String string4, CommandLine commandLine) {
            this.functionName = string;
            this.parentFunctionName = string2;
            this.parentWithoutTopLevelCommand = string3;
            this.commandName = string4;
            this.commandLine = commandLine;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanArgFilter
    implements Predicate<CommandLine.Model.ArgSpec> {
        private BooleanArgFilter() {
        }

        @Override
        public boolean test(CommandLine.Model.ArgSpec argSpec) {
            return argSpec.type() == Boolean.TYPE || argSpec.type() == Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Predicate<T> {
        public boolean test(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullFunction
    implements Function<CharSequence, String> {
        private NullFunction() {
        }

        @Override
        public String apply(CharSequence charSequence) {
            return charSequence.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Bashify
    implements Function<CharSequence, String> {
        private Bashify() {
        }

        @Override
        public String apply(CharSequence charSequence) {
            return AutoComplete.bashify(charSequence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Function<T, V> {
        public V apply(T var1);
    }

    @CommandLine.Command(name="generate-completion", version={"generate-completion 4.7.0"}, mixinStandardHelpOptions=true, description={"Generate bash/zsh completion script for ${ROOT-COMMAND-NAME:-the root command of this command}.", "Run the following command to give `${ROOT-COMMAND-NAME:-$PARENTCOMMAND}` TAB completion in the current shell:", "", "  source <(${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME})", ""}, optionListHeading="Options:%n", helpCommand=true)
    public static class GenerateCompletion
    implements Runnable {
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        public void run() {
            String string = AutoComplete.bash(this.spec.root().name(), this.spec.root().commandLine());
            this.spec.commandLine().getOut().print(string);
            this.spec.commandLine().getOut().print('\n');
            this.spec.commandLine().getOut().flush();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CommandLine.Command(name="picocli.AutoComplete", mixinStandardHelpOptions=true, showAtFileInUsageHelp=true, version={"picocli.AutoComplete 4.7.0"}, sortOptions=false, description={"Generates a bash completion script for the specified command class."}, footerHeading="%n@|bold System Properties:|@%n", footer={"Set the following system properties to control the exit code of this program:", "", "* `\"@|yellow picocli.autocomplete.systemExitOnSuccess|@\"`", "   call `System.exit(0)` when execution completes normally.", "* `\"@|yellow picocli.autocomplete.systemExitOnError|@\"`", "   call `System.exit(ERROR_CODE)` when an error occurs.", "", "If these system properties are not defined or have value \"false\", this program completes without terminating the JVM.", "", "Example", "-------", "  java -cp \"myapp.jar;picocli-4.7.0.jar\" \\", "              picocli.AutoComplete my.pkg.MyClass"}, exitCodeListHeading="%nExit Codes:%n", exitCodeList={"0:Successful program execution", "1:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc.", "2:The specified command script exists (Specify `--force` to overwrite).", "3:The specified completion script exists (Specify `--force` to overwrite).", "4:An exception occurred while generating the completion script."}, exitCodeOnInvalidInput=1, exitCodeOnExecutionException=4)
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1", description={"Fully qualified class name of the annotated `@Command` class to generate a completion script for."})
        String commandLineFQCN;
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. When omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Option(names={"-n", "--name"}, description={"Optionally specify the name of the command to create a completion script for. When omitted, the annotated class `@Command(name = \"...\")` attribute is used. If no `@Command(name = ...)` attribute exists, '<CLASS-SIMPLE-NAME>' (in lower-case) is used."})
        String commandName;
        @CommandLine.Option(names={"-o", "--completionScript"}, description={"Optionally specify the path of the completion script file to generate. When omitted, a file named '<commandName>_completion' is generated in the current directory."})
        File autoCompleteScript;
        @CommandLine.Option(names={"-w", "--writeCommandScript"}, description={"Write a '<commandName>' sample command script to the same directory as the completion script."})
        boolean writeCommandScript;
        @CommandLine.Option(names={"-f", "--force"}, description={"Overwrite existing script files."})
        boolean overwriteIfExists;
        @CommandLine.Spec
        CommandLine.Model.CommandSpec spec;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            CommandLine.IFactory iFactory = CommandLine.defaultFactory();
            if (this.factoryClass != null) {
                iFactory = (CommandLine.IFactory)iFactory.create(Class.forName(this.factoryClass));
            }
            Class<?> clazz = Class.forName(this.commandLineFQCN);
            Object obj = iFactory.create(clazz);
            CommandLine commandLine = new CommandLine(obj, iFactory);
            if (this.commandName == null) {
                this.commandName = commandLine.getCommandName();
                if ("<main class>".equals(this.commandName)) {
                    this.commandName = clazz.getSimpleName().toLowerCase();
                }
            }
            if (this.autoCompleteScript == null) {
                this.autoCompleteScript = new File(this.commandName + "_completion");
            }
            File file = null;
            if (this.writeCommandScript) {
                file = new File(this.autoCompleteScript.getAbsoluteFile().getParentFile(), this.commandName);
            }
            if (file != null && !this.overwriteIfExists && this.checkExists(file)) {
                return 2;
            }
            if (!this.overwriteIfExists && this.checkExists(this.autoCompleteScript)) {
                return 3;
            }
            AutoComplete.bash(this.commandName, this.autoCompleteScript, file, commandLine);
            return 0;
        }

        private boolean checkExists(File file) {
            if (file.exists()) {
                PrintWriter printWriter = this.spec.commandLine().getErr();
                printWriter.printf("ERROR: picocli.AutoComplete: %s exists. Specify --force to overwrite.%n", file.getAbsolutePath());
                this.spec.commandLine().usage(printWriter);
                return true;
            }
            return false;
        }
    }
}

