/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;

public interface Validator<T>
extends BiFunction<Control, T, ValidationResult> {
    @SafeVarargs
    public static <T> Validator<T> combine(Validator<T> ... validatorArray) {
        return (control, object) -> Stream.of(validatorArray).map(validator -> (ValidationResult)validator.apply(control, object)).collect(Collectors.reducing(new ValidationResult(), ValidationResult::combine));
    }

    public static <T> Validator<T> createEmptyValidator(String string, Severity severity) {
        return (control, object) -> {
            boolean bl2 = object instanceof String ? object.toString().trim().isEmpty() : object == null;
            return ValidationResult.fromMessageIf(control, string, severity, bl2);
        };
    }

    public static <T> Validator<T> createEmptyValidator(String string) {
        return Validator.createEmptyValidator(string, Severity.ERROR);
    }

    public static <T> Validator<T> createEqualsValidator(String string, Severity severity, Collection<T> collection) {
        return (control, object) -> ValidationResult.fromMessageIf(control, string, severity, !collection.contains(object));
    }

    public static <T> Validator<T> createEqualsValidator(String string, Collection<T> collection) {
        return Validator.createEqualsValidator(string, Severity.ERROR, collection);
    }

    public static <T> Validator<T> createPredicateValidator(Predicate<T> predicate, String string) {
        return Validator.createPredicateValidator(predicate, string, Severity.ERROR);
    }

    public static <T> Validator<T> createPredicateValidator(Predicate<T> predicate, String string, Severity severity) {
        return (control, object) -> ValidationResult.fromMessageIf(control, string, severity, !predicate.test(object));
    }

    public static Validator<String> createRegexValidator(String string, String string2, Severity severity) {
        return (control, string3) -> {
            boolean bl2 = string3 == null ? true : !Pattern.matches(string2, string3);
            return ValidationResult.fromMessageIf(control, string, severity, bl2);
        };
    }

    public static Validator<String> createRegexValidator(String string, Pattern pattern, Severity severity) {
        return (control, string2) -> {
            boolean bl2 = string2 == null ? true : !pattern.matcher((CharSequence)string2).matches();
            return ValidationResult.fromMessageIf(control, string, severity, bl2);
        };
    }
}

