/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.SimpleValidationMessage;
import org.controlsfx.validation.ValidationMessage;

public class ValidationResult {
    private List<ValidationMessage> invalidMessages = new ArrayList<ValidationMessage>();

    public static final ValidationResult fromMessageIf(Control control, String string, Severity severity, boolean bl2) {
        return new ValidationResult().addMessageIf(control, string, severity, bl2);
    }

    public static final ValidationResult fromErrorIf(Control control, String string, boolean bl2) {
        return new ValidationResult().addErrorIf(control, string, bl2);
    }

    public static final ValidationResult fromWarningIf(Control control, String string, boolean bl2) {
        return new ValidationResult().addWarningIf(control, string, bl2);
    }

    public static final ValidationResult fromInfoIf(Control control, String string, boolean bl2) {
        return new ValidationResult().addInfoIf(control, string, bl2);
    }

    public static final ValidationResult fromError(Control control, String string) {
        return ValidationResult.fromMessages(ValidationMessage.error(control, string));
    }

    public static final ValidationResult fromWarning(Control control, String string) {
        return ValidationResult.fromMessages(ValidationMessage.warning(control, string));
    }

    public static final ValidationResult fromInfo(Control control, String string) {
        return ValidationResult.fromMessages(ValidationMessage.info(control, string));
    }

    public static final ValidationResult fromMessages(ValidationMessage ... validationMessageArray) {
        return new ValidationResult().addAll(validationMessageArray);
    }

    public static final ValidationResult fromMessages(Collection<? extends ValidationMessage> collection) {
        return new ValidationResult().addAll(collection);
    }

    public static final ValidationResult fromResults(ValidationResult ... validationResultArray) {
        return new ValidationResult().combineAll(validationResultArray);
    }

    public static final ValidationResult fromResults(Collection<ValidationResult> collection) {
        return new ValidationResult().combineAll(collection);
    }

    public ValidationResult copy() {
        return ValidationResult.fromMessages(this.getMessages());
    }

    public ValidationResult add(ValidationMessage validationMessage) {
        if (validationMessage != null && validationMessage.getSeverity() != Severity.OK) {
            this.invalidMessages.add(validationMessage);
        }
        return this;
    }

    public ValidationResult addMessageIf(Control control, String string, Severity severity, boolean bl2) {
        return bl2 ? this.add(new SimpleValidationMessage(control, string, severity)) : this;
    }

    public ValidationResult addErrorIf(Control control, String string, boolean bl2) {
        return this.addMessageIf(control, string, Severity.ERROR, bl2);
    }

    public ValidationResult addWarningIf(Control control, String string, boolean bl2) {
        return this.addMessageIf(control, string, Severity.WARNING, bl2);
    }

    public ValidationResult addInfoIf(Control control, String string, boolean bl2) {
        return this.addMessageIf(control, string, Severity.INFO, bl2);
    }

    public ValidationResult addAll(Collection<? extends ValidationMessage> collection) {
        collection.stream().forEach(validationMessage -> this.add((ValidationMessage)validationMessage));
        return this;
    }

    public ValidationResult addAll(ValidationMessage ... validationMessageArray) {
        return this.addAll(Arrays.asList(validationMessageArray));
    }

    public ValidationResult combine(ValidationResult validationResult) {
        return validationResult == null ? this.copy() : this.copy().addAll(validationResult.getMessages());
    }

    public ValidationResult combineAll(Collection<ValidationResult> collection) {
        return collection.stream().reduce(this.copy(), (validationResult, validationResult2) -> validationResult2 == null ? validationResult : validationResult.addAll(validationResult2.getMessages()));
    }

    public ValidationResult combineAll(ValidationResult ... validationResultArray) {
        return this.combineAll(Arrays.asList(validationResultArray));
    }

    public Collection<ValidationMessage> getErrors() {
        return this.getMessages(Severity.ERROR);
    }

    public Collection<ValidationMessage> getWarnings() {
        return this.getMessages(Severity.WARNING);
    }

    public Collection<ValidationMessage> getInfos() {
        return this.getMessages(Severity.INFO);
    }

    public Collection<ValidationMessage> getMessages() {
        return this.getMessages(null);
    }

    private Collection<ValidationMessage> getMessages(Severity severity) {
        List<ValidationMessage> list = severity == null ? this.invalidMessages : this.invalidMessages.parallelStream().filter(validationMessage -> validationMessage.getSeverity() == severity).collect(Collectors.toList());
        return Collections.unmodifiableList(list);
    }
}

