/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Comparator;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.SimpleValidationMessage;

public interface ValidationMessage
extends Comparable<ValidationMessage> {
    public static final Comparator<ValidationMessage> COMPARATOR = new Comparator<ValidationMessage>(){

        @Override
        public int compare(ValidationMessage validationMessage, ValidationMessage validationMessage2) {
            if (validationMessage == validationMessage2) {
                return 0;
            }
            if (validationMessage == null) {
                return 1;
            }
            if (validationMessage2 == null) {
                return -1;
            }
            return validationMessage.compareTo(validationMessage2);
        }
    };

    public String getText();

    public Severity getSeverity();

    public Control getTarget();

    public static ValidationMessage error(Control control, String string) {
        return new SimpleValidationMessage(control, string, Severity.ERROR);
    }

    public static ValidationMessage warning(Control control, String string) {
        return new SimpleValidationMessage(control, string, Severity.WARNING);
    }

    public static ValidationMessage info(Control control, String string) {
        return new SimpleValidationMessage(control, string, Severity.INFO);
    }

    public static ValidationMessage ok(Control control, String string) {
        return new SimpleValidationMessage(control, string, Severity.OK);
    }

    public static ValidationMessage ok(Control control) {
        return new SimpleValidationMessage(control, "", Severity.OK);
    }

    @Override
    default public int compareTo(ValidationMessage validationMessage) {
        return validationMessage == null || this.getTarget() != validationMessage.getTarget() ? -1 : this.getSeverity().compareTo(validationMessage.getSeverity());
    }
}

