/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property;

import impl.org.controlsfx.i18n.Localization;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;

public class BeanProperty
implements PropertySheet.Item {
    public static final String CATEGORY_LABEL_KEY = "propertysheet.item.category.label";
    private final Object bean;
    private final PropertyDescriptor beanPropertyDescriptor;
    private final Method readMethod;
    private boolean editable = true;
    private Optional<ObservableValue<? extends Object>> observableValue = Optional.empty();

    public BeanProperty(Object object, PropertyDescriptor propertyDescriptor) {
        this.bean = object;
        this.beanPropertyDescriptor = propertyDescriptor;
        this.readMethod = propertyDescriptor.getReadMethod();
        if (this.beanPropertyDescriptor.getWriteMethod() == null) {
            this.setEditable(false);
        }
        this.findObservableValue();
    }

    @Override
    public String getName() {
        return this.beanPropertyDescriptor.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.beanPropertyDescriptor.getShortDescription();
    }

    @Override
    public Class<?> getType() {
        return this.beanPropertyDescriptor.getPropertyType();
    }

    @Override
    public Object getValue() {
        try {
            return this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public void setValue(Object object) {
        Method method = this.beanPropertyDescriptor.getWriteMethod();
        if (method != null) {
            try {
                method.invoke(this.bean, object);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                if (throwable instanceof PropertyVetoException) {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle(Localization.localize(Localization.asKey("bean.property.change.error.title")));
                    alert.setHeaderText(Localization.localize(Localization.asKey("bean.property.change.error.masthead")));
                    alert.setContentText(throwable.getLocalizedMessage());
                    alert.showAndWait();
                }
                throw throwable;
            }
        }
    }

    @Override
    public String getCategory() {
        String string = (String)this.beanPropertyDescriptor.getValue(CATEGORY_LABEL_KEY);
        if (string == null) {
            string = Localization.localize(Localization.asKey(this.beanPropertyDescriptor.isExpert() ? "bean.property.category.expert" : "bean.property.category.basic"));
        }
        return string;
    }

    public Object getBean() {
        return this.bean;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.beanPropertyDescriptor;
    }

    @Override
    public Optional<Class<? extends PropertyEditor<?>>> getPropertyEditorClass() {
        if (this.beanPropertyDescriptor.getPropertyEditorClass() != null && PropertyEditor.class.isAssignableFrom(this.beanPropertyDescriptor.getPropertyEditorClass())) {
            return Optional.of(this.beanPropertyDescriptor.getPropertyEditorClass());
        }
        return PropertySheet.Item.super.getPropertyEditorClass();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl2) {
        this.editable = bl2;
    }

    @Override
    public Optional<ObservableValue<? extends Object>> getObservableValue() {
        return this.observableValue;
    }

    private void findObservableValue() {
        try {
            String string = this.beanPropertyDescriptor.getName() + "Property";
            Method method = this.getBean().getClass().getMethod(string, new Class[0]);
            Object object = method.invoke(this.getBean(), new Object[0]);
            if (object != null && object instanceof ObservableValue) {
                this.observableValue = Optional.of((ObservableValue)object);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }
}

