/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Callback;

public class FontSelectorDialog
extends Dialog<Font> {
    private FontPanel fontPanel = new FontPanel();

    public FontSelectorDialog(Font font) {
        this.fontPanel.setFont(font);
        this.setResultConverter(buttonType -> buttonType == ButtonType.OK ? this.fontPanel.getFont() : null);
        DialogPane dialogPane = this.getDialogPane();
        this.setTitle(Localization.localize(Localization.asKey("font.dlg.title")));
        dialogPane.setHeaderText(Localization.localize(Localization.asKey("font.dlg.header")));
        dialogPane.getStyleClass().add((Object)"font-selector-dialog");
        dialogPane.getStylesheets().add((Object)FontSelectorDialog.class.getResource("dialogs.css").toExternalForm());
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialogPane.setContent((Node)this.fontPanel);
    }

    private static class FontPanel
    extends GridPane {
        private static final double HGAP = 10.0;
        private static final double VGAP = 5.0;
        private static final Predicate<Object> MATCH_ALL = new Predicate<Object>(){

            @Override
            public boolean test(Object object) {
                return true;
            }
        };
        private static final Double[] fontSizes = new Double[]{8.0, 9.0, 11.0, 12.0, 14.0, 16.0, 18.0, 20.0, 22.0, 24.0, 26.0, 28.0, 36.0, 48.0, 72.0};
        private final FilteredList<String> filteredFontList = new FilteredList(FXCollections.observableArrayList((Collection)Font.getFamilies()), MATCH_ALL);
        private final FilteredList<FontStyle> filteredStyleList = new FilteredList(FXCollections.observableArrayList(), MATCH_ALL);
        private final FilteredList<Double> filteredSizeList = new FilteredList(FXCollections.observableArrayList((Object[])fontSizes), MATCH_ALL);
        private final ListView<String> fontListView = new ListView(this.filteredFontList);
        private final ListView<FontStyle> styleListView = new ListView(this.filteredStyleList);
        private final ListView<Double> sizeListView = new ListView(this.filteredSizeList);
        private final Text sample = new Text(Localization.localize(Localization.asKey("font.dlg.sample.text")));

        private static List<FontStyle> getFontStyles(String string) {
            HashSet<FontStyle> hashSet = new HashSet<FontStyle>();
            for (String string2 : Font.getFontNames((String)string)) {
                hashSet.add(new FontStyle(string2.replace(string, "")));
            }
            ArrayList arrayList = new ArrayList(hashSet);
            Collections.sort(arrayList);
            return arrayList;
        }

        public FontPanel() {
            this.setHgap(10.0);
            this.setVgap(5.0);
            this.setPrefSize(500.0, 300.0);
            this.setMinSize(500.0, 300.0);
            ColumnConstraints columnConstraints = new ColumnConstraints();
            columnConstraints.setPercentWidth(60.0);
            ColumnConstraints columnConstraints2 = new ColumnConstraints();
            columnConstraints2.setPercentWidth(25.0);
            ColumnConstraints columnConstraints3 = new ColumnConstraints();
            columnConstraints3.setPercentWidth(15.0);
            this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2, columnConstraints3});
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setVgrow(Priority.NEVER);
            RowConstraints rowConstraints2 = new RowConstraints();
            rowConstraints2.setVgrow(Priority.NEVER);
            RowConstraints rowConstraints3 = new RowConstraints();
            rowConstraints3.setFillHeight(true);
            rowConstraints3.setVgrow(Priority.NEVER);
            RowConstraints rowConstraints4 = new RowConstraints();
            rowConstraints4.setPrefHeight(250.0);
            rowConstraints4.setVgrow(Priority.NEVER);
            this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints, rowConstraints2, rowConstraints3, rowConstraints4});
            this.add((Node)new Label(Localization.localize(Localization.asKey("font.dlg.font.label"))), 0, 0);
            this.add((Node)this.fontListView, 0, 1);
            this.fontListView.setCellFactory((Callback)new Callback<ListView<String>, ListCell<String>>(){

                public ListCell<String> call(ListView<String> listView) {
                    return new ListCell<String>(){

                        protected void updateItem(String string, boolean bl2) {
                            super.updateItem((Object)string, bl2);
                            if (!bl2) {
                                this.setFont(Font.font((String)string));
                                this.setText(string);
                            } else {
                                this.setText(null);
                            }
                        }
                    };
                }
            });
            ChangeListener<Object> changeListener = new ChangeListener<Object>(){

                public void changed(ObservableValue<? extends Object> observableValue, Object object, Object object2) {
                    this.refreshSample();
                }
            };
            ((MultipleSelectionModel)this.fontListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observableValue, String string, String string2) {
                    String string3 = this.listSelection(fontListView);
                    styleListView.setItems(FXCollections.observableArrayList(FontPanel.getFontStyles(string3)));
                    this.refreshSample();
                }
            });
            this.add((Node)new Label(Localization.localize(Localization.asKey("font.dlg.style.label"))), 1, 0);
            this.add((Node)this.styleListView, 1, 1);
            ((MultipleSelectionModel)this.styleListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)changeListener);
            this.add((Node)new Label(Localization.localize(Localization.asKey("font.dlg.size.label"))), 2, 0);
            this.add((Node)this.sizeListView, 2, 1);
            ((MultipleSelectionModel)this.sizeListView.selectionModelProperty().get()).selectedItemProperty().addListener((ChangeListener)changeListener);
            double d2 = 45.0;
            DoubleBinding doubleBinding = new DoubleBinding(){
                {
                    this.bind(new Observable[]{fontListView.widthProperty(), styleListView.widthProperty(), sizeListView.widthProperty()});
                }

                protected double computeValue() {
                    return fontListView.getWidth() + styleListView.getWidth() + sizeListView.getWidth() + 30.0;
                }
            };
            StackPane stackPane = new StackPane(new Node[]{this.sample});
            stackPane.setAlignment(Pos.CENTER_LEFT);
            stackPane.setMinHeight(45.0);
            stackPane.setPrefHeight(45.0);
            stackPane.setMaxHeight(45.0);
            stackPane.prefWidthProperty().bind((ObservableValue)doubleBinding);
            Rectangle rectangle = new Rectangle(0.0, 45.0);
            rectangle.widthProperty().bind((ObservableValue)doubleBinding);
            stackPane.setClip((Node)rectangle);
            this.add((Node)stackPane, 0, 3, 1, 3);
        }

        public void setFont(Font font) {
            Font font2;
            Font font3 = font2 = font == null ? Font.getDefault() : font;
            if (font2 != null) {
                this.selectInList(this.fontListView, font2.getFamily());
                this.selectInList(this.styleListView, new FontStyle(font2));
                this.selectInList(this.sizeListView, font2.getSize());
            }
        }

        public Font getFont() {
            try {
                FontStyle fontStyle = this.listSelection(this.styleListView);
                if (fontStyle == null) {
                    return Font.font((String)this.listSelection(this.fontListView), (double)this.listSelection(this.sizeListView));
                }
                return Font.font((String)this.listSelection(this.fontListView), (FontWeight)fontStyle.getWeight(), (FontPosture)fontStyle.getPosture(), (double)this.listSelection(this.sizeListView));
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private void refreshSample() {
            this.sample.setFont(this.getFont());
        }

        private <T> void selectInList(final ListView<T> listView, final T t2) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    listView.scrollTo(t2);
                    listView.getSelectionModel().select(t2);
                }
            });
        }

        private <T> T listSelection(ListView<T> listView) {
            return (T)((MultipleSelectionModel)listView.selectionModelProperty().get()).getSelectedItem();
        }
    }

    private static class FontStyle
    implements Comparable<FontStyle> {
        private FontPosture posture;
        private FontWeight weight;

        public FontStyle(FontWeight fontWeight, FontPosture fontPosture) {
            this.posture = fontPosture == null ? FontPosture.REGULAR : fontPosture;
            this.weight = fontWeight;
        }

        public FontStyle() {
            this(null, null);
        }

        public FontStyle(String string) {
            this();
            String[] stringArray;
            for (String string2 : stringArray = (string == null ? "" : string.trim().toUpperCase()).split(" ")) {
                FontWeight fontWeight = FontWeight.findByName((String)string2);
                if (fontWeight != null) {
                    this.weight = fontWeight;
                    continue;
                }
                FontPosture fontPosture = FontPosture.findByName((String)string2);
                if (fontPosture == null) continue;
                this.posture = fontPosture;
            }
        }

        public FontStyle(Font font) {
            this(font.getStyle());
        }

        public FontPosture getPosture() {
            return this.posture;
        }

        public FontWeight getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.posture == null ? 0 : this.posture.hashCode());
            n3 = 31 * n3 + (this.weight == null ? 0 : this.weight.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FontStyle fontStyle = (FontStyle)object;
            if (this.posture != fontStyle.posture) {
                return false;
            }
            return this.weight == fontStyle.weight;
        }

        private static String makePretty(Object object) {
            Object object2;
            Object object3 = object2 = object == null ? "" : object.toString();
            if (!((String)object2).isEmpty()) {
                object2 = ((String)object2).replace("_", " ");
                object2 = ((String)object2).substring(0, 1).toUpperCase() + ((String)object2).substring(1).toLowerCase();
            }
            return object2;
        }

        public String toString() {
            return String.format("%s %s", FontStyle.makePretty(this.weight), FontStyle.makePretty(this.posture)).trim();
        }

        private <T extends Enum<T>> int compareEnums(T t2, T t3) {
            if (t2 == t3) {
                return 0;
            }
            if (t2 == null) {
                return -1;
            }
            if (t3 == null) {
                return 1;
            }
            return t2.compareTo(t3);
        }

        @Override
        public int compareTo(FontStyle fontStyle) {
            int n2 = this.compareEnums(this.weight, fontStyle.weight);
            return n2 != 0 ? n2 : this.compareEnums(this.posture, fontStyle.posture);
        }
    }
}

