/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.textfield;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.skin.AutoCompletePopup;
import impl.org.controlsfx.skin.AutoCompletePopupSkin;
import java.util.Collection;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import javafx.util.StringConverter;

public abstract class AutoCompletionBinding<T>
implements EventTarget {
    private final Node completionTarget;
    private final AutoCompletePopup<T> autoCompletionPopup;
    private final Object suggestionsTaskLock = new Object();
    private FetchSuggestionsTask suggestionsTask = null;
    private Callback<ISuggestionRequest, Collection<T>> suggestionProvider = null;
    private boolean ignoreInputChanges = false;
    private long delay = 250L;
    private ObjectProperty<EventHandler<AutoCompletionEvent<T>>> onAutoCompleted;
    final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    protected AutoCompletionBinding(Node node, Callback<ISuggestionRequest, Collection<T>> callback, StringConverter<T> stringConverter) {
        this.completionTarget = node;
        this.suggestionProvider = callback;
        this.autoCompletionPopup = new AutoCompletePopup();
        this.autoCompletionPopup.setConverter(stringConverter);
        this.autoCompletionPopup.setOnSuggestion(suggestionEvent -> {
            try {
                this.setIgnoreInputChanges(true);
                this.completeUserInput(suggestionEvent.getSuggestion());
                this.fireAutoCompletion(suggestionEvent.getSuggestion());
                this.hidePopup();
            }
            finally {
                this.setIgnoreInputChanges(false);
            }
        });
    }

    public void setHideOnEscape(boolean bl2) {
        this.autoCompletionPopup.setHideOnEscape(bl2);
    }

    public final void setUserInput(String string) {
        if (!this.isIgnoreInputChanges()) {
            this.onUserInputChanged(string);
        }
    }

    public final void setDelay(long l2) {
        this.delay = l2;
    }

    public Node getCompletionTarget() {
        return this.completionTarget;
    }

    public abstract void dispose();

    public final void setVisibleRowCount(int n2) {
        this.autoCompletionPopup.setVisibleRowCount(n2);
    }

    public final int getVisibleRowCount() {
        return this.autoCompletionPopup.getVisibleRowCount();
    }

    public final IntegerProperty visibleRowCountProperty() {
        return this.autoCompletionPopup.visibleRowCountProperty();
    }

    public final void setPrefWidth(double d2) {
        this.autoCompletionPopup.setPrefWidth(d2);
    }

    public final double getPrefWidth() {
        return this.autoCompletionPopup.getPrefWidth();
    }

    public final DoubleProperty prefWidthProperty() {
        return this.autoCompletionPopup.prefWidthProperty();
    }

    public final void setMinWidth(double d2) {
        this.autoCompletionPopup.setMinWidth(d2);
    }

    public final double getMinWidth() {
        return this.autoCompletionPopup.getMinWidth();
    }

    public final DoubleProperty minWidthProperty() {
        return this.autoCompletionPopup.minWidthProperty();
    }

    public final void setMaxWidth(double d2) {
        this.autoCompletionPopup.setMaxWidth(d2);
    }

    public final double getMaxWidth() {
        return this.autoCompletionPopup.getMaxWidth();
    }

    public final DoubleProperty maxWidthProperty() {
        return this.autoCompletionPopup.maxWidthProperty();
    }

    public AutoCompletePopup<T> getAutoCompletionPopup() {
        return this.autoCompletionPopup;
    }

    protected abstract void completeUserInput(T var1);

    protected void showPopup() {
        this.autoCompletionPopup.show(this.completionTarget);
        this.selectFirstSuggestion(this.autoCompletionPopup);
    }

    protected void hidePopup() {
        this.autoCompletionPopup.hide();
    }

    protected void fireAutoCompletion(T t2) {
        Event.fireEvent((EventTarget)this, new AutoCompletionEvent<T>(t2));
    }

    private void selectFirstSuggestion(AutoCompletePopup<?> autoCompletePopup) {
        AutoCompletePopupSkin autoCompletePopupSkin;
        ListView listView;
        Skin skin = autoCompletePopup.getSkin();
        if (skin instanceof AutoCompletePopupSkin && (listView = (ListView)(autoCompletePopupSkin = (AutoCompletePopupSkin)skin).getNode()).getItems() != null && !listView.getItems().isEmpty()) {
            listView.getSelectionModel().select(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onUserInputChanged(String string) {
        Object object = this.suggestionsTaskLock;
        synchronized (object) {
            if (this.suggestionsTask != null && this.suggestionsTask.isRunning()) {
                this.suggestionsTask.cancel();
            }
            this.suggestionsTask = new FetchSuggestionsTask(string, this.delay);
            new Thread((Runnable)((Object)this.suggestionsTask)).start();
        }
    }

    private boolean isIgnoreInputChanges() {
        return this.ignoreInputChanges;
    }

    private void setIgnoreInputChanges(boolean bl2) {
        this.ignoreInputChanges = bl2;
    }

    public final void setOnAutoCompleted(EventHandler<AutoCompletionEvent<T>> eventHandler) {
        this.onAutoCompletedProperty().set(eventHandler);
    }

    public final EventHandler<AutoCompletionEvent<T>> getOnAutoCompleted() {
        return this.onAutoCompleted == null ? null : (EventHandler)this.onAutoCompleted.get();
    }

    public final ObjectProperty<EventHandler<AutoCompletionEvent<T>>> onAutoCompletedProperty() {
        if (this.onAutoCompleted == null) {
            this.onAutoCompleted = new ObjectPropertyBase<EventHandler<AutoCompletionEvent<T>>>(){

                protected void invalidated() {
                    AutoCompletionBinding.this.eventHandlerManager.setEventHandler(AutoCompletionEvent.AUTO_COMPLETED, (EventHandler)this.get());
                }

                public Object getBean() {
                    return AutoCompletionBinding.this;
                }

                public String getName() {
                    return "onAutoCompleted";
                }
            };
        }
        return this.onAutoCompleted;
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend((EventDispatcher)this.eventHandlerManager);
    }

    public static class AutoCompletionEvent<TE>
    extends Event {
        public static final EventType<AutoCompletionEvent<?>> AUTO_COMPLETED = new EventType("AUTO_COMPLETED" + UUID.randomUUID().toString());
        private final TE completion;

        public AutoCompletionEvent(TE TE) {
            super(AUTO_COMPLETED);
            this.completion = TE;
        }

        public TE getCompletion() {
            return this.completion;
        }
    }

    private class FetchSuggestionsTask
    extends Task<Void>
    implements ISuggestionRequest {
        private final String userText;
        private final long delay;

        public FetchSuggestionsTask(String string, long l2) {
            this.userText = string;
            this.delay = l2;
        }

        protected Void call() throws Exception {
            Callback callback = AutoCompletionBinding.this.suggestionProvider;
            if (callback != null) {
                long l2 = System.currentTimeMillis();
                long l3 = l2 + this.delay - System.currentTimeMillis();
                if (l3 > 0L && !this.isCancelled()) {
                    Thread.sleep(l3);
                }
                if (!this.isCancelled()) {
                    Collection collection = (Collection)callback.call((Object)this);
                    Platform.runLater(() -> {
                        boolean bl2;
                        boolean bl3 = bl2 = AutoCompletionBinding.this.completionTarget.getScene() != null && AutoCompletionBinding.this.completionTarget.getScene().getWindow() != null;
                        if (collection != null && !collection.isEmpty() && bl2) {
                            AutoCompletionBinding.this.autoCompletionPopup.getSuggestions().setAll(collection);
                            AutoCompletionBinding.this.showPopup();
                        } else {
                            AutoCompletionBinding.this.hidePopup();
                        }
                    });
                }
            } else {
                AutoCompletionBinding.this.hidePopup();
            }
            return null;
        }

        @Override
        public String getUserText() {
            return this.userText;
        }
    }

    public static interface ISuggestionRequest {
        public boolean isCancelled();

        public String getUserText();
    }
}

