/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.filter.popupfilter;

import impl.org.controlsfx.tableview2.filter.parser.string.StringParser;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.StringConverter;
import org.controlsfx.control.tableview2.FilteredTableColumn;
import org.controlsfx.control.tableview2.filter.parser.Parser;
import org.controlsfx.control.tableview2.filter.popupfilter.PopupFilter;

public class PopupStringFilter<S, T>
extends PopupFilter<S, T> {
    private final StringParser<T> stringParser;
    private final BooleanProperty caseSensitive = new SimpleBooleanProperty((Object)this, "caseSensitive", true){

        protected void invalidated() {
            PopupStringFilter.this.stringParser.setCaseSensitive(this.get());
        }
    };
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>((Object)this, "converter", PopupStringFilter.defaultStringConverter()){

        protected void invalidated() {
            PopupStringFilter.this.stringParser.setConverter((StringConverter)this.get());
        }
    };

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            public String toString(T t2) {
                return t2 == null ? null : t2.toString();
            }

            public T fromString(String string) {
                return string;
            }
        };
    }

    public PopupStringFilter(FilteredTableColumn<S, T> filteredTableColumn) {
        super(filteredTableColumn);
        this.stringParser = new StringParser<T>(this.caseSensitive.get(), this.getConverter());
        this.text.addListener((observableValue, string, string2) -> {
            if (string2 == null || string2.isEmpty()) {
                filteredTableColumn.setPredicate(null);
            } else {
                filteredTableColumn.setPredicate(this.getParser().parse((String)string2));
            }
        });
    }

    @Override
    public List<String> getOperations() {
        return this.stringParser.operators();
    }

    @Override
    public Parser<T> getParser() {
        return this.stringParser;
    }

    public final BooleanProperty caseSensitiveProperty() {
        return this.caseSensitive;
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }
}

