/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.filter.popupfilter;

import impl.org.controlsfx.tableview2.filter.popupfilter.PopupFilterSkin;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Parent;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.stage.Window;
import org.controlsfx.control.tableview2.FilteredTableColumn;
import org.controlsfx.control.tableview2.filter.parser.Parser;

public abstract class PopupFilter<S, T>
extends PopupControl {
    private final FilteredTableColumn<S, T> tableColumn;
    protected final StringProperty text = new SimpleStringProperty((Object)this, "text");
    private static final String DEFAULT_STYLE_CLASS = "pop-up-filter";

    public PopupFilter(FilteredTableColumn<S, T> filteredTableColumn) {
        this.tableColumn = filteredTableColumn;
        this.setAutoHide(true);
        this.setAutoFix(true);
        this.setHideOnEscape(true);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setText(String string) {
        this.text.set((Object)string);
    }

    public void showPopup() {
        Parent parent = this.tableColumn.getGraphic().getParent().getParent();
        if (parent.getScene() == null || parent.getScene().getWindow() == null) {
            throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
        }
        if (this.isShowing()) {
            return;
        }
        Window window = parent.getScene().getWindow();
        this.show(window, window.getX() + parent.localToScene(0.0, 0.0).getX() + parent.getScene().getX(), window.getY() + parent.localToScene(0.0, 0.0).getY() + parent.getScene().getY() + parent.getLayoutBounds().getHeight());
    }

    public abstract List<String> getOperations();

    public abstract Parser<T> getParser();

    public FilteredTableColumn<S, T> getTableColumn() {
        return this.tableColumn;
    }

    protected Skin<?> createDefaultSkin() {
        return new PopupFilterSkin(this);
    }
}

