/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.cell;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBox2TableCell<S, T>
extends ComboBoxTableCell<S, T> {
    private ComboBox<T> comboBox;
    private final EventHandler<KeyEvent> keyEventHandler = keyEvent -> {
        TableView.TableViewSelectionModel tableViewSelectionModel = this.getTableView().getSelectionModel();
        if (this.comboBox == null || keyEvent.getCode() == null || tableViewSelectionModel == null) {
            return;
        }
        switch (keyEvent.getCode()) {
            case ESCAPE: {
                this.comboBox.getEditor().setText(this.getConverter().toString(this.getItem()));
                this.cancelEdit();
                keyEvent.consume();
                break;
            }
            case TAB: {
                this.cancelEdit();
                keyEvent.consume();
                if (tableViewSelectionModel.isCellSelectionEnabled()) {
                    int n2 = this.getTableView().getVisibleLeafIndex(this.getTableColumn());
                    if (keyEvent.isShiftDown()) {
                        if (n2 > 0) {
                            tableViewSelectionModel.clearAndSelect(this.getIndex(), this.getTableView().getVisibleLeafColumn(n2 - 1));
                            break;
                        }
                        if (this.getIndex() <= 0) break;
                        tableViewSelectionModel.clearAndSelect(this.getIndex() - 1, this.getTableView().getVisibleLeafColumn(this.getTableView().getVisibleLeafColumns().size() - 1));
                        break;
                    }
                    if (n2 + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                        tableViewSelectionModel.clearAndSelect(this.getIndex(), this.getTableView().getVisibleLeafColumn(n2 + 1));
                        break;
                    }
                    if (this.getIndex() >= this.getTableView().getItems().size() - 1) break;
                    tableViewSelectionModel.clearAndSelect(this.getIndex() + 1, this.getTableView().getVisibleLeafColumn(0));
                    break;
                }
                tableViewSelectionModel.clearAndSelect(keyEvent.isShiftDown() ? this.getIndex() - 1 : this.getIndex() + 1);
                break;
            }
            case UP: {
                this.cancelEdit();
                keyEvent.consume();
                tableViewSelectionModel.clearAndSelect(this.getIndex() - 1, this.getTableColumn());
                break;
            }
            case DOWN: {
                this.cancelEdit();
                keyEvent.consume();
                tableViewSelectionModel.clearAndSelect(this.getIndex() + 1, this.getTableColumn());
                break;
            }
        }
    };
    private final ChangeListener<Boolean> focusListener = (observableValue, bl2, bl3) -> {
        if (!bl3.booleanValue() && this.comboBox != null && this.getConverter() != null) {
            String string = this.comboBox.getEditor().getText();
            Object object = this.getConverter().fromString(string);
            this.commitEdit(object);
        }
    };

    @SafeVarargs
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(T ... TArray) {
        return ComboBox2TableCell.forTableColumn(null, TArray);
    }

    @SafeVarargs
    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> stringConverter, T ... TArray) {
        return ComboBox2TableCell.forTableColumn(stringConverter, FXCollections.observableArrayList((Object[])TArray));
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(ObservableList<T> observableList) {
        return ComboBox2TableCell.forTableColumn(null, observableList);
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> stringConverter, ObservableList<T> observableList) {
        return tableColumn -> new ComboBox2TableCell(stringConverter, observableList);
    }

    public ComboBox2TableCell() {
        this(FXCollections.observableArrayList());
    }

    @SafeVarargs
    public ComboBox2TableCell(T ... TArray) {
        this(FXCollections.observableArrayList((Object[])TArray));
    }

    @SafeVarargs
    public ComboBox2TableCell(StringConverter<T> stringConverter, T ... TArray) {
        this(stringConverter, FXCollections.observableArrayList((Object[])TArray));
    }

    public ComboBox2TableCell(ObservableList<T> observableList) {
        this((StringConverter<T>)null, observableList);
    }

    public ComboBox2TableCell(StringConverter<T> stringConverter, ObservableList<T> observableList) {
        super(stringConverter, observableList);
        this.setComboBoxEditable(true);
        this.graphicProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (ComboBox2TableCell.this.getGraphic() != null && ComboBox2TableCell.this.getGraphic() instanceof ComboBox) {
                    ComboBox2TableCell.this.comboBox = (ComboBox)ComboBox2TableCell.this.getGraphic();
                    ComboBox2TableCell.this.comboBox.editableProperty().addListener((observableValue, bl2, bl3) -> ComboBox2TableCell.this.updateListeners((boolean)bl3));
                    ComboBox2TableCell.this.updateListeners(ComboBox2TableCell.this.comboBox.isEditable());
                    ComboBox2TableCell.this.graphicProperty().removeListener((InvalidationListener)this);
                }
            }
        });
    }

    public void commitEdit(T t2) {
        TableView tableView;
        if (!this.isEditing() && !t2.equals(this.getItem()) && (tableView = this.getTableView()) != null) {
            TableColumn tableColumn = this.getTableColumn();
            TableColumn.CellEditEvent cellEditEvent = new TableColumn.CellEditEvent(tableView, new TablePosition(tableView, this.getIndex(), tableColumn), TableColumn.editCommitEvent(), t2);
            Event.fireEvent((EventTarget)tableColumn, (Event)cellEditEvent);
        }
        super.commitEdit(t2);
    }

    private void updateListeners(boolean bl2) {
        if (bl2) {
            this.comboBox.getEditor().focusedProperty().addListener(this.focusListener);
            this.comboBox.addEventFilter(KeyEvent.KEY_PRESSED, this.keyEventHandler);
        } else {
            this.comboBox.getEditor().focusedProperty().removeListener(this.focusListener);
            this.comboBox.removeEventFilter(KeyEvent.KEY_PRESSED, this.keyEventHandler);
        }
    }
}

