/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.controlsfx.control.table.DupeCounter;
import org.controlsfx.control.table.FilterPanel;
import org.controlsfx.control.table.FilterValue;
import org.controlsfx.control.table.TableFilter;

public final class ColumnFilter<T, R> {
    private final TableFilter<T> tableFilter;
    private final TableColumn<T, R> tableColumn;
    private final ObservableList<FilterValue<T, R>> filterValues;
    private final DupeCounter<R> filterValuesDupeCounter;
    private final DupeCounter<R> visibleValuesDupeCounter;
    private final HashSet<R> unselectedValues;
    private final HashMap<CellIdentity<T>, ChangeListener<R>> trackedCells;
    private static final Image filterIcon = new Image(ColumnFilter.class.getResource("/impl/org/controlsfx/table/filter.png").toExternalForm());
    private boolean bumpedWidth;
    private boolean lastFilter;
    private boolean isDirty;
    private BiPredicate<String, String> searchStrategy;
    private volatile FilterPanel filterPanel;
    private ImageView imageView;
    private boolean initialized;
    private final ListChangeListener<T> backingListListener;
    private final ListChangeListener<T> itemsListener;
    private final ChangeListener<R> changeListener;
    private final ListChangeListener<FilterValue<T, R>> filterValueListChangeListener;

    /*
     * Exception decompiling
     */
    public ColumnFilter(TableFilter<T> var1_1, TableColumn<T, R> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setFilterPanel(FilterPanel filterPanel) {
        this.filterPanel = filterPanel;
    }

    FilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    void applyFilterIcon() {
        if (this.hasUnselections()) {
            this.tableColumn.setGraphic((Node)this.imageView);
            if (!this.bumpedWidth) {
                this.tableColumn.setPrefWidth(this.tableColumn.getWidth() + 20.0);
                this.bumpedWidth = true;
            }
        } else {
            this.tableColumn.setGraphic(null);
        }
    }

    public void initialize() {
        if (!this.initialized) {
            this.initializeListeners();
            this.initializeValues();
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void selectValue(Object object) {
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.filterPanel.selectValue(object);
    }

    public void unselectValue(Object object) {
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.filterPanel.unSelectValue(object);
    }

    public void selectAllValues() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.filterPanel.selectAllValues();
    }

    public void unSelectAllValues() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.filterPanel.unSelectAllValues();
    }

    boolean wasLastFiltered() {
        return this.lastFilter;
    }

    boolean hasUnselections() {
        return this.unselectedValues.size() != 0;
    }

    public void setSearchStrategy(BiPredicate<String, String> biPredicate) {
        this.searchStrategy = biPredicate;
    }

    public BiPredicate<String, String> getSearchStrategy() {
        return this.searchStrategy;
    }

    public boolean isFiltered() {
        return this.isDirty || this.unselectedValues.size() > 0;
    }

    public boolean valueIsVisible(R r2) {
        return this.visibleValuesDupeCounter.get(r2) > 0;
    }

    public void applyFilter() {
        this.tableFilter.executeFilter();
        this.lastFilter = true;
        this.tableFilter.getColumnFilters().stream().filter(columnFilter -> !columnFilter.equals(this)).forEach(columnFilter -> {
            columnFilter.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(columnFilter -> columnFilter.filterValues.stream()).forEach(FilterValue::refreshScope);
        this.isDirty = false;
    }

    public ObservableList<FilterValue<T, R>> getFilterValues() {
        return this.filterValues;
    }

    public TableColumn<T, R> getTableColumn() {
        return this.tableColumn;
    }

    public TableFilter<T> getTableFilter() {
        return this.tableFilter;
    }

    void resetAllFilters() {
        this.tableFilter.getColumnFilters().stream().flatMap(columnFilter -> columnFilter.filterValues.stream()).forEach(filterValue -> filterValue.selectedProperty().set(true));
        this.tableFilter.resetFilter();
        this.tableFilter.getColumnFilters().forEach(columnFilter -> {
            columnFilter.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(columnFilter -> columnFilter.filterValues.stream()).forEach(FilterValue::refreshScope);
        this.isDirty = false;
    }

    boolean evaluate(T t2) {
        ObservableValue observableValue = this.tableColumn.getCellObservableValue(t2);
        return this.unselectedValues.size() == 0 || !this.unselectedValues.contains(observableValue.getValue());
    }

    private void initializeValues() {
        this.imageView = new ImageView(filterIcon);
        this.imageView.setFitHeight(15.0);
        this.imageView.setPreserveRatio(true);
        this.tableFilter.getBackingList().forEach(object -> this.addBackingItem(object, this.tableColumn.getCellObservableValue(object)));
        this.tableFilter.getTableView().getItems().stream().map(arg_0 -> this.tableColumn.getCellObservableValue(arg_0)).forEach(this::addVisibleItem);
    }

    private void addBackingItem(T t2, ObservableValue<R> observableValue) {
        if (observableValue == null) {
            return;
        }
        if (this.filterValuesDupeCounter.add(observableValue.getValue()) == 1) {
            this.filterValues.add(new FilterValue(observableValue.getValue(), this));
        }
        CellIdentity<T> cellIdentity = new CellIdentity<T>(t2);
        WeakChangeListener weakChangeListener = new WeakChangeListener(this.changeListener);
        observableValue.addListener((ChangeListener)weakChangeListener);
        this.trackedCells.put(cellIdentity, (ChangeListener<R>)weakChangeListener);
    }

    private void removeBackingItem(T t2, ObservableValue<R> observableValue) {
        if (observableValue == null) {
            return;
        }
        this.removeValue(observableValue.getValue());
        ChangeListener<R> changeListener = this.trackedCells.get(new CellIdentity<T>(t2));
        if (changeListener != null) {
            observableValue.removeListener(changeListener);
        }
        this.trackedCells.remove(new CellIdentity<T>(t2));
    }

    private void removeValue(R r2) {
        boolean bl2;
        boolean bl3 = bl2 = this.filterValuesDupeCounter.remove(r2) == 0;
        if (bl2) {
            Optional<FilterValue> optional = this.getFilterValues().stream().filter(filterValue -> Objects.equals(filterValue.getValue(), r2)).findAny();
            optional.ifPresent(filterValue -> this.getFilterValues().remove(filterValue));
        }
    }

    private void addVisibleItem(ObservableValue<R> observableValue) {
        if (observableValue != null) {
            this.visibleValuesDupeCounter.add(observableValue.getValue());
        }
    }

    private void removeVisibleItem(ObservableValue<R> observableValue) {
        if (observableValue != null) {
            this.visibleValuesDupeCounter.remove(observableValue.getValue());
        }
    }

    private void initializeListeners() {
        this.tableFilter.getBackingList().addListener((ListChangeListener)new WeakListChangeListener(this.backingListListener));
        this.tableFilter.getTableView().getItems().addListener((ListChangeListener)new WeakListChangeListener(this.itemsListener));
        this.filterValues.addListener((ListChangeListener)new WeakListChangeListener(this.filterValueListChangeListener));
    }

    private void attachContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        CustomMenuItem customMenuItem = FilterPanel.getInMenuItem(this, contextMenu);
        contextMenu.getStyleClass().add((Object)"column-filter");
        contextMenu.getItems().add((Object)customMenuItem);
        this.tableColumn.setContextMenu(contextMenu);
        contextMenu.setOnShowing(windowEvent -> this.initialize());
    }

    private static final class CellIdentity<T> {
        private final T item;

        CellIdentity(T t2) {
            this.item = t2;
        }

        public boolean equals(Object object) {
            return this.item == ((CellIdentity)object).item;
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }
    }
}

