/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellBase;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetView;
import org.controlsfx.control.spreadsheet.StringConverterWithFormat;

public abstract class SpreadsheetCellType<T> {
    protected StringConverter<T> converter;
    public static final SpreadsheetCellType<Object> OBJECT = new ObjectType();
    public static final StringType STRING = new StringType();
    public static final DoubleType DOUBLE = new DoubleType();
    public static final IntegerType INTEGER = new IntegerType();
    public static final DateType DATE = new DateType();

    public SpreadsheetCellType() {
    }

    public SpreadsheetCellType(StringConverter<T> stringConverter) {
        this.converter = stringConverter;
    }

    public abstract SpreadsheetCellEditor createEditor(SpreadsheetView var1);

    public String toString(T t2, String string) {
        return this.toString(t2);
    }

    public abstract String toString(T var1);

    public boolean match(Object object) {
        return this.match(object, Collections.emptyList());
    }

    public abstract boolean match(Object var1, Object ... var2);

    public boolean isError(Object object) {
        return false;
    }

    public boolean acceptDrop() {
        return false;
    }

    public abstract T convertValue(Object var1);

    public static final ListType LIST(List<String> list) {
        return new ListType(list);
    }

    public static class DateType
    extends SpreadsheetCellType<LocalDate> {
        public DateType() {
            this((StringConverter<LocalDate>)new StringConverterWithFormat<LocalDate>(){

                public String toString(LocalDate localDate) {
                    return this.toStringFormat(localDate, "");
                }

                public LocalDate fromString(String string) {
                    try {
                        return LocalDate.parse(string);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                @Override
                public String toStringFormat(LocalDate localDate, String string) {
                    if ("".equals(string) && localDate != null) {
                        return localDate.toString();
                    }
                    if (localDate != null) {
                        return localDate.format(DateTimeFormatter.ofPattern(string));
                    }
                    return "";
                }
            });
        }

        public DateType(StringConverter<LocalDate> stringConverter) {
            super(stringConverter);
        }

        public String toString() {
            return "date";
        }

        public SpreadsheetCell createCell(int n2, int n3, int n4, int n5, LocalDate localDate) {
            SpreadsheetCellBase spreadsheetCellBase = new SpreadsheetCellBase(n2, n3, n4, n5, this);
            spreadsheetCellBase.setItem(localDate);
            return spreadsheetCellBase;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView spreadsheetView) {
            return new SpreadsheetCellEditor.DateEditor(spreadsheetView, (StringConverter<LocalDate>)this.converter);
        }

        @Override
        public boolean match(Object object, Object ... objectArray) {
            if (object instanceof LocalDate) {
                return true;
            }
            try {
                LocalDate localDate = (LocalDate)this.converter.fromString(object == null ? null : object.toString());
                return localDate != null;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public LocalDate convertValue(Object object) {
            if (object instanceof LocalDate) {
                return (LocalDate)object;
            }
            try {
                return (LocalDate)this.converter.fromString(object == null ? null : object.toString());
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public String toString(LocalDate localDate) {
            return this.converter.toString((Object)localDate);
        }

        @Override
        public String toString(LocalDate localDate, String string) {
            return ((StringConverterWithFormat)this.converter).toStringFormat(localDate, string);
        }
    }

    public static class ListType
    extends SpreadsheetCellType<String> {
        protected final List<String> items;

        public ListType(final List<String> list) {
            super(new DefaultStringConverter(){

                public String fromString(String string) {
                    if (string != null && list.contains(string)) {
                        return string;
                    }
                    return null;
                }
            });
            this.items = list;
        }

        public String toString() {
            return "list";
        }

        public SpreadsheetCell createCell(int n2, int n3, int n4, int n5, String string) {
            SpreadsheetCellBase spreadsheetCellBase = new SpreadsheetCellBase(n2, n3, n4, n5, this);
            if (this.items != null && this.items.size() > 0) {
                if (string != null && this.items.contains(string)) {
                    spreadsheetCellBase.setItem(string);
                } else {
                    spreadsheetCellBase.setItem(this.items.get(0));
                }
            }
            return spreadsheetCellBase;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView spreadsheetView) {
            return new SpreadsheetCellEditor.ListEditor(spreadsheetView, this.items);
        }

        @Override
        public boolean match(Object object, Object ... objectArray) {
            if (object instanceof String && this.items.contains(object.toString())) {
                return true;
            }
            return this.items.contains(object == null ? null : object.toString());
        }

        @Override
        public String convertValue(Object object) {
            return (String)this.converter.fromString(object == null ? null : object.toString());
        }

        @Override
        public String toString(String string) {
            return this.converter.toString((Object)string);
        }
    }

    public static class IntegerType
    extends SpreadsheetCellType<Integer> {
        public IntegerType() {
            this(new IntegerStringConverter(){

                public String toString(Integer n2) {
                    if (n2 == null || Double.isNaN(n2.intValue())) {
                        return "";
                    }
                    return super.toString(n2);
                }

                public Integer fromString(String string) {
                    if (string == null || string.isEmpty() || "NaN".equals(string)) {
                        return null;
                    }
                    try {
                        Double d2 = Double.parseDouble(string);
                        return d2.intValue();
                    }
                    catch (Exception exception) {
                        return super.fromString(string);
                    }
                }
            });
        }

        public IntegerType(IntegerStringConverter integerStringConverter) {
            super(integerStringConverter);
        }

        public String toString() {
            return "Integer";
        }

        public SpreadsheetCell createCell(int n2, int n3, int n4, int n5, Integer n6) {
            SpreadsheetCellBase spreadsheetCellBase = new SpreadsheetCellBase(n2, n3, n4, n5, this);
            spreadsheetCellBase.setItem(n6);
            return spreadsheetCellBase;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView spreadsheetView) {
            return new SpreadsheetCellEditor.IntegerEditor(spreadsheetView);
        }

        @Override
        public boolean match(Object object, Object ... objectArray) {
            if (object instanceof Integer) {
                return true;
            }
            try {
                this.converter.fromString(object == null ? null : object.toString());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public Integer convertValue(Object object) {
            if (object instanceof Integer) {
                return (Integer)object;
            }
            try {
                return (Integer)this.converter.fromString(object == null ? null : object.toString());
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public String toString(Integer n2) {
            return this.converter.toString((Object)n2);
        }
    }

    public static class DoubleType
    extends SpreadsheetCellType<Double> {
        public DoubleType() {
            this((StringConverter<Double>)new StringConverterWithFormat<Double>((StringConverter)new DoubleStringConverter()){

                public String toString(Double d2) {
                    return this.toStringFormat(d2, "");
                }

                public Double fromString(String string) {
                    if (string == null || string.isEmpty() || "NaN".equals(string)) {
                        return Double.NaN;
                    }
                    return (Double)this.myConverter.fromString(string);
                }

                @Override
                public String toStringFormat(Double d2, String string) {
                    try {
                        if (d2 == null || Double.isNaN(d2)) {
                            return "";
                        }
                        return new DecimalFormat(string).format(d2);
                    }
                    catch (Exception exception) {
                        return this.myConverter.toString((Object)d2);
                    }
                }
            });
        }

        public DoubleType(StringConverter<Double> stringConverter) {
            super(stringConverter);
        }

        public String toString() {
            return "double";
        }

        public SpreadsheetCell createCell(int n2, int n3, int n4, int n5, Double d2) {
            SpreadsheetCellBase spreadsheetCellBase = new SpreadsheetCellBase(n2, n3, n4, n5, this);
            spreadsheetCellBase.setItem(d2);
            return spreadsheetCellBase;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView spreadsheetView) {
            return new SpreadsheetCellEditor.DoubleEditor(spreadsheetView);
        }

        @Override
        public boolean match(Object object, Object ... objectArray) {
            if (object instanceof Double) {
                return true;
            }
            try {
                this.converter.fromString(object == null ? null : object.toString());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public Double convertValue(Object object) {
            if (object instanceof Double) {
                return (Double)object;
            }
            try {
                return (Double)this.converter.fromString(object == null ? null : object.toString());
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public String toString(Double d2) {
            return this.converter.toString((Object)d2);
        }

        @Override
        public String toString(Double d2, String string) {
            return ((StringConverterWithFormat)this.converter).toStringFormat(d2, string);
        }
    }

    public static class StringType
    extends SpreadsheetCellType<String> {
        public StringType() {
            this((StringConverter<String>)new DefaultStringConverter());
        }

        public StringType(StringConverter<String> stringConverter) {
            super(stringConverter);
        }

        public String toString() {
            return "string";
        }

        @Override
        public boolean match(Object object, Object ... objectArray) {
            return true;
        }

        public SpreadsheetCell createCell(int n2, int n3, int n4, int n5, String string) {
            SpreadsheetCellBase spreadsheetCellBase = new SpreadsheetCellBase(n2, n3, n4, n5, this);
            spreadsheetCellBase.setItem(string);
            return spreadsheetCellBase;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView spreadsheetView) {
            return new SpreadsheetCellEditor.StringEditor(spreadsheetView);
        }

        @Override
        public String convertValue(Object object) {
            String string = (String)this.converter.fromString(object == null ? null : object.toString());
            if (string == null || string.equals("")) {
                return null;
            }
            return string;
        }

        @Override
        public String toString(String string) {
            return this.converter.toString((Object)string);
        }
    }

    public static class ObjectType
    extends SpreadsheetCellType<Object> {
        public ObjectType() {
            this(new StringConverterWithFormat<Object>(){

                public Object fromString(String string) {
                    return string;
                }

                public String toString(Object object) {
                    return object == null ? "" : object.toString();
                }
            });
        }

        public ObjectType(StringConverterWithFormat<Object> stringConverterWithFormat) {
            super(stringConverterWithFormat);
        }

        public String toString() {
            return "object";
        }

        @Override
        public boolean match(Object object, Object ... objectArray) {
            return true;
        }

        public SpreadsheetCell createCell(int n2, int n3, int n4, int n5, Object object) {
            SpreadsheetCellBase spreadsheetCellBase = new SpreadsheetCellBase(n2, n3, n4, n5, this);
            spreadsheetCellBase.setItem(object);
            return spreadsheetCellBase;
        }

        @Override
        public SpreadsheetCellEditor createEditor(SpreadsheetView spreadsheetView) {
            return new SpreadsheetCellEditor.ObjectEditor(spreadsheetView);
        }

        @Override
        public Object convertValue(Object object) {
            return object;
        }

        @Override
        public String toString(Object object) {
            return this.converter.toString(object);
        }
    }
}

