/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;

public class ClipboardCell
implements Serializable {
    private final int row;
    private final int column;
    private Object value;
    private final String htmlVersion;

    public ClipboardCell(int n2, int n3, SpreadsheetCell spreadsheetCell) {
        this.row = n2;
        this.column = n3;
        Object object = spreadsheetCell.getItem();
        if (spreadsheetCell.isCellGraphic()) {
            this.htmlVersion = object == null ? null : object.toString();
            this.value = spreadsheetCell.getCellType().toString(spreadsheetCell.getItem());
        } else {
            try {
                new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(object);
                this.value = object;
            }
            catch (IOException iOException) {
                this.value = object == null ? null : object.toString();
            }
            this.htmlVersion = null;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public String getHtmlVersion() {
        return this.htmlVersion;
    }
}

