/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import impl.org.controlsfx.ImplUtils;
import java.util.List;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.controlsfx.control.decoration.Decoration;

public class GraphicDecoration
extends Decoration {
    private final Node decorationNode;
    private final Pos pos;
    private final double xOffset;
    private final double yOffset;
    private final ChangeListener<Boolean> targetNeedsLayoutListener;

    public GraphicDecoration(Node node) {
        this(node, Pos.TOP_LEFT);
    }

    public GraphicDecoration(Node node, Pos pos) {
        this(node, pos, 0.0, 0.0);
    }

    public GraphicDecoration(Node node, Pos pos, double d2, double d3) {
        this.decorationNode = node;
        this.decorationNode.setManaged(false);
        this.pos = pos;
        this.xOffset = d2;
        this.yOffset = d3;
        this.targetNeedsLayoutListener = (observableValue, bl2, bl3) -> Optional.ofNullable(node.getParent()).ifPresent(this::layoutGraphic);
    }

    @Override
    public Node applyDecoration(Node node) {
        List<Node> list = ImplUtils.getChildren((Parent)node, true);
        this.layoutGraphic(node);
        if (!list.contains(this.decorationNode)) {
            list.add(this.decorationNode);
        }
        ((Parent)node).needsLayoutProperty().removeListener(this.targetNeedsLayoutListener);
        ((Parent)node).needsLayoutProperty().addListener(this.targetNeedsLayoutListener);
        return null;
    }

    @Override
    public void removeDecoration(Node node) {
        List<Node> list = ImplUtils.getChildren((Parent)node, true);
        if (list.contains(this.decorationNode)) {
            list.remove(this.decorationNode);
        }
        ((Parent)node).needsLayoutProperty().removeListener(this.targetNeedsLayoutListener);
    }

    private void layoutGraphic(Node node) {
        double d2;
        this.decorationNode.autosize();
        Bounds bounds = this.decorationNode.getLayoutBounds();
        double d3 = bounds.getWidth();
        double d4 = bounds.getHeight();
        Bounds bounds2 = node.getLayoutBounds();
        double d5 = bounds2.getMinX();
        double d6 = bounds2.getMinY();
        double d7 = bounds2.getWidth();
        if (d7 <= 0.0) {
            d7 = node.prefWidth(-1.0);
        }
        if ((d2 = bounds2.getHeight()) <= 0.0) {
            d2 = node.prefHeight(-1.0);
        }
        switch (this.pos.getHpos()) {
            case CENTER: {
                d5 += d7 / 2.0 - d3 / 2.0;
                break;
            }
            case LEFT: {
                d5 -= d3 / 2.0;
                break;
            }
            case RIGHT: {
                d5 += d7 - d3 / 2.0;
            }
        }
        switch (this.pos.getVpos()) {
            case CENTER: {
                d6 += d2 / 2.0 - d4 / 2.0;
                break;
            }
            case TOP: {
                d6 -= d4 / 2.0;
                break;
            }
            case BOTTOM: {
                d6 += d2 - d4 / 2.0;
                break;
            }
            case BASELINE: {
                d6 += node.getBaselineOffset() - this.decorationNode.getBaselineOffset() - d4 / 2.0;
            }
        }
        this.decorationNode.setLayoutX(d5 + this.xOffset);
        this.decorationNode.setLayoutY(d6 + this.yOffset);
    }
}

