/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.skin.DecorationPane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.controlsfx.control.decoration.Decoration;

public class Decorator {
    private static final String DECORATIONS_PROPERTY_KEY = "$org.controlsfx.decorations$";
    private static List<Scene> currentlyInstallingScenes = new ArrayList<Scene>();
    private static Map<Scene, List<Consumer<DecorationPane>>> pendingTasksByScene = new HashMap<Scene, List<Consumer<DecorationPane>>>();

    private Decorator() {
    }

    public static final void addDecoration(Node node, Decoration decoration) {
        Decorator.getDecorations(node, true).add((Object)decoration);
        Decorator.updateDecorationsOnNode(node, (List<Decoration>)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}), null);
    }

    public static final void removeDecoration(Node node, Decoration decoration) {
        Decorator.getDecorations(node, true).remove((Object)decoration);
        Decorator.updateDecorationsOnNode(node, null, (List<Decoration>)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}));
    }

    public static final void removeAllDecorations(Node node) {
        ObservableList<Decoration> observableList = Decorator.getDecorations(node, true);
        ObservableList observableList2 = FXCollections.observableArrayList(observableList);
        node.getProperties().remove((Object)DECORATIONS_PROPERTY_KEY);
        Decorator.updateDecorationsOnNode(node, null, (List<Decoration>)observableList2);
    }

    public static final ObservableList<Decoration> getDecorations(Node node) {
        return Decorator.getDecorations(node, false);
    }

    private static final ObservableList<Decoration> getDecorations(Node node, boolean bl2) {
        ObservableList observableList = (ObservableList)node.getProperties().get((Object)DECORATIONS_PROPERTY_KEY);
        if (observableList == null && bl2) {
            observableList = FXCollections.observableArrayList();
            node.getProperties().put((Object)DECORATIONS_PROPERTY_KEY, (Object)observableList);
        }
        return observableList;
    }

    private static void updateDecorationsOnNode(Node node, List<Decoration> list, List<Decoration> list2) {
        Decorator.getDecorationPane(node, decorationPane -> decorationPane.updateDecorationsOnNode(node, list, list2));
    }

    private static void getDecorationPane(final Node node, Consumer<DecorationPane> consumer) {
        DecorationPane decorationPane = Decorator.getDecorationPaneInParentHierarchy(node);
        if (decorationPane != null) {
            consumer.accept(decorationPane);
        } else {
            final Consumer<Scene> consumer2 = scene -> {
                Parent parent;
                if (currentlyInstallingScenes.contains(scene)) {
                    List<Consumer<DecorationPane>> list = pendingTasksByScene.get(scene);
                    if (list == null) {
                        list = new LinkedList<Consumer<DecorationPane>>();
                        pendingTasksByScene.put((Scene)scene, list);
                    }
                    list.add(consumer);
                    return;
                }
                DecorationPane decorationPane = Decorator.getDecorationPaneInParentHierarchy(node);
                if (decorationPane == null) {
                    currentlyInstallingScenes.add((Scene)scene);
                    decorationPane = new DecorationPane();
                    parent = scene.getRoot();
                    decorationPane.getStylesheets().addAll((Collection)parent.getStylesheets());
                    ImplUtils.injectAsRootPane(scene, (Parent)decorationPane, true);
                    decorationPane.setRoot((Node)parent);
                    currentlyInstallingScenes.remove(scene);
                }
                consumer.accept(decorationPane);
                parent = pendingTasksByScene.remove(scene);
                if (parent != null) {
                    for (Consumer consumer2 : parent) {
                        consumer2.accept(decorationPane);
                    }
                }
            };
            Scene scene2 = node.getScene();
            if (scene2 != null) {
                consumer2.accept(scene2);
            } else {
                InvalidationListener invalidationListener = new InvalidationListener(){

                    public void invalidated(Observable observable) {
                        if (node.getScene() != null) {
                            node.sceneProperty().removeListener((InvalidationListener)this);
                            consumer2.accept(node.getScene());
                        }
                    }
                };
                node.sceneProperty().addListener(invalidationListener);
            }
        }
    }

    private static DecorationPane getDecorationPaneInParentHierarchy(Node node) {
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DecorationPane)) continue;
            return (DecorationPane)parent;
        }
        return null;
    }
}

