/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.skin.PopOverSkin;
import java.util.Objects;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class PopOver
extends PopupControl {
    private static final String DEFAULT_STYLE_CLASS = "popover";
    private static final Duration DEFAULT_FADE_DURATION = Duration.seconds((double)0.2);
    private double targetX;
    private double targetY;
    private final SimpleBooleanProperty animated = new SimpleBooleanProperty(true);
    private final ObjectProperty<Duration> fadeInDuration = new SimpleObjectProperty((Object)DEFAULT_FADE_DURATION);
    private final ObjectProperty<Duration> fadeOutDuration = new SimpleObjectProperty((Object)DEFAULT_FADE_DURATION);
    private final StackPane root = new StackPane();
    private final ObjectProperty<Node> contentNode = new SimpleObjectProperty<Node>((Object)this, "contentNode"){

        public void setValue(Node node) {
            if (node == null) {
                throw new IllegalArgumentException("content node can not be null");
            }
        }
    };
    private InvalidationListener hideListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            if (!PopOver.this.isDetached()) {
                PopOver.this.hide(Duration.ZERO);
            }
        }
    };
    private WeakInvalidationListener weakHideListener = new WeakInvalidationListener(this.hideListener);
    private ChangeListener<Number> xListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (!PopOver.this.isDetached()) {
                PopOver.this.setAnchorX(PopOver.this.getAnchorX() + (number2.doubleValue() - number.doubleValue()));
            }
        }
    };
    private WeakChangeListener<Number> weakXListener = new WeakChangeListener(this.xListener);
    private ChangeListener<Number> yListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
            if (!PopOver.this.isDetached()) {
                PopOver.this.setAnchorY(PopOver.this.getAnchorY() + (number2.doubleValue() - number.doubleValue()));
            }
        }
    };
    private WeakChangeListener<Number> weakYListener = new WeakChangeListener(this.yListener);
    private Window ownerWindow;
    private final EventHandler<WindowEvent> closePopOverOnOwnerWindowCloseLambda = windowEvent -> this.ownerWindowHiding();
    private final WeakEventHandler<WindowEvent> closePopOverOnOwnerWindowClose = new WeakEventHandler(this.closePopOverOnOwnerWindowCloseLambda);
    private final BooleanProperty headerAlwaysVisible = new SimpleBooleanProperty((Object)this, "headerAlwaysVisible");
    private final BooleanProperty closeButtonEnabled = new SimpleBooleanProperty((Object)this, "closeButtonEnabled", true);
    private final BooleanProperty detachable = new SimpleBooleanProperty((Object)this, "detachable", true);
    private final BooleanProperty detached = new SimpleBooleanProperty((Object)this, "detached", false);
    private final DoubleProperty arrowSize = new SimpleDoubleProperty((Object)this, "arrowSize", 12.0);
    private final DoubleProperty arrowIndent = new SimpleDoubleProperty((Object)this, "arrowIndent", 12.0);
    private final DoubleProperty cornerRadius = new SimpleDoubleProperty((Object)this, "cornerRadius", 6.0);
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", Localization.localize(Localization.asKey("popOver.default.title")));
    private final ObjectProperty<ArrowLocation> arrowLocation = new SimpleObjectProperty((Object)this, "arrowLocation", (Object)ArrowLocation.LEFT_TOP);

    public PopOver() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.getRoot().getStylesheets().add((Object)PopOver.class.getResource("popover.css").toExternalForm());
        this.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
        this.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                PopOver.this.setDetached(false);
            }
        });
        Label label = new Label(Localization.localize(Localization.asKey("popOver.default.content")));
        label.setPrefSize(200.0, 200.0);
        label.setPadding(new Insets(4.0));
        this.setContentNode((Node)label);
        InvalidationListener invalidationListener = observable -> {
            if (this.isShowing() && !this.isDetached()) {
                this.show(this.getOwnerNode(), this.targetX, this.targetY);
                this.adjustWindowLocation();
            }
        };
        this.arrowSize.addListener(invalidationListener);
        this.cornerRadius.addListener(invalidationListener);
        this.arrowLocation.addListener(invalidationListener);
        this.arrowIndent.addListener(invalidationListener);
        this.headerAlwaysVisible.addListener(invalidationListener);
        this.detached.addListener(observable -> {
            if (this.isDetached()) {
                this.setAutoHide(false);
            } else {
                this.setAutoHide(true);
            }
        });
        this.setAutoHide(true);
    }

    public PopOver(Node node) {
        this();
        this.setContentNode(node);
    }

    protected Skin<?> createDefaultSkin() {
        return new PopOverSkin(this);
    }

    public final StackPane getRoot() {
        return this.root;
    }

    public final ObjectProperty<Node> contentNodeProperty() {
        return this.contentNode;
    }

    public final Node getContentNode() {
        return (Node)this.contentNodeProperty().get();
    }

    public final void setContentNode(Node node) {
        this.contentNodeProperty().set((Object)node);
    }

    public final void show(Node node) {
        this.show(node, 4.0);
    }

    public final void show(Node node, double d2) {
        Objects.requireNonNull(node);
        Bounds bounds = node.localToScreen(node.getBoundsInLocal());
        switch (this.getArrowLocation()) {
            case BOTTOM_CENTER: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                this.show(node, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + d2);
                break;
            }
            case LEFT_BOTTOM: 
            case LEFT_CENTER: 
            case LEFT_TOP: {
                this.show(node, bounds.getMaxX() - d2, bounds.getMinY() + bounds.getHeight() / 2.0);
                break;
            }
            case RIGHT_BOTTOM: 
            case RIGHT_CENTER: 
            case RIGHT_TOP: {
                this.show(node, bounds.getMinX() + d2, bounds.getMinY() + bounds.getHeight() / 2.0);
                break;
            }
            case TOP_CENTER: 
            case TOP_LEFT: 
            case TOP_RIGHT: {
                this.show(node, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() - d2);
                break;
            }
        }
    }

    public final void show(Window window) {
        super.show(window);
        this.ownerWindow = window;
        if (this.isAnimated()) {
            this.showFadeInAnimation(this.getFadeInDuration());
        }
        this.ownerWindow.addEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
    }

    public final void show(Window window, double d2, double d3) {
        super.show(window, d2, d3);
        this.ownerWindow = window;
        if (this.isAnimated()) {
            this.showFadeInAnimation(this.getFadeInDuration());
        }
        window.addEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
    }

    public final void show(Node node, double d2, double d3) {
        this.show(node, d2, d3, this.getFadeInDuration());
    }

    public final void show(Node node, double d2, double d3, Duration duration) {
        if (this.ownerWindow != null && this.isShowing()) {
            super.hide();
        }
        this.targetX = d2;
        this.targetY = d3;
        if (node == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        if (duration == null) {
            duration = DEFAULT_FADE_DURATION;
        }
        if (this.ownerWindow != null) {
            this.ownerWindow.xProperty().removeListener(this.weakXListener);
            this.ownerWindow.yProperty().removeListener(this.weakYListener);
            this.ownerWindow.widthProperty().removeListener((InvalidationListener)this.weakHideListener);
            this.ownerWindow.heightProperty().removeListener((InvalidationListener)this.weakHideListener);
        }
        this.ownerWindow = node.getScene().getWindow();
        this.ownerWindow.xProperty().addListener(this.weakXListener);
        this.ownerWindow.yProperty().addListener(this.weakYListener);
        this.ownerWindow.widthProperty().addListener((InvalidationListener)this.weakHideListener);
        this.ownerWindow.heightProperty().addListener((InvalidationListener)this.weakHideListener);
        this.setOnShown(windowEvent -> {
            this.getScene().addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                if (mouseEvent.getTarget().equals(this.getScene().getRoot()) && !this.isDetached()) {
                    this.hide();
                }
            });
            this.adjustWindowLocation();
        });
        super.show(node, d2, d3);
        if (this.isAnimated()) {
            this.showFadeInAnimation(duration);
        }
        this.ownerWindow.addEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
    }

    private void showFadeInAnimation(Duration duration) {
        Node node = this.getSkin().getNode();
        node.setOpacity(0.0);
        FadeTransition fadeTransition = new FadeTransition(duration, node);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
    }

    private void ownerWindowHiding() {
        this.hide(Duration.ZERO);
        if (this.ownerWindow != null) {
            this.ownerWindow.removeEventFilter(WindowEvent.WINDOW_HIDING, this.closePopOverOnOwnerWindowClose);
        }
    }

    public final void hide() {
        this.hide(this.getFadeOutDuration());
    }

    public final void hide(Duration duration) {
        if (duration == null) {
            duration = DEFAULT_FADE_DURATION;
        }
        if (this.isShowing()) {
            if (this.isAnimated()) {
                Node node = this.getSkin().getNode();
                FadeTransition fadeTransition = new FadeTransition(duration, node);
                fadeTransition.setFromValue(node.getOpacity());
                fadeTransition.setToValue(0.0);
                fadeTransition.setOnFinished(actionEvent -> super.hide());
                fadeTransition.play();
            } else {
                super.hide();
            }
        }
    }

    private void adjustWindowLocation() {
        Bounds bounds = this.getSkin().getNode().getBoundsInParent();
        switch (this.getArrowLocation()) {
            case TOP_CENTER: 
            case TOP_LEFT: 
            case TOP_RIGHT: {
                this.setAnchorX(this.getAnchorX() + bounds.getMinX() - this.computeXOffset());
                this.setAnchorY(this.getAnchorY() + bounds.getMinY() + this.getArrowSize());
                break;
            }
            case LEFT_BOTTOM: 
            case LEFT_CENTER: 
            case LEFT_TOP: {
                this.setAnchorX(this.getAnchorX() + bounds.getMinX() + this.getArrowSize());
                this.setAnchorY(this.getAnchorY() + bounds.getMinY() - this.computeYOffset());
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                this.setAnchorX(this.getAnchorX() + bounds.getMinX() - this.computeXOffset());
                this.setAnchorY(this.getAnchorY() - bounds.getMinY() - bounds.getMaxY() - 1.0);
                break;
            }
            case RIGHT_BOTTOM: 
            case RIGHT_CENTER: 
            case RIGHT_TOP: {
                this.setAnchorX(this.getAnchorX() - bounds.getMinX() - bounds.getMaxX() - 1.0);
                this.setAnchorY(this.getAnchorY() + bounds.getMinY() - this.computeYOffset());
            }
        }
    }

    private double computeXOffset() {
        switch (this.getArrowLocation()) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                return this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize();
            }
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return this.getContentNode().prefWidth(-1.0) / 2.0;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return this.getContentNode().prefWidth(-1.0) - this.getArrowIndent() - this.getCornerRadius() - this.getArrowSize();
            }
        }
        return 0.0;
    }

    private double computeYOffset() {
        double d2 = this.getContentNode().prefHeight(-1.0);
        switch (this.getArrowLocation()) {
            case LEFT_TOP: 
            case RIGHT_TOP: {
                return this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize();
            }
            case LEFT_CENTER: 
            case RIGHT_CENTER: {
                return Math.max(d2, 2.0 * (this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize())) / 2.0;
            }
            case LEFT_BOTTOM: 
            case RIGHT_BOTTOM: {
                return Math.max(d2 - this.getCornerRadius() - this.getArrowIndent() - this.getArrowSize(), this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize());
            }
        }
        return 0.0;
    }

    public final void detach() {
        if (this.isDetachable()) {
            this.setDetached(true);
        }
    }

    public final BooleanProperty headerAlwaysVisibleProperty() {
        return this.headerAlwaysVisible;
    }

    public final void setHeaderAlwaysVisible(boolean bl2) {
        this.headerAlwaysVisible.setValue(Boolean.valueOf(bl2));
    }

    public final boolean isHeaderAlwaysVisible() {
        return this.headerAlwaysVisible.getValue();
    }

    public final BooleanProperty closeButtonEnabledProperty() {
        return this.closeButtonEnabled;
    }

    public final void setCloseButtonEnabled(boolean bl2) {
        this.closeButtonEnabled.setValue(Boolean.valueOf(bl2));
    }

    public final boolean isCloseButtonEnabled() {
        return this.closeButtonEnabled.getValue();
    }

    public final BooleanProperty detachableProperty() {
        return this.detachable;
    }

    public final void setDetachable(boolean bl2) {
        this.detachableProperty().set(bl2);
    }

    public final boolean isDetachable() {
        return this.detachableProperty().get();
    }

    public final BooleanProperty detachedProperty() {
        return this.detached;
    }

    public final void setDetached(boolean bl2) {
        this.detachedProperty().set(bl2);
    }

    public final boolean isDetached() {
        return this.detachedProperty().get();
    }

    public final DoubleProperty arrowSizeProperty() {
        return this.arrowSize;
    }

    public final double getArrowSize() {
        return this.arrowSizeProperty().get();
    }

    public final void setArrowSize(double d2) {
        this.arrowSizeProperty().set(d2);
    }

    public final DoubleProperty arrowIndentProperty() {
        return this.arrowIndent;
    }

    public final double getArrowIndent() {
        return this.arrowIndentProperty().get();
    }

    public final void setArrowIndent(double d2) {
        this.arrowIndentProperty().set(d2);
    }

    public final DoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public final double getCornerRadius() {
        return this.cornerRadiusProperty().get();
    }

    public final void setCornerRadius(double d2) {
        this.cornerRadiusProperty().set(d2);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final String getTitle() {
        return (String)this.titleProperty().get();
    }

    public final void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("title can not be null");
        }
        this.titleProperty().set((Object)string);
    }

    public final ObjectProperty<ArrowLocation> arrowLocationProperty() {
        return this.arrowLocation;
    }

    public final void setArrowLocation(ArrowLocation arrowLocation) {
        this.arrowLocationProperty().set((Object)arrowLocation);
    }

    public final ArrowLocation getArrowLocation() {
        return (ArrowLocation)((Object)this.arrowLocationProperty().get());
    }

    public final ObjectProperty<Duration> fadeInDurationProperty() {
        return this.fadeInDuration;
    }

    public final ObjectProperty<Duration> fadeOutDurationProperty() {
        return this.fadeOutDuration;
    }

    public final Duration getFadeInDuration() {
        return (Duration)this.fadeInDurationProperty().get();
    }

    public final void setFadeInDuration(Duration duration) {
        this.fadeInDurationProperty().setValue((Object)duration);
    }

    public final Duration getFadeOutDuration() {
        return (Duration)this.fadeOutDurationProperty().get();
    }

    public final void setFadeOutDuration(Duration duration) {
        this.fadeOutDurationProperty().setValue((Object)duration);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final void setAnimated(boolean bl2) {
        this.animatedProperty().set(bl2);
    }

    public static enum ArrowLocation {
        LEFT_TOP,
        LEFT_CENTER,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_CENTER,
        RIGHT_BOTTOM,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

