/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.CheckComboBoxSkin;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.util.StringConverter;
import org.controlsfx.control.CheckBitSetModelBase;
import org.controlsfx.control.ControlsFXControl;
import org.controlsfx.control.IndexedCheckModel;

@DefaultProperty(value="items")
public class CheckComboBox<T>
extends ControlsFXControl {
    public static final String COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY = "comboBoxRowsToMeasureWidth";
    private final ObservableList<T> items;
    private final Map<T, BooleanProperty> itemBooleanMap;
    private CheckComboBoxSkin<T> checkComboBoxSkin;
    private ObjectProperty<IndexedCheckModel<T>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");
    private StringProperty title = new SimpleStringProperty(null);
    private BooleanProperty showCheckedCount = new SimpleBooleanProperty(false);

    public CheckComboBox() {
        this(null);
    }

    public CheckComboBox(ObservableList<T> observableList) {
        int n2 = observableList == null ? 32 : observableList.size();
        this.itemBooleanMap = new HashMap<T, BooleanProperty>(n2);
        this.items = observableList == null ? FXCollections.observableArrayList() : observableList;
        this.setCheckModel(new CheckComboBoxBitSetCheckModel<T>(this.items, this.itemBooleanMap));
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public BooleanProperty getItemBooleanProperty(int n2) {
        if (n2 < 0 || n2 >= this.items.size()) {
            return null;
        }
        return this.getItemBooleanProperty(this.getItems().get(n2));
    }

    public BooleanProperty getItemBooleanProperty(T t2) {
        return this.itemBooleanMap.get(t2);
    }

    public final void setCheckModel(IndexedCheckModel<T> indexedCheckModel) {
        this.checkModelProperty().set(indexedCheckModel);
    }

    public final IndexedCheckModel<T> getCheckModel() {
        return this.checkModel == null ? null : (IndexedCheckModel)this.checkModel.get();
    }

    public final ObjectProperty<IndexedCheckModel<T>> checkModelProperty() {
        return this.checkModel;
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final void setTitle(String string) {
        this.title.setValue(string);
    }

    public final String getTitle() {
        return this.title.getValue();
    }

    public void show() {
        if (this.checkComboBoxSkin != null) {
            this.checkComboBoxSkin.show();
        }
    }

    public void hide() {
        if (this.checkComboBoxSkin != null) {
            this.checkComboBoxSkin.hide();
        }
    }

    protected Skin<?> createDefaultSkin() {
        this.checkComboBoxSkin = new CheckComboBoxSkin(this);
        return this.checkComboBoxSkin;
    }

    public final BooleanProperty showCheckedCountProperty() {
        return this.showCheckedCount;
    }

    public final void setShowCheckedCount(boolean bl2) {
        this.showCheckedCount.setValue(Boolean.valueOf(bl2));
    }

    public final boolean isShowCheckedCount() {
        return this.showCheckedCount.getValue();
    }

    private static class CheckComboBoxBitSetCheckModel<T>
    extends CheckBitSetModelBase<T> {
        private final ObservableList<T> items;

        CheckComboBoxBitSetCheckModel(ObservableList<T> observableList, Map<T, BooleanProperty> map) {
            super(map);
            this.items = observableList;
            this.items.addListener(change -> this.updateMap());
            this.updateMap();
        }

        @Override
        public T getItem(int n2) {
            return (T)this.items.get(n2);
        }

        @Override
        public int getItemCount() {
            return this.items.size();
        }

        @Override
        public int getItemIndex(T t2) {
            return this.items.indexOf(t2);
        }
    }
}

