/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.collections.MappingChange;
import impl.org.controlsfx.collections.NonIterableChange;
import impl.org.controlsfx.collections.ReadOnlyUnbackedObservableList;
import java.util.BitSet;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import org.controlsfx.control.IndexedCheckModel;

abstract class CheckBitSetModelBase<T>
implements IndexedCheckModel<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private final BitSet checkedIndices;
    private final ReadOnlyUnbackedObservableList<Integer> checkedIndicesList;
    private final ReadOnlyUnbackedObservableList<T> checkedItemsList;

    CheckBitSetModelBase(Map<T, BooleanProperty> map) {
        this.itemBooleanMap = map;
        this.checkedIndices = new BitSet();
        this.checkedIndicesList = new ReadOnlyUnbackedObservableList<Integer>(){

            @Override
            public Integer get(int n2) {
                if (n2 < 0 || n2 >= CheckBitSetModelBase.this.getItemCount()) {
                    return -1;
                }
                int n3 = CheckBitSetModelBase.this.checkedIndices.nextSetBit(0);
                for (int i2 = 0; n3 >= 0 || i2 == n2; ++i2) {
                    if (i2 == n2) {
                        return n3;
                    }
                    n3 = CheckBitSetModelBase.this.checkedIndices.nextSetBit(n3 + 1);
                }
                return -1;
            }

            @Override
            public int size() {
                return CheckBitSetModelBase.this.checkedIndices.cardinality();
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Number) {
                    Number number = (Number)object;
                    int n2 = number.intValue();
                    return n2 >= 0 && n2 < CheckBitSetModelBase.this.checkedIndices.length() && CheckBitSetModelBase.this.checkedIndices.get(n2);
                }
                return false;
            }
        };
        this.checkedItemsList = new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int n2) {
                int n3 = CheckBitSetModelBase.this.checkedIndicesList.get(n2);
                if (n3 < 0 || n3 >= CheckBitSetModelBase.this.getItemCount()) {
                    return null;
                }
                return CheckBitSetModelBase.this.getItem(n3);
            }

            @Override
            public int size() {
                return CheckBitSetModelBase.this.checkedIndices.cardinality();
            }
        };
        MappingChange.Map<Integer, Object> map2 = n2 -> this.getItem((int)n2);
        this.checkedIndicesList.addListener(change -> {
            boolean bl2 = false;
            while (change.next() && !bl2) {
                bl2 = change.wasAdded() || change.wasRemoved();
            }
            if (bl2) {
                change.reset();
                this.checkedItemsList.callObservers(new MappingChange(change, map2, this.checkedItemsList));
            }
            change.reset();
        });
        this.getCheckedItems().addListener(change -> {
            while (change.next()) {
                BooleanProperty booleanProperty;
                if (change.wasAdded()) {
                    for (Object e2 : change.getAddedSubList()) {
                        booleanProperty = this.getItemBooleanProperty(e2);
                        if (booleanProperty == null) continue;
                        booleanProperty.set(true);
                    }
                }
                if (!change.wasRemoved()) continue;
                for (Object e2 : change.getRemoved()) {
                    booleanProperty = this.getItemBooleanProperty(e2);
                    if (booleanProperty == null) continue;
                    booleanProperty.set(false);
                }
            }
        });
    }

    @Override
    public abstract T getItem(int var1);

    @Override
    public abstract int getItemCount();

    @Override
    public abstract int getItemIndex(T var1);

    BooleanProperty getItemBooleanProperty(T t2) {
        return this.itemBooleanMap.get(t2);
    }

    @Override
    public ObservableList<Integer> getCheckedIndices() {
        return this.checkedIndicesList;
    }

    @Override
    public ObservableList<T> getCheckedItems() {
        return this.checkedItemsList;
    }

    @Override
    public void checkAll() {
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            this.check(i2);
        }
    }

    @Override
    public void checkIndices(int ... nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.check(nArray[i2]);
        }
    }

    @Override
    public void clearCheck(T t2) {
        int n2 = this.getItemIndex(t2);
        this.clearCheck(n2);
    }

    @Override
    public void clearChecks() {
        for (int i2 = 0; i2 < this.checkedIndices.length(); ++i2) {
            this.clearCheck(i2);
        }
    }

    @Override
    public void clearCheck(int n2) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        this.checkedIndices.clear(n2);
        int n3 = this.checkedIndicesList.indexOf(n2);
        this.checkedIndicesList.callObservers(new NonIterableChange.SimpleRemovedChange<Integer>(n3, n3, n2, (ObservableList<Integer>)this.checkedIndicesList));
    }

    @Override
    public boolean isEmpty() {
        return this.checkedIndices.isEmpty();
    }

    @Override
    public boolean isChecked(T t2) {
        int n2 = this.getItemIndex(t2);
        return this.isChecked(n2);
    }

    @Override
    public boolean isChecked(int n2) {
        return this.checkedIndices.get(n2);
    }

    @Override
    public void toggleCheckState(T t2) {
        int n2 = this.getItemIndex(t2);
        this.toggleCheckState(n2);
    }

    @Override
    public void toggleCheckState(int n2) {
        if (this.isChecked(n2)) {
            this.clearCheck(n2);
        } else {
            this.check(n2);
        }
    }

    @Override
    public void check(int n2) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        this.checkedIndices.set(n2);
        int n3 = this.checkedIndicesList.indexOf(n2);
        this.checkedIndicesList.callObservers(new NonIterableChange.SimpleAddChange<Integer>(n3, n3 + 1, (ObservableList<Integer>)this.checkedIndicesList));
    }

    @Override
    public void check(T t2) {
        int n2 = this.getItemIndex(t2);
        this.check(n2);
    }

    protected void updateMap() {
        this.itemBooleanMap.clear();
        int n2 = 0;
        while (n2 < this.getItemCount()) {
            int n3 = n2++;
            T t2 = this.getItem(n3);
            SimpleBooleanProperty simpleBooleanProperty = new SimpleBooleanProperty(t2, "selected", false);
            this.itemBooleanMap.put(t2, (BooleanProperty)simpleBooleanProperty);
            simpleBooleanProperty.addListener(new InvalidationListener((BooleanProperty)simpleBooleanProperty, n3){
                final /* synthetic */ BooleanProperty val$booleanProperty;
                final /* synthetic */ int val$index;
                {
                    this.val$booleanProperty = booleanProperty;
                    this.val$index = n2;
                }

                public void invalidated(Observable observable) {
                    if (this.val$booleanProperty.get()) {
                        CheckBitSetModelBase.this.checkedIndices.set(this.val$index);
                        int n2 = CheckBitSetModelBase.this.checkedIndicesList.indexOf(this.val$index);
                        CheckBitSetModelBase.this.checkedIndicesList.callObservers(new NonIterableChange.SimpleAddChange<Integer>(n2, n2 + 1, (ObservableList<Integer>)CheckBitSetModelBase.this.checkedIndicesList));
                    } else {
                        int n3 = CheckBitSetModelBase.this.checkedIndicesList.indexOf(this.val$index);
                        CheckBitSetModelBase.this.checkedIndices.clear(this.val$index);
                        CheckBitSetModelBase.this.checkedIndicesList.callObservers(new NonIterableChange.SimpleRemovedChange<Integer>(n3, n3, this.val$index, (ObservableList<Integer>)CheckBitSetModelBase.this.checkedIndicesList));
                    }
                }
            });
        }
    }
}

