/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.nio;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.Selector;
import org.agrona.LangUtil;
import org.agrona.nio.NioSelectedKeySet;

public class TransportPoller
implements AutoCloseable {
    public static final String ITERATION_THRESHOLD_PROP_NAME = "org.agrona.transport.iteration.threshold";
    public static final int ITERATION_THRESHOLD_DEFAULT = 5;
    public static final int ITERATION_THRESHOLD = Integer.getInteger("org.agrona.transport.iteration.threshold", 5);
    protected static final Field SELECTED_KEYS_FIELD;
    protected static final Field PUBLIC_SELECTED_KEYS_FIELD;
    private static final String SELECTOR_IMPL = "sun.nio.ch.SelectorImpl";
    protected final NioSelectedKeySet selectedKeySet = new NioSelectedKeySet();
    protected final Selector selector;

    public TransportPoller() {
        try {
            this.selector = Selector.open();
            SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
            PUBLIC_SELECTED_KEYS_FIELD.set(this.selector, this.selectedKeySet);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void close() {
        this.selector.wakeup();
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }

    public void selectNowWithoutProcessing() {
        try {
            this.selector.selectNow();
            this.selectedKeySet.clear();
        }
        catch (IOException iOException) {
            LangUtil.rethrowUnchecked(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Field field = null;
        Field field2 = null;
        try (Selector selector = Selector.open();){
            Class<?> clazz = Class.forName(SELECTOR_IMPL, false, ClassLoader.getSystemClassLoader());
            if (clazz.isAssignableFrom(selector.getClass())) {
                field = clazz.getDeclaredField("selectedKeys");
                field.setAccessible(true);
                field2 = clazz.getDeclaredField("publicSelectedKeys");
                field2.setAccessible(true);
            }
        }
        catch (Exception exception) {
            LangUtil.rethrowUnchecked(exception);
        }
        finally {
            SELECTED_KEYS_FIELD = field;
            PUBLIC_SELECTED_KEYS_FIELD = field2;
        }
    }
}

