/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.io;

import java.io.OutputStream;
import org.agrona.MutableDirectBuffer;

public class DirectBufferOutputStream
extends OutputStream {
    private MutableDirectBuffer buffer;
    private int offset;
    private int length;
    private int position;

    public DirectBufferOutputStream() {
    }

    public DirectBufferOutputStream(MutableDirectBuffer mutableDirectBuffer) {
        this.wrap(mutableDirectBuffer, 0, mutableDirectBuffer.capacity());
    }

    public DirectBufferOutputStream(MutableDirectBuffer mutableDirectBuffer, int n2, int n3) {
        this.wrap(mutableDirectBuffer, n2, n3);
    }

    public void wrap(MutableDirectBuffer mutableDirectBuffer) {
        this.wrap(mutableDirectBuffer, 0, mutableDirectBuffer.capacity());
    }

    public void wrap(MutableDirectBuffer mutableDirectBuffer, int n2, int n3) {
        if (null == mutableDirectBuffer) {
            throw new NullPointerException("buffer cannot be null");
        }
        this.buffer = mutableDirectBuffer;
        this.offset = n2;
        this.length = n3;
        this.position = 0;
    }

    public int position() {
        return this.position;
    }

    public int offset() {
        return this.offset;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int length() {
        return this.length;
    }

    @Override
    public void write(int n2) {
        if (this.position == this.length) {
            throw new IllegalStateException("position has reached the end of underlying buffer");
        }
        this.buffer.putByte(this.offset + this.position, (byte)n2);
        ++this.position;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        long l2 = (long)this.position + (long)n3;
        if (l2 > (long)this.length) {
            throw new IllegalStateException("insufficient capacity in the buffer");
        }
        this.buffer.putBytes(this.offset + this.position, byArray, n2, n3);
        this.position += n3;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

