/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.ringbuffer;

import org.agrona.BitUtil;

public final class RingBufferDescriptor {
    public static final int TAIL_POSITION_OFFSET;
    public static final int HEAD_CACHE_POSITION_OFFSET;
    public static final int HEAD_POSITION_OFFSET;
    public static final int CORRELATION_COUNTER_OFFSET;
    public static final int CONSUMER_HEARTBEAT_OFFSET;
    public static final int TRAILER_LENGTH;

    private RingBufferDescriptor() {
    }

    public static int checkCapacity(int n2, int n3) {
        int n4 = n2 - TRAILER_LENGTH;
        if (!BitUtil.isPowerOfTwo(n4)) {
            throw new IllegalArgumentException("capacity must be a positive power of 2 + TRAILER_LENGTH: capacity=" + n2);
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("insufficient capacity: minCapacity=" + (n3 + TRAILER_LENGTH) + ", capacity=" + n2);
        }
        return n4;
    }

    static {
        int n2 = 0;
        TAIL_POSITION_OFFSET = n2 += 128;
        HEAD_CACHE_POSITION_OFFSET = n2 += 128;
        HEAD_POSITION_OFFSET = n2 += 128;
        CORRELATION_COUNTER_OFFSET = n2 += 128;
        CONSUMER_HEARTBEAT_OFFSET = n2 += 128;
        TRAILER_LENGTH = n2 += 128;
    }
}

